/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import e3d.j3d.examples.TornadoChangeListener;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;

abstract class TornadoMouseBehavior
extends Behavior {
    protected Object m_Object = null;
    protected Point3f m_NewPos = new Point3f();
    protected Point3f m_OldPos = new Point3f();
    protected Vector3f m_TranslationVector = null;
    protected Transform3D m_Translation = new Transform3D();
    protected boolean m_bDragging = false;
    protected WakeupOr m_MouseCriterion = null;
    protected int m_nLastY = 0;
    protected Transform3D m_Transform3D = null;
    protected TornadoChangeListener m_Listener = null;

    public TornadoMouseBehavior() {
        this.m_TranslationVector = new Vector3f();
        this.m_Transform3D = new Transform3D();
    }

    public void setChangeListener(TornadoChangeListener listener) {
        this.m_Listener = listener;
    }

    protected abstract void applyVectorToObject(Vector3f var1);

    protected abstract boolean isStartBehaviorEvent(MouseEvent var1);

    protected void processMouseEvent(MouseEvent evt) {
        if (this.m_Object != null) {
            if (this.isStartBehaviorEvent(evt)) {
                this.adjustTransform(evt.getX(), evt.getY());
            } else if (this.isStopBehaviorEvent(evt)) {
                this.onEndDrag();
            }
        }
    }

    protected boolean isStopBehaviorEvent(MouseEvent evt) {
        int nId = evt.getID();
        return this.m_bDragging && nId == 502 || nId == 505;
    }

    protected boolean isRelativeToStartDrag() {
        return false;
    }

    protected boolean isRelativeToObjectCoordinates() {
        return true;
    }

    protected void onStartDrag() {
        if (this.m_Listener != null) {
            this.m_Listener.onStartDrag(this.m_Object);
        }
    }

    protected void onEndDrag() {
        this.m_bDragging = false;
        if (this.m_Listener != null) {
            this.m_Listener.onEndDrag(this.m_Object);
        }
    }

    protected void getObjectLocalToVworld(Transform3D t3d) {
        if (this.getTransformGroup() != null) {
            this.getTransformGroup().getLocalToVworld(t3d);
        }
    }

    protected void getImagePlateToVworld(Transform3D t3d) {
        this.getView().getCanvas3D(0).getImagePlateToVworld(t3d);
    }

    protected TransformGroup getTransformGroup() {
        if (this.m_Object instanceof TransformGroup) {
            return (TransformGroup)this.m_Object;
        }
        return null;
    }

    protected void applyTransform() {
        TransformGroup tg = this.getTransformGroup();
        if (tg != null) {
            try {
                tg.setTransform(this.m_Transform3D);
                if (this.m_Listener != null) {
                    this.m_Listener.onApplyTransform(this.m_Object);
                }
            }
            catch (Exception e) {
                System.err.println(e.toString());
            }
        }
    }

    protected void adjustTransform(int xpos, int ypos) {
        if (this.m_Listener != null) {
            this.m_Listener.onAdjustTransform(this.m_Object, xpos, ypos);
        }
        if (!this.m_bDragging) {
            this.m_OldPos.x = xpos;
            this.m_OldPos.y = ypos;
            this.m_OldPos.z = 0.0f;
            this.m_nLastY = ypos;
            this.onStartDrag();
        }
        this.m_bDragging = true;
        this.m_NewPos.x = xpos;
        this.m_NewPos.y = this.m_nLastY + (this.m_nLastY - ypos);
        this.m_NewPos.z = 0.0f;
        this.m_nLastY = ypos;
        this.getImagePlateToVworld(this.m_Translation);
        if (!this.isRelativeToStartDrag()) {
            this.m_Translation.transform(this.m_OldPos);
        }
        this.m_Translation.transform(this.m_NewPos);
        if (this.isRelativeToObjectCoordinates()) {
            this.getObjectLocalToVworld(this.m_Translation);
            this.m_Translation.transpose();
            if (!this.isRelativeToStartDrag()) {
                this.m_Translation.transform(this.m_OldPos);
            }
            this.m_Translation.transform(this.m_NewPos);
        }
        this.m_TranslationVector.sub((Tuple3f)this.m_NewPos, (Tuple3f)this.m_OldPos);
        this.applyVectorToObject(this.m_TranslationVector);
        if (!this.isRelativeToStartDrag()) {
            this.m_OldPos.x = xpos;
            this.m_OldPos.y = ypos;
            this.m_OldPos.z = 0.0f;
        }
    }

    public void processStimulus(Enumeration criteria) {
        if (this.m_Object != null) {
            while (criteria.hasMoreElements()) {
                WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
                if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
                AWTEvent[] event = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                int i = 0;
                while (i < event.length) {
                    this.processMouseEvent((MouseEvent)event[i]);
                    ++i;
                }
            }
        }
        this.wakeupOn((WakeupCondition)this.m_MouseCriterion);
    }

    public void initialize() {
        WakeupCriterion[] mouseEvents = new WakeupCriterion[]{new WakeupOnAWTEvent(506), new WakeupOnAWTEvent(501), new WakeupOnAWTEvent(502)};
        this.m_MouseCriterion = new WakeupOr(mouseEvents);
        this.wakeupOn((WakeupCondition)this.m_MouseCriterion);
    }

    public void setObject(Object obj) {
        this.m_Object = obj;
    }
}

