/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.geometry.Sphere;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3f;

public class Pick {
    public Pick() {
        Frame frame = new Frame("Box and Sphere");
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(config);
        canvas3D.setSize(400, 400);
        BranchGroup root = new BranchGroup();
        Vector3f vector = new Vector3f(-0.3f, 0.0f, 0.0f);
        Transform3D transform = new Transform3D();
        transform.setTranslation(vector);
        TransformGroup transformGroup = new TransformGroup(transform);
        ColorCube cube = new ColorCube(0.3);
        transformGroup.addChild((Node)cube);
        root.addChild((Node)transformGroup);
        Vector3f vector2 = new Vector3f(0.3f, 0.0f, 0.0f);
        Transform3D transform2 = new Transform3D();
        transform2.setTranslation(vector2);
        TransformGroup transformGroup2 = new TransformGroup(transform2);
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(new PolygonAttributes(1, 1, 0.0f));
        Sphere sphere = new Sphere(0.3f, appearance);
        transformGroup2.addChild((Node)sphere);
        root.addChild((Node)transformGroup2);
        root.compile();
        SimpleUniverse universe = new SimpleUniverse(canvas3D);
        universe.getViewingPlatform().setNominalViewingTransform();
        universe.addBranchGraph(root);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent winEvent) {
                System.exit(0);
            }
        });
        frame.add((Component)canvas3D);
        final PickCanvas pickCanvas = new PickCanvas(canvas3D, universe.getLocale());
        pickCanvas.setMode(256);
        canvas3D.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                pickCanvas.setShapeLocation(event);
                PickResult result = pickCanvas.pickClosest();
                if (result == null) {
                    System.out.println("Nothing picked");
                } else {
                    Primitive primitive = (Primitive)result.getNode(4);
                    Shape3D shape = (Shape3D)result.getNode(1);
                    if (primitive != null) {
                        System.out.println("Primitive: " + primitive.getClass().getName());
                    } else if (shape != null) {
                        System.out.println("Shape: " + shape.getClass().getName());
                    } else {
                        System.out.println("null");
                    }
                }
            }
        });
        canvas3D.repaint();
        frame.pack();
        frame.setVisible(true);
    }

    public void enablePicking(Node node) {
        Enumeration children;
        node.setPickable(true);
        node.setCapability(1);
        if (node instanceof Group) {
            Group group = (Group)node;
            children = group.getAllChildren();
            while (children.hasMoreElements()) {
                this.enablePicking((Node)children.nextElement());
            }
        }
        if (node instanceof Shape3D) {
            Shape3D shape = (Shape3D)node;
            PickTool.setCapabilities((Node)node, (int)4100);
            children = shape.getAllGeometries();
            while (children.hasMoreElements()) {
                Geometry geometry = (Geometry)children.nextElement();
                geometry.setCapability(18);
            }
        }
    }

    public static void main(String[] args) {
        new Pick();
    }
}

