/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.behaviors.mouse.MouseRotate;
import com.sun.j3d.utils.behaviors.mouse.MouseTranslate;
import com.sun.j3d.utils.behaviors.mouse.MouseZoom;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import javax.media.j3d.BoundingPolytope;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Vector3d;

public class MouseBehaviorApp
extends Applet {
    private static final long serialVersionUID = 1L;

    public BranchGroup createSceneGraph() {
        BranchGroup objRoot = new BranchGroup();
        TransformGroup objTransform = new TransformGroup();
        objTransform.setCapability(18);
        objTransform.setCapability(17);
        objRoot.addChild((Node)objTransform);
        ColorCube cube = new ColorCube(0.4);
        objTransform.addChild((Node)cube);
        MouseRotate myMouseRotate = new MouseRotate();
        myMouseRotate.setTransformGroup(objTransform);
        myMouseRotate.setSchedulingBounds((Bounds)new BoundingPolytope());
        objRoot.addChild((Node)myMouseRotate);
        MouseTranslate myMouseTranslate = new MouseTranslate(objTransform);
        myMouseTranslate.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseTranslate);
        MouseZoom myMouseZoom = new MouseZoom();
        myMouseZoom.setTransformGroup(objTransform);
        myMouseZoom.setSchedulingBounds((Bounds)new BoundingSphere());
        objRoot.addChild((Node)myMouseZoom);
        TransformGroup objTransform2 = new TransformGroup();
        Transform3D t2 = new Transform3D();
        t2.set(new Vector3d(0.3, 0.0, 0.0));
        objTransform2.setTransform(t2);
        objTransform2.setCapability(18);
        objTransform2.setCapability(17);
        objRoot.addChild((Node)objTransform2);
        ColorCube cube2 = new ColorCube(0.4);
        objTransform2.addChild((Node)cube2);
        MouseRotate myMouseRotate2 = new MouseRotate();
        myMouseRotate2.setTransformGroup(objTransform2);
        myMouseRotate2.setSchedulingBounds((Bounds)new BoundingPolytope());
        objRoot.addChild((Node)myMouseRotate2);
        objRoot.compile();
        return objRoot;
    }

    public MouseBehaviorApp() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration config = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(config);
        this.add("Center", (Component)canvas3D);
        BranchGroup scene = this.createSceneGraph();
        SimpleUniverse simpleU = new SimpleUniverse(canvas3D);
        simpleU.getViewingPlatform().setNominalViewingTransform();
        simpleU.addBranchGraph(scene);
    }

    public static void main(String[] args) {
        System.out.print("MouseBehaviorApp.java \n- a demonstration of using the mouse ");
        System.out.println("behavior utility classes to provide interaction in a Java 3D scene.");
        System.out.println("Hold the mouse button while moving the mouse to make the cube move.");
        System.out.println("     left mouse button      - rotate cube");
        System.out.println("     right mouse button     - translate cube");
        System.out.println("     Alt+left mouse button  - zoom cube");
        System.out.println("This is a simple example progam from The Java 3D API Tutorial.");
        System.out.println("The Java 3D Tutorial is available on the web at:");
        System.out.println("http://java.sun.com/products/java-media/3D/collateral");
        new MainFrame((Applet)new MouseBehaviorApp(), 256, 256);
    }
}

