/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import com.sun.j3d.audioengines.javasound.JavaSoundMixer;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Locale;
import javax.media.j3d.Node;
import javax.media.j3d.PhysicalBody;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.View;
import javax.media.j3d.ViewPlatform;
import javax.media.j3d.VirtualUniverse;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

abstract class Java3dApplet
extends Applet {
    private static final long serialVersionUID = 1L;
    public static int m_kWidth = 300;
    public static int m_kHeight = 300;
    protected String[] m_szCommandLineArray = null;
    protected VirtualUniverse m_Universe = null;
    protected BranchGroup m_SceneBranchGroup = null;
    protected Bounds m_ApplicationBounds = null;

    public boolean isApplet() {
        try {
            System.getProperty("user.dir");
            System.out.println("Running as Application.");
            return false;
        }
        catch (Exception exception) {
            System.out.println("Running as Applet.");
            return true;
        }
    }

    public URL getWorkingDirectory() throws MalformedURLException {
        try {
            File file = new File(System.getProperty("user.dir"));
            System.out.println("Running as Application:");
            System.out.println("   " + file.toURL());
            return file.toURL();
        }
        catch (Exception exception) {
            System.out.println("Running as Applet:");
            System.out.println("   " + this.getCodeBase());
            return this.getCodeBase();
        }
    }

    public VirtualUniverse getVirtualUniverse() {
        return this.m_Universe;
    }

    public Locale getFirstLocale() {
        Enumeration e = this.m_Universe.getAllLocales();
        if (e.hasMoreElements()) {
            return (Locale)e.nextElement();
        }
        return null;
    }

    protected Bounds getApplicationBounds() {
        if (this.m_ApplicationBounds == null) {
            this.m_ApplicationBounds = this.createApplicationBounds();
        }
        return this.m_ApplicationBounds;
    }

    protected Bounds createApplicationBounds() {
        this.m_ApplicationBounds = new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0);
        return this.m_ApplicationBounds;
    }

    protected Background createBackground() {
        Background back = new Background(new Color3f(0.9f, 0.9f, 0.9f));
        back.setApplicationBounds(this.createApplicationBounds());
        return back;
    }

    public void initJava3d() {
        this.m_Universe = this.createVirtualUniverse();
        Locale locale = this.createLocale(this.m_Universe);
        BranchGroup sceneBranchGroup = this.createSceneBranchGroup();
        ViewPlatform vp = this.createViewPlatform();
        BranchGroup viewBranchGroup = this.createViewBranchGroup(this.getViewTransformGroupArray(), vp);
        this.createView(vp);
        Background background = this.createBackground();
        if (background != null) {
            sceneBranchGroup.addChild((Node)background);
        }
        locale.addBranchGraph(sceneBranchGroup);
        this.addViewBranchGroup(locale, viewBranchGroup);
        this.onDoneInit();
    }

    protected void onDoneInit() {
    }

    protected double getScale() {
        return 1.0;
    }

    public TransformGroup[] getViewTransformGroupArray() {
        TransformGroup[] tgArray = new TransformGroup[]{new TransformGroup()};
        Transform3D t3d = new Transform3D();
        t3d.setScale(this.getScale());
        t3d.setTranslation(new Vector3d(0.0, 0.0, -20.0));
        t3d.invert();
        tgArray[0].setTransform(t3d);
        return tgArray;
    }

    protected void addViewBranchGroup(Locale locale, BranchGroup bg) {
        locale.addBranchGraph(bg);
    }

    protected Locale createLocale(VirtualUniverse u) {
        return new Locale(u);
    }

    protected BranchGroup createSceneBranchGroup() {
        this.m_SceneBranchGroup = new BranchGroup();
        return this.m_SceneBranchGroup;
    }

    protected View createView(ViewPlatform vp) {
        View view = new View();
        PhysicalBody pb = this.createPhysicalBody();
        PhysicalEnvironment pe = this.createPhysicalEnvironment();
        AudioDevice audioDevice = this.createAudioDevice(pe);
        if (audioDevice != null) {
            pe.setAudioDevice(audioDevice);
            audioDevice.initialize();
        }
        view.setPhysicalEnvironment(pe);
        view.setPhysicalBody(pb);
        if (vp != null) {
            view.attachViewPlatform(vp);
        }
        view.setBackClipDistance(this.getBackClipDistance());
        view.setFrontClipDistance(this.getFrontClipDistance());
        Canvas3D c3d = this.createCanvas3D();
        view.addCanvas3D(c3d);
        this.addCanvas3D(c3d);
        return view;
    }

    protected PhysicalBody createPhysicalBody() {
        return new PhysicalBody();
    }

    protected AudioDevice createAudioDevice(PhysicalEnvironment pe) {
        JavaSoundMixer javaSoundMixer = new JavaSoundMixer(pe);
        return javaSoundMixer;
    }

    protected PhysicalEnvironment createPhysicalEnvironment() {
        return new PhysicalEnvironment();
    }

    protected float getViewPlatformActivationRadius() {
        return 100.0f;
    }

    protected ViewPlatform createViewPlatform() {
        ViewPlatform vp = new ViewPlatform();
        vp.setViewAttachPolicy(2);
        vp.setActivationRadius(this.getViewPlatformActivationRadius());
        return vp;
    }

    protected Canvas3D createCanvas3D() {
        GraphicsConfigTemplate3D gc3D = new GraphicsConfigTemplate3D();
        gc3D.setSceneAntialiasing(2);
        GraphicsDevice[] gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        Canvas3D c3d = new Canvas3D(gd[0].getBestConfiguration((GraphicsConfigTemplate)gc3D));
        c3d.setSize(this.getCanvas3dWidth(c3d), this.getCanvas3dHeight(c3d));
        return c3d;
    }

    protected int getCanvas3dWidth(Canvas3D c3d) {
        return m_kWidth;
    }

    protected int getCanvas3dHeight(Canvas3D c3d) {
        return m_kHeight;
    }

    protected double getBackClipDistance() {
        return 100.0;
    }

    protected double getFrontClipDistance() {
        return 1.0;
    }

    protected BranchGroup createViewBranchGroup(TransformGroup[] tgArray, ViewPlatform vp) {
        BranchGroup vpBranchGroup = new BranchGroup();
        if (tgArray != null && tgArray.length > 0) {
            BranchGroup parentGroup = vpBranchGroup;
            TransformGroup curTg = null;
            int n = 0;
            while (n < tgArray.length) {
                curTg = tgArray[n];
                parentGroup.addChild((Node)curTg);
                parentGroup = curTg;
                ++n;
            }
            tgArray[tgArray.length - 1].addChild((Node)vp);
        } else {
            vpBranchGroup.addChild((Node)vp);
        }
        return vpBranchGroup;
    }

    protected void addCanvas3D(Canvas3D c3d) {
        this.setLayout(new BorderLayout());
        this.add((Component)c3d, "Center");
        this.doLayout();
    }

    protected VirtualUniverse createVirtualUniverse() {
        return new VirtualUniverse();
    }

    protected void saveCommandLineArguments(String[] szArgs) {
        this.m_szCommandLineArray = szArgs;
    }

    protected String[] getCommandLineArguments() {
        return this.m_szCommandLineArray;
    }
}

