/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.examples;

import com.sun.j3d.utils.applet.MainFrame;
import com.sun.j3d.utils.geometry.ColorCube;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import com.sun.j3d.utils.geometry.Stripifier;
import com.sun.j3d.utils.geometry.Text2D;
import com.sun.j3d.utils.pickfast.behaviors.PickRotateBehavior;
import com.sun.j3d.utils.pickfast.behaviors.PickTranslateBehavior;
import com.sun.j3d.utils.pickfast.behaviors.PickZoomBehavior;
import com.sun.j3d.utils.pickfast.behaviors.PickingCallback;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.util.Enumeration;
import javax.media.j3d.Appearance;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.PolygonAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Vector3d;

public class HelloWorld
extends Applet {
    private static final long serialVersionUID = 1L;

    public HelloWorld() {
        this.setLayout(new BorderLayout());
        GraphicsConfiguration graphConfig = SimpleUniverse.getPreferredConfiguration();
        Canvas3D canvas3D = new Canvas3D(graphConfig);
        this.add("Center", (Component)canvas3D);
        SimpleUniverse universe = new SimpleUniverse(canvas3D);
        BranchGroup text = this.createText();
        BranchGroup cube = this.createCube();
        BranchGroup poly = this.createPolygon();
        this.enableTranslation(poly, canvas3D);
        this.enableTranslation(cube, canvas3D);
        this.enableTranslation(text, canvas3D);
        universe.getViewingPlatform().setNominalViewingTransform();
        universe.addBranchGraph(cube);
        universe.addBranchGraph(text);
        universe.addBranchGraph(poly);
    }

    public BranchGroup createPolygon() {
        BranchGroup root = new BranchGroup();
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(new double[]{-0.5, -0.5, 0.0, 0.5, -0.5, 0.0, 0.5, 0.5, 0.0, -0.5, 0.5, 0.0});
        NormalGenerator normalGenerator = new NormalGenerator();
        normalGenerator.generateNormals(geometryInfo);
        geometryInfo.recomputeIndices();
        Stripifier stripifier = new Stripifier();
        stripifier.stripify(geometryInfo);
        geometryInfo.recomputeIndices();
        Shape3D polygon = new Shape3D();
        Appearance appearance = new Appearance();
        appearance.setPolygonAttributes(new PolygonAttributes(2, 1, 0.0f));
        ColoringAttributes coloringAttributes = new ColoringAttributes(0.1f, 1.0f, 1.0f, 0);
        appearance.setColoringAttributes(coloringAttributes);
        polygon.setAppearance(appearance);
        polygon.setGeometry((Geometry)geometryInfo.getGeometryArray());
        TransformGroup transform = new TransformGroup();
        root.addChild((Node)transform);
        transform.addChild((Node)polygon);
        this.enablePickingCapabilities(transform);
        return root;
    }

    public BranchGroup createCube() {
        BranchGroup root = new BranchGroup();
        ColorCube cube = new ColorCube(0.1);
        Transform3D rotationX = new Transform3D();
        Transform3D rotationY = new Transform3D();
        rotationX.rotX(0.7853981633974483);
        rotationY.rotY(0.6283185307179586);
        rotationX.mul(rotationY);
        TransformGroup transform = new TransformGroup(rotationX);
        this.enablePickingCapabilities(transform);
        root.addChild((Node)transform);
        transform.addChild((Node)cube);
        return root;
    }

    public BranchGroup createText() {
        BranchGroup root = new BranchGroup();
        Text2D text1 = new Text2D("Hello World", new Color3f(1.0f, 1.0f, 1.0f), "Helvetica", 18, 0);
        Transform3D trans = new Transform3D();
        trans.setTranslation(new Vector3d(0.1, 0.4, 0.2));
        TransformGroup translation = new TransformGroup(trans);
        this.enablePickingCapabilities(translation);
        root.addChild((Node)translation);
        translation.addChild((Node)text1);
        return root;
    }

    public void enableTranslation(BranchGroup branch, Canvas3D canvas3d) {
        BoundingSphere behaveBounds = new BoundingSphere();
        PickRotateBehavior pickRotate = new PickRotateBehavior(branch, canvas3d, (Bounds)behaveBounds);
        branch.addChild((Node)pickRotate);
        PickTranslateBehavior pickTranslate = new PickTranslateBehavior(branch, canvas3d, (Bounds)behaveBounds);
        branch.addChild((Node)pickTranslate);
        PickZoomBehavior pickZoom = new PickZoomBehavior(branch, canvas3d, (Bounds)behaveBounds);
        branch.addChild((Node)pickZoom);
        PickingCallback myCallback = new PickingCallback(){

            public void transformChanged(int type, TransformGroup tg) {
                System.out.println("pick");
            }
        };
        pickTranslate.setupCallback(myCallback);
    }

    public void enablePickingCapabilities(TransformGroup transformGroup) {
        transformGroup.setCapability(18);
        transformGroup.setCapability(17);
        transformGroup.setCapability(1);
    }

    public void enablePicking(Node node) {
        Enumeration children;
        node.setPickable(true);
        node.setCapability(1);
        if (node instanceof Group) {
            Group group = (Group)node;
            children = group.getAllChildren();
            while (children.hasMoreElements()) {
                this.enablePicking((Node)children.nextElement());
            }
        }
        if (node instanceof Shape3D) {
            Shape3D shape = (Shape3D)node;
            PickTool.setCapabilities((Node)node, (int)4100);
            children = shape.getAllGeometries();
            while (children.hasMoreElements()) {
                Geometry geometry = (Geometry)children.nextElement();
                geometry.setCapability(18);
            }
        }
    }

    public static void main(String[] args) {
        new MainFrame((Applet)new HelloWorld(), 800, 600);
    }
}

