/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import e3d.j3d.behaviors.J3DMouseBehaviorCallback;
import e3d.j3d.behaviors.J3DMouseRotate;
import e3d.j3d.behaviors.J3DPickMouseBehavior;
import e3d.j3d.behaviors.J3DPickingCallback;
import e3d.j3d.objects.util.J3DAnchor;
import java.util.HashSet;
import java.util.Set;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;

public class J3DPickRotateBehavior
extends J3DPickMouseBehavior
implements J3DMouseBehaviorCallback {
    private final Set<J3DAnchor> compensateAnchors = new HashSet<J3DAnchor>();
    private final J3DMouseRotate rotate = new J3DMouseRotate(1);
    private J3DPickingCallback callback = null;
    private J3DAnchor currentAnchor;
    protected boolean enabled = true;

    public J3DPickRotateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds) {
        super(canvas, root, bounds);
        this.rotate.setAnchor(this.anchor);
        this.anchor.addChild((Node)this.rotate);
        this.rotate.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
    }

    public J3DPickRotateBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, int pickMode) {
        super(canvas, root, bounds);
        this.rotate.setAnchor(this.anchor);
        this.anchor.addChild((Node)this.rotate);
        this.rotate.setSchedulingBounds(bounds);
        this.setSchedulingBounds(bounds);
        this.setMode(pickMode);
    }

    @Override
    public void updateScene(int xpos, int ypos) {
        if (this.enabled) {
            J3DAnchor anchor;
            this.pickCanvas.setShapeLocation(xpos, ypos);
            PickResult pickResult = this.pickCanvas.pickClosest();
            if (pickResult != null && (anchor = (J3DAnchor)pickResult.getNode(32)) != null && anchor.getCapability(17) && anchor.getCapability(18)) {
                if (this.compensateAnchors.contains((Object)anchor) && pickResult.numIntersections() > 0) {
                    PickIntersection intersection = pickResult.getIntersection(0);
                    Point3d point = intersection.getPointCoordinates();
                    Transform3D transform = new Transform3D();
                    anchor.getTransform(transform);
                    transform.transform(point);
                    this.rotate.setReferencePoint(point);
                } else {
                    this.rotate.setReferencePoint(null);
                }
                this.rotate.setAnchor(anchor);
                this.rotate.wakeup();
                this.currentAnchor = anchor;
            } else if (this.callback != null) {
                this.callback.transformChanged(3, null);
            }
        }
    }

    @Override
    public void transformChanged(int type, Transform3D transform) {
        this.callback.transformChanged(0, this.currentAnchor);
    }

    @Override
    public void transformFinished(int type, Transform3D transform) {
        this.callback.transformFinished(0, this.currentAnchor);
    }

    @Override
    public void setupCallback(J3DPickingCallback callback) {
        this.callback = callback;
        if (callback == null) {
            this.rotate.setupCallback(null);
        } else {
            this.rotate.setupCallback(this);
        }
    }

    @Override
    public void setScalingFactor(double factor) {
        this.rotate.setScalingFactor(factor);
    }

    @Override
    public double getScalingFactor() {
        return this.rotate.getScalingFactor();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        this.rotate.setEnabled(enabled);
    }

    public void addCompensateAnchor(J3DAnchor anchor) {
        this.compensateAnchors.add(anchor);
    }

    public void removeCompensateAnchor(J3DAnchor anchor) {
        this.compensateAnchors.remove((Object)anchor);
    }
}

