/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.utils.picking.PickCanvas;
import e3d.j3d.objects.util.J3DAnchor;
import java.awt.AWTEvent;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import javax.media.j3d.Behavior;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOr;

public abstract class J3DPickMouseBehavior
extends Behavior {
    protected PickCanvas pickCanvas;
    protected WakeupCriterion[] conditions;
    protected WakeupOr wakeupCondition;
    protected boolean buttonPress = false;
    protected J3DAnchor anchor = new DummyAnchor();
    protected MouseEvent mouseEvent;

    public J3DPickMouseBehavior(Canvas3D canvas, BranchGroup root, Bounds bounds) {
        this.anchor.setCapability(18);
        this.anchor.setCapability(17);
        root.addChild((Node)this.anchor);
        this.pickCanvas = new PickCanvas(canvas, root);
    }

    public void setMode(int pickMode) {
        this.pickCanvas.setMode(pickMode);
    }

    public int getMode() {
        return this.pickCanvas.getMode();
    }

    public void setTolerance(float tolerance) {
        this.pickCanvas.setTolerance(tolerance);
    }

    public float getTolerance() {
        return this.pickCanvas.getTolerance();
    }

    public void initialize() {
        this.conditions = new WakeupCriterion[2];
        this.conditions[0] = new WakeupOnAWTEvent(503);
        this.conditions[1] = new WakeupOnAWTEvent(501);
        this.wakeupCondition = new WakeupOr(this.conditions);
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    private void processMouseEvent(MouseEvent evt) {
        this.buttonPress = false;
        if (evt.getID() == 501 || evt.getID() == 500) {
            this.buttonPress = true;
            return;
        }
        evt.getID();
    }

    public void processStimulus(Enumeration criteria) {
        AWTEvent[] evt = null;
        int xPos = 0;
        int yPos = 0;
        while (criteria.hasMoreElements()) {
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (!(wakeup instanceof WakeupOnAWTEvent)) continue;
            evt = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
        }
        if (evt[0] instanceof MouseEvent) {
            this.mouseEvent = (MouseEvent)evt[0];
            this.processMouseEvent((MouseEvent)evt[0]);
            xPos = this.mouseEvent.getPoint().x;
            yPos = this.mouseEvent.getPoint().y;
        }
        if (this.buttonPress) {
            this.updateScene(xPos, yPos);
        }
        this.wakeupOn((WakeupCondition)this.wakeupCondition);
    }

    public abstract void updateScene(int var1, int var2);

    private static class DummyAnchor
    extends J3DAnchor {
        private DummyAnchor() {
        }

        @Override
        public void transformationFinished(int type) {
        }

        @Override
        public void transformed(int type) {
        }
    }
}

