/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import e3d.j3d.behaviors.J3DMouseBehavior;
import e3d.j3d.behaviors.J3DMouseBehaviorCallback;
import e3d.j3d.objects.util.J3DAnchor;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.Vector3d;

public class J3DMouseTranslate
extends J3DMouseBehavior {
    protected double scalingFactor = 0.02;
    private MouseBehaviorCallback callback = null;
    private boolean translated = false;
    protected boolean enabled = true;

    public J3DMouseTranslate(J3DAnchor anchor) {
        super(anchor);
    }

    public J3DMouseTranslate() {
        super(0);
    }

    public J3DMouseTranslate(int flags) {
        super(flags);
    }

    public J3DMouseTranslate(Component component) {
        super(component, 0);
    }

    public J3DMouseTranslate(Component component, J3DAnchor anchor) {
        super(component, anchor);
    }

    public J3DMouseTranslate(Component component, int flags) {
        super(component, flags);
    }

    @Override
    public void initialize() {
        super.initialize();
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.scalingFactor *= -1.0;
        }
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double factor) {
        this.scalingFactor = factor;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent event;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                event = (MouseEvent)events[events.length - 1];
                this.doProcess(event);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseQueue;
                synchronized (linkedList) {
                    if (this.mouseQueue.isEmpty()) {
                        continue block3;
                    }
                    event = (MouseEvent)this.mouseQueue.remove(0);
                    while (event.getID() == 506 && !this.mouseQueue.isEmpty() && ((MouseEvent)this.mouseQueue.get(0)).getID() == 506) {
                        event = (MouseEvent)this.mouseQueue.remove(0);
                    }
                }
                this.doProcess(event);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    protected void doProcess(MouseEvent event) {
        int id = event.getID();
        if (this.enabled && ((id == 501 || id == 502 || id == 506) && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0)) {
            if (id == 506 && !event.isAltDown() && event.isMetaDown()) {
                this.x = event.getX();
                this.y = event.getY();
                int dx = this.x - this.x_last;
                int dy = this.y - this.y_last;
                if (!this.reset && Math.abs(dy) < 50 && Math.abs(dx) < 50) {
                    this.anchor.getTransform(this.transform);
                    Vector3d translation = new Vector3d((double)dx * this.scalingFactor, (double)(-dy) * this.scalingFactor, 0.0);
                    Transform3D worldTransform = new Transform3D();
                    this.anchor.getLocalToVworldTranslation(worldTransform);
                    worldTransform.transpose();
                    worldTransform.transform(translation);
                    Transform3D transformXY = new Transform3D();
                    transformXY.set(translation);
                    if (this.invert) {
                        this.transform.mul(this.transform, transformXY);
                    } else {
                        this.transform.mul(transformXY, this.transform);
                    }
                    this.anchor.setTransform(this.transform);
                    this.transformChanged(this.transform);
                    if (this.callback != null) {
                        this.callback.transformChanged(1, this.transform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
                this.translated = true;
            } else if (id == 501) {
                this.x_last = event.getX();
                this.y_last = event.getY();
                this.translated = false;
            } else if (id == 502 && this.translated && this.callback instanceof J3DMouseBehaviorCallback) {
                ((J3DMouseBehaviorCallback)this.callback).transformFinished(0, this.transform);
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

