/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d.behaviors;

import com.sun.j3d.utils.behaviors.mouse.MouseBehaviorCallback;
import e3d.j3d.behaviors.J3DMouseBehavior;
import e3d.j3d.behaviors.J3DMouseBehaviorCallback;
import e3d.j3d.objects.util.J3DAnchor;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.media.j3d.Transform3D;
import javax.media.j3d.WakeupCondition;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupOnAWTEvent;
import javax.media.j3d.WakeupOnBehaviorPost;
import javax.vecmath.AxisAngle4d;
import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class J3DMouseRotate
extends J3DMouseBehavior {
    private static final Vector3d ORIGIN = new Vector3d(0.0, 0.0, 0.0);
    protected double xAngle;
    protected double yAngle;
    protected double scalingFactor = 0.03;
    private MouseBehaviorCallback callback = null;
    private boolean rotated = false;
    protected Point3d refPoint = null;
    protected boolean enabled = true;

    public J3DMouseRotate(J3DAnchor anchor) {
        super(anchor);
    }

    public J3DMouseRotate() {
        super(0);
    }

    public J3DMouseRotate(int flags) {
        super(flags);
    }

    public J3DMouseRotate(Component component) {
        super(component, 0);
    }

    public J3DMouseRotate(Component component, J3DAnchor anchor) {
        super(component, anchor);
    }

    public J3DMouseRotate(Component component, int flags) {
        super(component, flags);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.yAngle = 0.0;
        this.xAngle = 0.0;
        if ((this.flags & 2) == 2) {
            this.invert = true;
            this.scalingFactor *= -1.0;
        }
    }

    public double getScalingFactor() {
        return this.scalingFactor;
    }

    public void setScalingFactor(double factor) {
        this.scalingFactor = factor;
    }

    public Point3d getReferencePoint() {
        return this.refPoint;
    }

    public void setReferencePoint(Point3d point) {
        this.refPoint = point;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStimulus(Enumeration criteria) {
        block3: while (criteria.hasMoreElements()) {
            MouseEvent event;
            WakeupCriterion wakeup = (WakeupCriterion)criteria.nextElement();
            if (wakeup instanceof WakeupOnAWTEvent) {
                AWTEvent[] events = ((WakeupOnAWTEvent)wakeup).getAWTEvent();
                if (events.length <= 0) continue;
                event = (MouseEvent)events[events.length - 1];
                this.doProcess(event);
                continue;
            }
            if (!(wakeup instanceof WakeupOnBehaviorPost)) continue;
            while (true) {
                LinkedList linkedList = this.mouseQueue;
                synchronized (linkedList) {
                    if (this.mouseQueue.isEmpty()) {
                        continue block3;
                    }
                    event = (MouseEvent)this.mouseQueue.remove(0);
                    while (event.getID() == 506 && !this.mouseQueue.isEmpty() && ((MouseEvent)this.mouseQueue.get(0)).getID() == 506) {
                        event = (MouseEvent)this.mouseQueue.remove(0);
                    }
                }
                this.doProcess(event);
            }
        }
        this.wakeupOn((WakeupCondition)this.mouseCriterion);
    }

    protected void doProcess(MouseEvent event) {
        int id = event.getID();
        if (this.enabled && ((id == 501 || id == 502 || id == 506) && (this.flags & 1) == 0 || this.wakeUp && (this.flags & 1) != 0)) {
            if (id == 506 && !event.isMetaDown() && !event.isAltDown()) {
                this.x = event.getX();
                this.y = event.getY();
                int dx = this.x - this.x_last;
                int dy = this.y - this.y_last;
                if (!this.reset) {
                    Point3d point;
                    this.xAngle = (double)dy * this.scalingFactor;
                    this.yAngle = (double)dx * this.scalingFactor;
                    Transform3D transformX = new Transform3D();
                    Transform3D transformY = new Transform3D();
                    transformX.rotX(this.xAngle);
                    transformY.rotY(this.yAngle);
                    Transform3D worldTransform = new Transform3D();
                    this.anchor.getLocalToVworldRotation(worldTransform);
                    worldTransform.transpose();
                    Vector3d initial = new Vector3d(0.0, 0.0, 1.0);
                    Vector3d rotated = new Vector3d(0.0, 0.0, 1.0);
                    transformX.transform(rotated);
                    transformY.transform(rotated);
                    worldTransform.transform(initial);
                    worldTransform.transform(rotated);
                    Vector3d axis = new Vector3d();
                    axis.cross(initial, rotated);
                    Transform3D transformXY = new Transform3D();
                    transformXY.set(new AxisAngle4d(axis, rotated.angle(initial)));
                    this.anchor.getTransform(this.transform);
                    Matrix4d mat = new Matrix4d();
                    this.transform.get(mat);
                    Point3d point3d = point = this.refPoint == null ? null : new Point3d(this.refPoint);
                    if (point != null) {
                        Transform3D invers = new Transform3D();
                        invers.invert(this.transform);
                        invers.transform(point);
                    }
                    this.transform.setTranslation(ORIGIN);
                    if (this.invert) {
                        this.transform.mul(this.transform, transformXY);
                    } else {
                        this.transform.mul(transformXY, this.transform);
                    }
                    Vector3d translation = new Vector3d(mat.m03, mat.m13, mat.m23);
                    this.transform.setTranslation(translation);
                    if (point != null) {
                        this.transform.transform(point);
                        Vector3d offset = new Vector3d(point.x - this.refPoint.x, point.y - this.refPoint.y, point.z - this.refPoint.z);
                        translation.sub((Tuple3d)offset);
                        this.transform.setTranslation(translation);
                    }
                    this.anchor.setTransform(this.transform);
                    this.transformChanged(this.transform);
                    if (this.callback != null) {
                        this.callback.transformChanged(0, this.transform);
                    }
                } else {
                    this.reset = false;
                }
                this.x_last = this.x;
                this.y_last = this.y;
                this.rotated = true;
            } else if (id == 501) {
                this.x_last = event.getX();
                this.y_last = event.getY();
                this.rotated = false;
            } else if (id == 502) {
                if (this.rotated && this.callback instanceof J3DMouseBehaviorCallback) {
                    ((J3DMouseBehaviorCallback)this.callback).transformFinished(0, this.transform);
                }
                this.wakeUp = false;
            }
        }
    }

    public void transformChanged(Transform3D transform) {
    }

    public void setupCallback(MouseBehaviorCallback callback) {
        this.callback = callback;
    }
}

