/*
 * Decompiled with CFR 0.152.
 */
package e3d.j3d;

import com.sun.j3d.utils.geometry.Primitive;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickIntersection;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.PickTool;
import com.sun.j3d.utils.universe.SimpleUniverse;
import e3d.j3d.behaviors.J3DPickRotateBehavior;
import e3d.j3d.behaviors.J3DPickTranslateBehavior;
import e3d.j3d.behaviors.J3DPickZoomBehavior;
import e3d.j3d.behaviors.J3DPickingCallback;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DObject;
import e3d.j3d.objects.J3DSceneGroup;
import e3d.j3d.objects.J3DSelectionGroup;
import e3d.j3d.objects.util.J3DAnchor;
import e3d.j3d.objects.util.J3DAtomicPart;
import e3d.j3d.util.J3DEventListener;
import e3d.j3d.util.J3DLockListener;
import e3d.j3d.util.J3DSceneView;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.Node;
import javax.media.j3d.PickCylinderSegment;
import javax.media.j3d.PickShape;
import javax.media.j3d.Shape3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;

public class J3DCanvas
extends Canvas3D {
    private static final long serialVersionUID = 1L;
    private static final double DEFAULT_ZOOM_FACTOR = 0.2;
    protected MouseEvent lastMouseEvent = null;
    protected Set<Integer> pressedKeyCodes = new HashSet<Integer>();
    protected J3DAtomicPart typed = null;
    protected final SimpleUniverse universe;
    protected final transient BranchGroup main;
    protected final transient J3DSceneGroup scene;
    protected final transient J3DSelectionGroup selection;
    protected final J3DGroup hidden;
    protected final transient J3DGroup lights;
    protected final PickCanvas pickCanvas;
    protected final J3DPickZoomBehavior pickZoom;
    protected final J3DPickRotateBehavior pickRotate;
    protected final J3DPickTranslateBehavior pickTranslate;
    protected final PickCylinderSegment pickCylinder;
    protected final PickTool pickTool;
    protected double viewDistance = 10.0;
    protected double minZoomFactor = 0.1;
    protected boolean traceMouseMotions = false;
    protected final Set<Lock> locks = new HashSet<Lock>();
    protected final CopyOnWriteArrayList<J3DEventListener> eventListeners = new CopyOnWriteArrayList();
    protected final CopyOnWriteArrayList<J3DLockListener> lockListeners = new CopyOnWriteArrayList();

    public J3DCanvas() {
        super(SimpleUniverse.getPreferredConfiguration());
        this.universe = new SimpleUniverse((Canvas3D)this);
        this.getView().setProjectionPolicy(0);
        this.getView().setTransparencySortingPolicy(1);
        this.getView().getViewPlatform().setViewAttachPolicy(2);
        this.scene = new J3DSceneGroup(J3DSceneGroup.getDefaultParameters());
        this.selection = new J3DSelectionGroup(J3DSelectionGroup.getDefaultParameters());
        this.hidden = new J3DGroup(J3DGroup.getDefaultParameters());
        this.lights = new J3DGroup(J3DGroup.getDefaultParameters());
        this.main = new MainGroup();
        this.main.addChild((Node)this.scene);
        this.main.addChild((Node)this.lights);
        this.scene.addObject(this.selection);
        this.scene.compile();
        this.selection.compile();
        this.hidden.compile();
        this.lights.compile();
        BoundingSphere bounds = new BoundingSphere();
        this.pickZoom = new J3DPickZoomBehavior(this.main, this, (Bounds)bounds);
        this.pickRotate = new J3DPickRotateBehavior(this.main, this, (Bounds)bounds);
        this.pickTranslate = new J3DPickTranslateBehavior(this.main, this, (Bounds)bounds);
        this.configurePickingBehaviors();
        this.setViewDistance(this.viewDistance);
        this.getView().setFrontClipDistance(0.1);
        this.getView().setBackClipDistance(1000.0);
        if (this.getView().getProjectionPolicy() == 0) {
            this.getView().setScreenScalePolicy(1);
            this.getView().setScreenScale(0.2);
        }
        this.main.addChild((Node)this.pickZoom);
        this.main.addChild((Node)this.pickRotate);
        this.main.addChild((Node)this.pickTranslate);
        this.pickCanvas = this.createPickCanvas();
        this.pickCylinder = new PickCylinderSegment();
        this.pickTool = new PickTool((BranchGroup)this.scene);
        this.pickTool.setShape((PickShape)this.pickCylinder, new Point3d(0.0, 0.0, 0.0));
        this.main.compile();
        this.universe.addBranchGraph(this.main);
    }

    public void dispose() {
        this.universe.removeAllLocales();
        this.universe.cleanup();
    }

    public void addEventListener(J3DEventListener listener) {
        this.eventListeners.add(listener);
    }

    public void removeEventListener(J3DEventListener listener) {
        this.eventListeners.remove(listener);
    }

    public void addLockListener(J3DLockListener listener) {
        this.lockListeners.add(listener);
    }

    public void removeLockListener(J3DLockListener listener) {
        this.lockListeners.remove(listener);
    }

    protected void clicked(J3DInstance object, MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.eventListeners) {
            listener.clicked(object, event, intersection);
        }
    }

    protected void movedOver(J3DInstance object, MouseEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.eventListeners) {
            listener.movedOver(object, event, intersection);
        }
    }

    protected void typed(J3DInstance object, KeyEvent event, PickIntersection intersection) {
        for (J3DEventListener listener : this.eventListeners) {
            listener.typed(object, event, intersection);
        }
    }

    protected void released(J3DInstance object, KeyEvent event) {
        for (J3DEventListener listener : this.eventListeners) {
            listener.released(object, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock lock() {
        Set<Lock> set = this.locks;
        synchronized (set) {
            boolean wasAlreadyLocked = this.isLocked();
            Lock lock = new Lock();
            this.locks.add(lock);
            this.stopRenderer();
            if (!wasAlreadyLocked) {
                for (J3DLockListener listener : this.lockListeners) {
                    listener.locked();
                }
            }
            return lock;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Lock lock) {
        Set<Lock> set = this.locks;
        synchronized (set) {
            this.locks.remove(lock);
            if (!this.isLocked()) {
                this.startRenderer();
                for (J3DLockListener listener : this.lockListeners) {
                    listener.unlocked();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlockAll() {
        Set<Lock> set = this.locks;
        synchronized (set) {
            this.locks.clear();
            this.startRenderer();
        }
    }

    public boolean isLocked() {
        return !this.locks.isEmpty();
    }

    public void setTraceMouseMotions(boolean trace) {
        this.traceMouseMotions = trace;
    }

    public J3DSceneGroup getScene() {
        return this.scene;
    }

    public J3DSelectionGroup getSelection() {
        return this.selection;
    }

    public J3DGroup getHidden() {
        return this.hidden;
    }

    public J3DGroup getLights() {
        return this.lights;
    }

    public J3DSceneView getSceneView() {
        return new J3DSceneView(this.scene);
    }

    public void setSceneView(J3DSceneView view, boolean recenter) {
        view.setView(this.scene, recenter);
    }

    public boolean isParallelProjection() {
        return this.getView().getProjectionPolicy() == 0;
    }

    public void setParallelProjection(boolean enable) {
        if (enable) {
            this.getView().setProjectionPolicy(0);
        } else {
            this.getView().setProjectionPolicy(1);
        }
    }

    public double getMinZoom() {
        return this.minZoomFactor;
    }

    public void setMinZoom(double factor) {
        this.minZoomFactor = factor;
    }

    public double getZoom() {
        return this.getView().getScreenScale();
    }

    public void setZoom(double factor) {
        this.getView().setScreenScale(Math.max(this.minZoomFactor, factor));
        this.setScalingFactors();
    }

    public double getViewDistance() {
        return this.viewDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setViewDistance(double distance) {
        Set<Lock> set = this.locks;
        synchronized (set) {
            Lock lock = this.lock();
            try {
                this.viewDistance = distance;
                this.getView().setFieldOfView(Math.atan(1.0 / (this.viewDistance + 1.0)) * 2.0);
                this.pickZoom.setScalingFactor(0.002 / this.getZoom());
            }
            finally {
                this.unlock(lock);
            }
        }
    }

    public void enableMouseBehaviors(boolean enable) {
        this.pickZoom.setEnabled(enable);
        this.pickRotate.setEnabled(enable);
        this.pickTranslate.setEnabled(enable);
    }

    public void addRotationCompensatingAnchor(J3DAnchor anchor) {
        this.pickRotate.addCompensateAnchor(anchor);
    }

    public void removeRotationCompensatingAnchor(J3DAnchor anchor) {
        this.pickRotate.removeCompensateAnchor(anchor);
    }

    public Set<J3DInstance> getObjects(Point3d center, double radius) {
        Point3d origin = new Point3d(center.x, center.y, center.z + radius);
        Point3d end = new Point3d(center.x, center.y, center.z - radius);
        this.scene.transformScene(origin);
        this.scene.transformScene(end);
        this.pickCylinder.set(origin, end, radius);
        PickResult[] picked = this.pickTool.pickAll();
        if (picked == null) {
            return Collections.emptySet();
        }
        HashSet<J3DInstance> objects = new HashSet<J3DInstance>(picked.length);
        PickResult[] pickResultArray = picked;
        int n = picked.length;
        int n2 = 0;
        while (n2 < n) {
            PickResult pick = pickResultArray[n2];
            if (pick.getObject().getUserData() instanceof J3DInstance) {
                objects.add((J3DObject)pick.getObject().getUserData());
            }
            ++n2;
        }
        return objects;
    }

    protected void configurePickingBehaviors() {
        this.pickZoom.setMode(256);
        this.pickRotate.setMode(256);
        this.pickTranslate.setMode(256);
        this.pickZoom.setCanvas(this);
        this.pickZoom.setSceneGroup(this.scene.getAnchor());
        this.pickRotate.addCompensateAnchor(this.scene.getAnchor());
        this.pickRotate.addCompensateAnchor(this.selection.getAnchor());
        this.setScalingFactors();
        J3DPickingCallback callback = new J3DPickingCallback(){

            @Override
            public void transformChanged(int type, TransformGroup group) {
                if (group != null && group instanceof J3DAnchor) {
                    ((J3DAnchor)group).transformed(type);
                }
            }

            @Override
            public void transformFinished(int type, TransformGroup group) {
                if (group != null && group instanceof J3DAnchor) {
                    ((J3DAnchor)group).transformationFinished(type);
                }
            }
        };
        this.pickZoom.setupCallback(callback);
        this.pickRotate.setupCallback(callback);
        this.pickTranslate.setupCallback(callback);
    }

    private void setScalingFactors() {
        Dimension size = this.getSize();
        double factor = (double)size.width / 250.0;
        this.pickZoom.setScalingFactor(0.002 / this.getZoom());
        this.pickRotate.setScalingFactor(0.01);
        this.pickTranslate.setScalingFactor(0.002 / factor / this.getZoom());
    }

    protected PickCanvas createPickCanvas() {
        PickCanvas pickCanvas = new PickCanvas((Canvas3D)this, this.universe.getLocale());
        final J3DCanvas me = this;
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent event) {
                J3DCanvas.this.lastMouseEvent = event;
                me.mouseClicked(event);
            }

            @Override
            public void mouseEntered(MouseEvent event) {
            }

            @Override
            public void mouseExited(MouseEvent event) {
            }

            @Override
            public void mousePressed(MouseEvent event) {
                J3DCanvas.this.lastMouseEvent = event;
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                J3DCanvas.this.lastMouseEvent = event;
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent event) {
                me.mouseDragged(event);
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                me.mouseMoved(event);
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent event) {
                event.consume();
            }

            @Override
            public void keyReleased(KeyEvent event) {
                event.consume();
            }

            @Override
            public void keyPressed(KeyEvent event) {
                event.consume();
            }
        });
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentHidden(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                me.setScalingFactors();
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }
        });
        return pickCanvas;
    }

    protected void mouseClicked(MouseEvent event) {
        this.pickCanvas.setMode(256);
        this.pickCanvas.setShapeLocation(event);
        PickResult result = this.pickCanvas.pickClosest();
        if (result == null) {
            this.clicked(null, event, null);
        } else {
            PickIntersection intersection = result.getClosestIntersection(new Point3d(0.0, 0.0, this.getViewDistance()));
            Primitive primitive = (Primitive)result.getNode(4);
            Shape3D shape = (Shape3D)result.getNode(1);
            if (primitive instanceof J3DAtomicPart) {
                J3DAtomicPart clicked = (J3DAtomicPart)primitive;
                clicked.clicked(event, intersection);
                this.clicked(clicked.getObject(), event, intersection);
            } else if (shape instanceof J3DAtomicPart) {
                J3DAtomicPart clicked = (J3DAtomicPart)shape;
                clicked.clicked(event, intersection);
                this.clicked(clicked.getObject(), event, intersection);
            } else {
                this.clicked(null, event, null);
            }
        }
    }

    protected void mouseMoved(MouseEvent event) {
        this.lastMouseEvent = event;
        if (this.traceMouseMotions) {
            this.pickCanvas.setMode(256);
            this.pickCanvas.setShapeLocation(event);
            PickResult result = this.pickCanvas.pickClosest();
            if (result == null) {
                this.movedOver(null, event, null);
            } else {
                PickIntersection intersection = result.getClosestIntersection(new Point3d(0.0, 0.0, this.getViewDistance()));
                Primitive primitive = (Primitive)result.getNode(4);
                Shape3D shape = (Shape3D)result.getNode(1);
                if (primitive instanceof J3DAtomicPart) {
                    J3DAtomicPart movedOver = (J3DAtomicPart)primitive;
                    movedOver.movedOver(event, intersection);
                    this.movedOver(movedOver.getObject(), event, intersection);
                } else if (shape instanceof J3DAtomicPart) {
                    J3DAtomicPart movedOver = (J3DAtomicPart)shape;
                    movedOver.movedOver(event, intersection);
                    this.movedOver(movedOver.getObject(), event, intersection);
                } else {
                    this.movedOver(null, event, null);
                }
            }
        }
    }

    protected void mouseDragged(MouseEvent event) {
        if (this.lastMouseEvent != null) {
            this.mouseMoved(new MouseEvent(event.getComponent(), event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getXOnScreen(), event.getYOnScreen(), this.lastMouseEvent.getClickCount(), event.isPopupTrigger(), this.lastMouseEvent.getButton()));
        } else {
            this.mouseMoved(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyPressed(KeyEvent event) {
        Set<Integer> set = this.pressedKeyCodes;
        synchronized (set) {
            if (this.lastMouseEvent != null && !this.pressedKeyCodes.contains(event.getKeyCode())) {
                this.pressedKeyCodes.add(event.getKeyCode());
                this.pickCanvas.setShapeLocation(this.lastMouseEvent);
                PickResult result = this.pickCanvas.pickClosest();
                if (result == null) {
                    this.typed = null;
                    this.typed(null, event, null);
                } else {
                    PickIntersection intersection = result.getClosestIntersection(new Point3d(0.0, 0.0, this.getViewDistance()));
                    Primitive primitive = (Primitive)result.getNode(4);
                    Shape3D shape = (Shape3D)result.getNode(1);
                    if (primitive instanceof J3DAtomicPart) {
                        this.typed = (J3DAtomicPart)primitive;
                        this.typed.typed(event, intersection);
                        this.typed(this.typed.getObject(), event, intersection);
                    } else if (shape instanceof J3DAtomicPart) {
                        this.typed = (J3DAtomicPart)shape;
                        this.typed.typed(event, intersection);
                        this.typed(this.typed.getObject(), event, intersection);
                    } else {
                        this.typed = null;
                        this.typed(null, event, null);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void keyReleased(KeyEvent event) {
        Set<Integer> set = this.pressedKeyCodes;
        synchronized (set) {
            if (this.pressedKeyCodes.contains(event.getKeyCode())) {
                this.pressedKeyCodes.remove(event.getKeyCode());
                this.released(this.typed == null ? null : this.typed.getObject(), event);
            }
        }
    }

    public static class Lock {
        final Exception exception = new Exception();
    }

    protected static class MainGroup
    extends BranchGroup {
        protected MainGroup() {
            this.setPickable(true);
            this.setCapability(14);
            this.setCapability(13);
            this.setCapability(12);
        }
    }
}

