/*
 * Decompiled with CFR 0.152.
 */
package e3d.io.xml;

import e3d.io.xml.XMLConverter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import org.jdom2.Content;
import org.jdom2.DataConversionException;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class XMLParser<ObjectType>
implements XMLConverter<ObjectType> {
    private static final String SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";

    public abstract String getRootElementName();

    public abstract String getSchemaFileName();

    public void writeXML(ObjectType object, File file) throws IOException {
        Document doc = new Document();
        Content netXML = this.toXML(object, this.getRootElementName());
        ((Element)netXML).setAttribute("noNamespaceSchemaLocation", new File(this.getSchemaFileName()).getAbsolutePath(), Namespace.getNamespace("xsi", SCHEMA_INSTANCE));
        doc.addContent(netXML);
        BufferedWriter out = new BufferedWriter(new FileWriter(file, false));
        XMLOutputter outputter = new XMLOutputter(Format.getPrettyFormat());
        outputter.output(doc, (Writer)out);
        out.close();
    }

    public ObjectType readXML(File file) throws JDOMException, IOException, DataConversionException {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build(file);
        return this.fromXML(doc.getRootElement());
    }
}

