/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.utils;

import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class ToggleButton {
    protected final Label button;
    protected boolean on;
    protected final Image normal;
    protected final Image focused;
    protected final Image pressed;
    protected final Image pressedFocused;

    public ToggleButton(Composite parent, boolean enabled, final Image normal, final Image focused, final Image pressed, final Image pressedFocused, String toolTip, boolean on) {
        this.normal = normal;
        this.focused = focused;
        this.pressed = pressed;
        this.pressedFocused = pressedFocused;
        this.button = new Label(parent, 0x1000000);
        this.button.setToolTipText(toolTip);
        this.button.pack();
        this.button.setEnabled(enabled);
        final ToggleButton me = this;
        this.button.addMouseTrackListener(new MouseTrackListener(){

            @Override
            public void mouseEnter(MouseEvent e) {
                ToggleButton.this.button.setImage(me.on ? pressedFocused : focused);
            }

            @Override
            public void mouseExit(MouseEvent e) {
                ToggleButton.this.button.setImage(me.on ? pressed : normal);
            }

            @Override
            public void mouseHover(MouseEvent e) {
            }
        });
        this.button.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }

            @Override
            public void mouseDown(MouseEvent e) {
                me.on = !me.on;
                ToggleButton.this.button.setImage(me.on ? pressedFocused : focused);
            }

            @Override
            public void mouseUp(MouseEvent e) {
                ToggleButton.this.button.setImage(me.on ? pressed : normal);
            }
        });
        this.set(on);
    }

    public Label getButton() {
        return this.button;
    }

    public boolean isOn() {
        return this.on;
    }

    public void set(boolean on) {
        this.on = on;
        this.button.setImage(on ? this.pressed : this.normal);
    }
}

