/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.utils;

import java.io.File;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class E3DFileDialog {
    protected final FileDialog dialog;

    public E3DFileDialog(Shell shell, String title, int type, File[] files, String[] filterNames, String[] extensions) {
        this.dialog = new FileDialog(shell, type);
        if ((type & 0x2000) != 0) {
            this.dialog.setOverwrite(true);
        }
        if (files != null && files.length > 0 && files[0] != null) {
            this.dialog.setFilterPath(files[0].getParent());
            this.dialog.setFileName(files[0].getName());
        }
        this.dialog.setFilterExtensions(extensions);
        this.dialog.setFilterNames(filterNames);
        this.dialog.setText(title);
    }

    public File[] open() {
        String selection = this.dialog.open();
        if (selection == null) {
            return null;
        }
        String[] fileNames = this.dialog.getFileNames();
        if (fileNames.length == 0) {
            return null;
        }
        File[] files = new File[fileNames.length];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(this.dialog.getFilterPath(), fileNames[i]);
            ++i;
        }
        return files;
    }
}

