/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.images;

import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DRotation;
import e3d.gui.groups.scales.XYZScaleGroup;
import e3d.gui.images.ScrollableImage;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;

public class Perspective {
    public static final int POSITION_RIGHT = 1;
    public static final int POSITION_BOTTOM = 2;
    protected final ScrollableImage scrollableImage;
    protected final Color color;
    final int alpha;
    protected final PaintListener paintListener;
    final E3DVector nw0 = new E3DVector();
    final E3DVector ne0 = new E3DVector();
    final E3DVector se0 = new E3DVector();
    final E3DVector sw0 = new E3DVector();
    final E3DVector nw1 = new E3DVector();
    final E3DVector ne1 = new E3DVector();
    final E3DVector se1 = new E3DVector();
    final E3DVector sw1 = new E3DVector();

    public Perspective(final ScrollableImage scrollableImage, final XYZScaleGroup xyzGroup, final Color color, final int position) {
        this.scrollableImage = scrollableImage;
        this.color = color;
        this.alpha = 191;
        this.paintListener = new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                double zoom = scrollableImage.getZoom();
                event.gc.setAlpha(Perspective.this.alpha);
                event.gc.setForeground(color);
                event.gc.setBackground(color);
                event.gc.setLineWidth(1);
                int w = position == 1 ? (int)((double)scrollableImage.getWidth() * zoom) - 25 : (int)((double)scrollableImage.getWidth() * zoom) / 2;
                int h = position == 1 ? (int)((double)scrollableImage.getHeight() * zoom) / 2 : (int)((double)scrollableImage.getHeight() * zoom) - 25;
                event.gc.drawPolygon(new int[]{(int)Perspective.this.nw1.x + w, (int)Perspective.this.nw1.y + h, (int)Perspective.this.ne1.x + w, (int)Perspective.this.ne1.y + h, (int)Perspective.this.se1.x + w, (int)Perspective.this.se1.y + h, (int)Perspective.this.sw1.x + w, (int)Perspective.this.sw1.y + h});
                event.gc.drawLine((int)Perspective.this.nw0.x + w, (int)Perspective.this.nw0.y + h, (int)Perspective.this.nw1.x + w, (int)Perspective.this.nw1.y + h);
                event.gc.drawLine((int)Perspective.this.ne0.x + w, (int)Perspective.this.ne0.y + h, (int)Perspective.this.ne1.x + w, (int)Perspective.this.ne1.y + h);
                event.gc.drawLine((int)Perspective.this.se0.x + w, (int)Perspective.this.se0.y + h, (int)Perspective.this.se1.x + w, (int)Perspective.this.se1.y + h);
                event.gc.drawLine((int)Perspective.this.sw0.x + w, (int)Perspective.this.sw0.y + h, (int)Perspective.this.sw1.x + w, (int)Perspective.this.sw1.y + h);
                event.gc.fillPolygon(new int[]{(int)Perspective.this.nw0.x + w, (int)Perspective.this.nw0.y + h, (int)Perspective.this.ne0.x + w, (int)Perspective.this.ne0.y + h, (int)Perspective.this.se0.x + w, (int)Perspective.this.se0.y + h, (int)Perspective.this.sw0.x + w, (int)Perspective.this.sw0.y + h});
            }
        };
        SelectionListener bindingListener = new SelectionListener(){

            private void selected() {
                Perspective.this.set(xyzGroup.getXYZ());
            }

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                this.selected();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                this.selected();
            }
        };
        int i = 0;
        while (i < 3) {
            xyzGroup.getScale(i).addSelectionListener(bindingListener);
            xyzGroup.getText(i).addSelectionListener(bindingListener);
            ++i;
        }
        this.set(xyzGroup.getXYZ());
    }

    public void show() {
        this.scrollableImage.getCanvas().addPaintListener(this.paintListener);
        this.scrollableImage.getCanvas().redraw();
    }

    public void set(E3DVector point) {
        E3DRotation spin = new E3DRotation(point.product(-1.0), false, false, true);
        double x0 = -10.0;
        double y0 = -10.0;
        double z0 = -10.0;
        double x1 = 10.0;
        double y1 = 10.0;
        double z1 = 10.0;
        this.nw0.set(-10.0, -10.0, -10.0);
        this.ne0.set(10.0, -10.0, -10.0);
        this.se0.set(10.0, 10.0, -10.0);
        this.sw0.set(-10.0, 10.0, -10.0);
        this.nw1.set(-10.0, -10.0, 10.0);
        this.ne1.set(10.0, -10.0, 10.0);
        this.se1.set(10.0, 10.0, 10.0);
        this.sw1.set(-10.0, 10.0, 10.0);
        spin.transform(this.nw0);
        spin.transform(this.ne0);
        spin.transform(this.se0);
        spin.transform(this.sw0);
        spin.transform(this.nw1);
        spin.transform(this.ne1);
        spin.transform(this.se1);
        spin.transform(this.sw1);
        this.scrollableImage.getCanvas().redraw();
    }

    public void hide() {
        this.scrollableImage.getCanvas().removePaintListener(this.paintListener);
        this.scrollableImage.getCanvas().redraw();
    }

    public void dispose() {
        this.scrollableImage.getCanvas().removePaintListener(this.paintListener);
        this.color.dispose();
    }
}

