/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.images;

import e3d.gui.images.ScrollableImage;
import e3d.utils.ProgressListener;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ImageProgress
implements ProgressListener {
    protected final ScrollableImage scrollableImage;
    protected final Color bgColor;
    protected final Color fgColor;
    protected final Font taskFont;
    protected final Font currentTaskFont;
    protected final Font currentPercentFont;
    protected final ControlListener canvasControlListener;
    protected final ControlListener scrollControlListener;
    protected final PaintListener paintListener;
    protected int currentStep = -1;
    protected int steps = 100;
    protected String task = "";
    protected String currentTask = "";
    protected boolean redraw = true;

    public ImageProgress(final ScrollableImage scrollableImage, final int yOffset, final double scaleFactor) {
        this.scrollableImage = scrollableImage;
        Display display = scrollableImage.getCanvas().getDisplay();
        this.fgColor = new Color(display, 255, 255, 255);
        this.bgColor = new Color(display, 0, 0, 0);
        this.taskFont = new Font((Device)display, new FontData("Arial", (int)(20.0 * scaleFactor), 0));
        this.currentTaskFont = new Font((Device)display, new FontData("Arial", (int)(16.0 * scaleFactor), 0));
        this.currentPercentFont = new Font((Device)display, new FontData("Arial", (int)(16.0 * scaleFactor), 1));
        this.canvasControlListener = new ControlListener(){

            @Override
            public void controlMoved(ControlEvent event) {
                scrollableImage.getCanvas().redraw();
            }

            @Override
            public void controlResized(ControlEvent event) {
            }
        };
        this.scrollControlListener = new ControlListener(){

            @Override
            public void controlMoved(ControlEvent event) {
            }

            @Override
            public void controlResized(ControlEvent event) {
                scrollableImage.getCanvas().redraw();
            }
        };
        this.paintListener = new PaintListener(){

            @Override
            public void paintControl(PaintEvent event) {
                if (ImageProgress.this.currentStep >= 0 && ImageProgress.this.steps > 0) {
                    Rectangle area = scrollableImage.getScroll().getClientArea();
                    Point origin = scrollableImage.getScroll().getOrigin();
                    String percentText = String.valueOf(Math.max(0, 100 * ImageProgress.this.currentStep / ImageProgress.this.steps)) + "%";
                    int x = origin.x + 25;
                    int y = origin.y + area.height / 2 - 10 + yOffset;
                    int w = area.width - 50;
                    int h = (int)(20.0 * scaleFactor);
                    int p = w * ImageProgress.this.currentStep / ImageProgress.this.steps;
                    event.gc.setAlpha(127);
                    event.gc.setForeground(ImageProgress.this.bgColor);
                    event.gc.setBackground(ImageProgress.this.bgColor);
                    event.gc.fillRectangle(origin.x + 15, y - (int)(35.0 * scaleFactor), area.width - 30, h + (int)(65.0 * scaleFactor));
                    event.gc.setAlpha(161);
                    event.gc.setForeground(ImageProgress.this.fgColor);
                    event.gc.setBackground(ImageProgress.this.fgColor);
                    event.gc.setFont(ImageProgress.this.taskFont);
                    event.gc.drawText(ImageProgress.this.task, x, y - (int)(30.0 * scaleFactor), true);
                    event.gc.setFont(ImageProgress.this.currentTaskFont);
                    event.gc.drawText(ImageProgress.this.currentTask, x, y + (int)(20.0 * scaleFactor), true);
                    event.gc.setLineWidth(1);
                    event.gc.drawRectangle(x - 1, y - 1, w + 1, h + 1);
                    event.gc.fillRectangle(x, y, p, h);
                    event.gc.setFont(ImageProgress.this.currentPercentFont);
                    Point textExtend = event.gc.textExtent(percentText, 1);
                    event.gc.setClipping(x + p, y, w - p, h);
                    event.gc.drawText(percentText, x + w / 2 - textExtend.x / 2, y + (h - textExtend.y) / 2, true);
                    event.gc.setAlpha(255);
                    event.gc.setClipping(x, y, p, h);
                    event.gc.drawText(percentText, x + w / 2 - textExtend.x / 2, y + (h - textExtend.y) / 2, true);
                    event.gc.setClipping((Rectangle)null);
                }
            }
        };
        scrollableImage.getScroll().addControlListener(this.scrollControlListener);
        scrollableImage.getCanvas().addControlListener(this.canvasControlListener);
        scrollableImage.getCanvas().addPaintListener(this.paintListener);
    }

    @Override
    public void init(int steps, String mainTask) {
        this.steps = steps;
        this.currentStep = -1;
        this.task = mainTask;
        this.currentTask = "";
    }

    @Override
    public void done(int step, String task) {
        if (step != this.currentStep || task != this.currentTask) {
            this.currentStep = step;
            this.currentTask = task;
            if (this.redraw) {
                this.redraw = false;
                this.scrollableImage.getCanvas().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ImageProgress.this.scrollableImage.getCanvas().redraw();
                        ImageProgress.this.redraw = true;
                    }
                });
            }
        }
    }

    @Override
    public int done() {
        return Math.max(0, Math.min(this.steps, this.currentStep));
    }

    @Override
    public int steps() {
        return this.steps;
    }

    @Override
    public void finish() {
        this.currentStep = -1;
    }

    public void dispose() {
        this.scrollableImage.getCanvas().removePaintListener(this.paintListener);
        this.scrollableImage.getCanvas().removeControlListener(this.canvasControlListener);
        this.scrollableImage.getScroll().removeControlListener(this.scrollControlListener);
        this.bgColor.dispose();
        this.fgColor.dispose();
        this.taskFont.dispose();
        this.currentTaskFont.dispose();
        this.currentPercentFont.dispose();
    }
}

