/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.special;

import e3d.bezier.Needle;
import e3d.bezier.Position;
import e3d.euclidean.E3DVector;
import e3d.gui.J3DEditorGUI;
import e3d.gui.groups.special.ShapeTemplateGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.j3d.J3DCanvas;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DPoint;
import e3d.utils.ArrayFactory;
import e3d.utils.MathUtils;
import e3d.visualization.util.Matrix2D;
import javax.vecmath.Color3f;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class SphereTemplateGroup
extends ShapeTemplateGroup {
    public SphereTemplateGroup(final J3DEditorGUI gui, Composite parent) {
        super(gui, parent, "Sphere", 9);
        Label icon = new Label(this.group, 0x1000000);
        icon.setImage(Icons.getSWTImage(parent.getDisplay(), "sphere_big.png"));
        icon.setToolTipText("Create a sphere of n x m bezier surfaces");
        icon.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, false, false));
        ((GridData)icon.getLayoutData()).verticalSpan = 2;
        Label labelX = new Label(this.group, 0x1000000);
        labelX.setImage(Icons.getSWTImage(parent.getDisplay(), "x_focus.png"));
        labelX.setToolTipText("X-position (center)");
        labelX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelY = new Label(this.group, 0x1000000);
        labelY.setImage(Icons.getSWTImage(parent.getDisplay(), "y_focus.png"));
        labelY.setToolTipText("Y-position (center)");
        labelY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelZ = new Label(this.group, 0x1000000);
        labelZ.setImage(Icons.getSWTImage(parent.getDisplay(), "z_focus.png"));
        labelZ.setToolTipText("Z-position (center)");
        labelZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelRadius = new Label(this.group, 0x1000000);
        labelRadius.setImage(Icons.getSWTImage(parent.getDisplay(), "radius_focus.png"));
        labelRadius.setToolTipText("Radius");
        labelRadius.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelAngle = new Label(this.group, 0x1000000);
        labelAngle.setImage(Icons.getSWTImage(parent.getDisplay(), "angle_focus.png"));
        labelAngle.setToolTipText("Angle");
        labelAngle.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelLongituds = new Label(this.group, 0x1000000);
        labelLongituds.setImage(Icons.getSWTImage(parent.getDisplay(), "longitudes_focus.png"));
        labelLongituds.setToolTipText("Number of longitudes");
        labelLongituds.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelAltituds = new Label(this.group, 0x1000000);
        labelAltituds.setImage(Icons.getSWTImage(parent.getDisplay(), "rows_focus.png"));
        labelAltituds.setToolTipText("Number of altitudes");
        labelAltituds.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Composite empty = new Composite(this.group, 0);
        empty.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, 35, 1, false, false));
        final Text textX = new Text(this.group, 2048);
        textX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textY = new Text(this.group, 2048);
        textY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textZ = new Text(this.group, 2048);
        textZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textRadius = new Text(this.group, 2048);
        textRadius.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textAngle = new Text(this.group, 2048);
        textAngle.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textLongituds = new Text(this.group, 2048);
        textLongituds.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textLatituds = new Text(this.group, 2048);
        textLatituds.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label create = new IconButton(this.group, true, Icons.getSWTImage(this.group.getDisplay(), "start.png"), Icons.getSWTImage(this.group.getDisplay(), "start_focus.png"), Icons.getSWTImage(this.group.getDisplay(), "start_pressed.png"), "Create").getButton();
        create.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, 35, -1, true, false));
        create.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }

            @Override
            public void mouseDown(MouseEvent e) {
                try {
                    E3DVector center = new E3DVector(Double.parseDouble(textX.getText()), Double.parseDouble(textY.getText()), Double.parseDouble(textZ.getText()));
                    double radius = Double.parseDouble(textRadius.getText());
                    double angle = Double.parseDouble(textAngle.getText());
                    int longituds = Integer.parseInt(textLongituds.getText());
                    int latituds = Integer.parseInt(textLatituds.getText());
                    switch (SphereTemplateGroup.this.shapeType) {
                        case BEZIER: {
                            SphereTemplateGroup.this.createNeedleSphere(center, radius, Math.min(Math.PI * 2, angle / 360.0 * 2.0 * Math.PI), longituds, latituds, angle >= 360.0);
                            break;
                        }
                        case MESH: {
                            SphereTemplateGroup.this.createMeshSphere(center, radius, Math.min(Math.PI * 2, angle / 360.0 * 2.0 * Math.PI), longituds, latituds, angle >= 360.0);
                        }
                    }
                }
                catch (RuntimeException exception) {
                    gui.showGeneralError(exception);
                }
            }

            @Override
            public void mouseUp(MouseEvent e) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createNeedleSphere(E3DVector center, double radius, double angle, int longituds, int altituds, boolean closed) {
        J3DCanvas j3DCanvas = this.gui.getCanvas();
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.gui.getCanvas().lock();
            try {
                int cols = closed ? longituds + 1 : longituds;
                Matrix2D<J3DNeedle> needles = new Matrix2D<J3DNeedle>(cols, altituds, ArrayFactory.J3DNEEDLE, null);
                Needle northPole = new Needle(new Position(center.x, center.y, radius), new E3DVector(0.0, 0.0, 1.0));
                Needle southPole = new Needle(new Position(center.x, center.y, -radius), new E3DVector(0.0, 0.0, -1.0));
                J3DNeedle northPolarNeedle = this.gui.createNeedle(northPole, null, true);
                J3DNeedle southPolarNeedle = this.gui.createNeedle(southPole, null, true);
                int i = 0;
                while (i <= longituds) {
                    needles.set(i, 0, northPolarNeedle);
                    needles.set(i, altituds - 1, southPolarNeedle);
                    ++i;
                }
                int segments = closed ? longituds : longituds - 1;
                int j = 1;
                while (j < altituds - 1) {
                    double altitude = MathUtils.div0(j, altituds - 1) * Math.PI;
                    int i2 = 0;
                    while (i2 < longituds) {
                        double longitude = MathUtils.div0(i2, segments) * angle;
                        double x = radius * Math.sin(altitude) * Math.cos(longitude);
                        double y = radius * Math.sin(altitude) * Math.sin(longitude);
                        double z = radius * Math.cos(altitude);
                        Needle tangent = new Needle(new Position(x + center.x, y + center.y, z + center.z), new E3DVector(x, y, z));
                        needles.set(i2, j, this.gui.createNeedle(tangent, null, true));
                        ++i2;
                    }
                    if (closed) {
                        needles.set(longituds, j, needles.get(0, j));
                    }
                    ++j;
                }
                this.gui.createNeedleMesh(needles, new Color3f(1.0f, 1.0f, 1.0f), null, null, 1.0, null, true);
            }
            finally {
                this.gui.getHistory().next();
                this.gui.getCanvas().unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createMeshSphere(E3DVector center, double radius, double angle, int longituds, int altituds, boolean closed) {
        J3DCanvas j3DCanvas = this.gui.getCanvas();
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.gui.getCanvas().lock();
            try {
                int cols = closed ? longituds + 1 : longituds;
                Matrix2D<J3DPoint> points = new Matrix2D<J3DPoint>(cols, altituds, ArrayFactory.J3DPOINT, null);
                Position northPole = new Position(center.x, center.y, radius);
                Position southPole = new Position(center.x, center.y, -radius);
                J3DPoint northPolarPoint = this.gui.createPoint(northPole, null, true);
                J3DPoint southPolarPoint = this.gui.createPoint(southPole, null, true);
                int i = 0;
                while (i <= longituds) {
                    points.set(i, 0, northPolarPoint);
                    points.set(i, altituds - 1, southPolarPoint);
                    ++i;
                }
                int segments = closed ? longituds : longituds - 1;
                int j = 1;
                while (j < altituds - 1) {
                    double altitude = MathUtils.div0(j, altituds - 1) * Math.PI;
                    int i2 = 0;
                    while (i2 < longituds) {
                        double longitude = MathUtils.div0(i2, segments) * angle;
                        double x = radius * Math.sin(altitude) * Math.cos(longitude);
                        double y = radius * Math.sin(altitude) * Math.sin(longitude);
                        double z = radius * Math.cos(altitude);
                        Position position = new Position(x + center.x, y + center.y, z + center.z);
                        J3DPoint point = this.gui.createPoint(position, null, true);
                        points.set(i2, j, point);
                        ++i2;
                    }
                    if (closed) {
                        points.set(longituds, j, points.get(0, j));
                    }
                    ++j;
                }
                this.gui.createPointMesh(points, new Color3f(1.0f, 1.0f, 1.0f), null, null, 1.0, null, true);
            }
            finally {
                this.gui.getHistory().next();
                this.gui.getCanvas().unlock(lock);
            }
        }
    }
}

