/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.special;

import e3d.bezier.LayerMesh;
import e3d.euclidean.E3DTransform;
import e3d.euclidean.E3DVector;
import e3d.gui.J3DEditorGUI;
import e3d.gui.groups.special.ShapeTemplateGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.E3DFileDialog;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.j3d.J3DCanvas;
import e3d.j3d.objects.J3DLayerMesh;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import java.io.File;
import java.util.Arrays;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;

public class LayerMeshTemplateGroup
extends ShapeTemplateGroup {
    private File[] files = null;

    public LayerMeshTemplateGroup(final J3DEditorGUI gui, final Composite parent) {
        super(gui, parent, "Layer Mesh", 11);
        Label icon = new Label(this.group, 0x1000000);
        icon.setImage(Icons.getSWTImage(parent.getDisplay(), "layers_big.png"));
        icon.setToolTipText("Create an \"layer mesh\" - this is an mesh defined by adding offsets defined by multiple images to each point in the direction given by the (current) normal vector at that point (which might change after a layer has been added.");
        icon.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, false, false));
        ((GridData)icon.getLayoutData()).verticalSpan = 3;
        Label labelX = new Label(this.group, 0x1000000);
        labelX.setImage(Icons.getSWTImage(parent.getDisplay(), "x_focus.png"));
        labelX.setToolTipText("X-position (center)");
        labelX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelY = new Label(this.group, 0x1000000);
        labelY.setImage(Icons.getSWTImage(parent.getDisplay(), "y_focus.png"));
        labelY.setToolTipText("Y-position (center)");
        labelY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelZ = new Label(this.group, 0x1000000);
        labelZ.setImage(Icons.getSWTImage(parent.getDisplay(), "z_focus.png"));
        labelZ.setToolTipText("Z-position (center)");
        labelZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelWidth = new Label(this.group, 0x1000000);
        labelWidth.setImage(Icons.getSWTImage(parent.getDisplay(), "width_focus.png"));
        labelWidth.setToolTipText("Width (of the untrasformed flat mesh)");
        labelWidth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelHeight = new Label(this.group, 0x1000000);
        labelHeight.setImage(Icons.getSWTImage(parent.getDisplay(), "height_focus.png"));
        labelHeight.setToolTipText("Height (of the untrasformed flat mesh)");
        labelHeight.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelDepth = new Label(this.group, 0x1000000);
        labelDepth.setImage(Icons.getSWTImage(parent.getDisplay(), "depth_focus.png"));
        labelDepth.setToolTipText("Max. depth offset");
        labelDepth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label labelDelta = new Label(this.group, 0x1000000);
        labelDelta.setImage(Icons.getSWTImage(parent.getDisplay(), "delta_focus.png"));
        labelDelta.setToolTipText("Delta (smoothing normals)");
        labelDelta.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        Label bitMaskDelta = new Label(this.group, 0x1000000);
        bitMaskDelta.setImage(Icons.getSWTImage(parent.getDisplay(), "and_pressed_focus.png"));
        bitMaskDelta.setToolTipText("Bitmask to convert color-values to unscaled offset values");
        bitMaskDelta.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        SWTUtils.space(this.group);
        Label create = new IconButton(this.group, true, Icons.getSWTImage(this.group.getDisplay(), "start.png"), Icons.getSWTImage(this.group.getDisplay(), "start_focus.png"), Icons.getSWTImage(this.group.getDisplay(), "start_pressed.png"), "Create").getButton();
        create.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, 35, -1, true, false));
        ((GridData)create.getLayoutData()).verticalSpan = 3;
        final Text textX = new Text(this.group, 2048);
        textX.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textY = new Text(this.group, 2048);
        textY.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textZ = new Text(this.group, 2048);
        textZ.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textWidth = new Text(this.group, 2048);
        textWidth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textHeight = new Text(this.group, 2048);
        textHeight.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textDepth = new Text(this.group, 2048);
        textDepth.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textDelta = new Text(this.group, 2048);
        textDelta.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 35, -1, false, false));
        final Text textBitMask = new Text(this.group, 2048);
        textBitMask.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, 70, -1, false, false));
        SWTUtils.space(this.group);
        final List listFiles = new List(this.group, 2048);
        listFiles.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, false, false));
        ((GridData)listFiles.getLayoutData()).horizontalSpan = 8;
        Label buttonChoose = new IconButton(this.group, true, Icons.getSWTImage(this.group.getDisplay(), "choose.png"), Icons.getSWTImage(this.group.getDisplay(), "choose_focus.png"), Icons.getSWTImage(this.group.getDisplay(), "choose_pressed.png"), "Open File").getButton();
        buttonChoose.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, -1, -1, false, false));
        final String[] filterNames = new String[]{"All files"};
        final String[] extensions = new String[]{"*.*"};
        buttonChoose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseDown(MouseEvent e) {
                E3DFileDialog dialog = new E3DFileDialog(parent.getShell(), "Load", 4098, LayerMeshTemplateGroup.this.files, filterNames, extensions);
                File[] selection = dialog.open();
                if (selection != null) {
                    String[] items = new String[selection.length];
                    int i = 0;
                    while (i < items.length) {
                        items[i] = selection[i].getPath();
                        ++i;
                    }
                    listFiles.setItems(items);
                    LayerMeshTemplateGroup.this.files = selection;
                }
                listFiles.update();
            }
        });
        create.addMouseListener(new MouseListener(){

            @Override
            public void mouseDoubleClick(MouseEvent e) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseDown(MouseEvent e) {
                try {
                    if (LayerMeshTemplateGroup.this.files == null) {
                        gui.showWarning("Choose one or more offset images first (all of the same size)");
                        return;
                    }
                    E3DVector center = new E3DVector(Double.parseDouble(textX.getText()), Double.parseDouble(textY.getText()), Double.parseDouble(textZ.getText()));
                    E3DVector size = new E3DVector(Double.parseDouble(textWidth.getText()), Double.parseDouble(textHeight.getText()), Double.parseDouble(textDepth.getText()));
                    int bitMask = Integer.parseInt(textBitMask.getText(), 16);
                    int delta = Integer.parseInt(textDelta.getText());
                    E3DTransform transform = new E3DTransform();
                    transform.setToTranslation(center);
                    J3DCanvas j3DCanvas = gui.getCanvas();
                    synchronized (j3DCanvas) {
                        J3DCanvas.Lock lock = gui.getCanvas().lock();
                        try {
                            LayerMesh params = new LayerMesh(Arrays.asList(LayerMeshTemplateGroup.this.files), size, bitMask, delta, transform, new E3DColor(255, 255, 255), new E3DMaterial(), null);
                            J3DLayerMesh layerMesh = new J3DLayerMesh(params, gui.layerMeshParameters);
                            gui.getCanvas().getScene().addObject(layerMesh);
                            gui.getHistory().add(layerMesh);
                        }
                        finally {
                            gui.getHistory().next();
                            gui.getCanvas().unlock(lock);
                        }
                    }
                }
                catch (RuntimeException exception) {
                    gui.showGeneralError(exception);
                }
            }

            @Override
            public void mouseUp(MouseEvent e) {
            }
        });
    }
}

