/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.scales;

import e3d.gui.groups.scales.ScaleGroup;
import e3d.gui.groups.scales.VerticalScaleGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.SWTUtils;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class WHDScaleGroup
extends VerticalScaleGroup {
    protected double refWidth;
    protected double refHeight;
    protected double refDepth;
    protected final Label proportionalLabel;
    protected final Button proportionalCheckButton;
    protected final SelectionListener proportionalSelectionListener;
    protected final KeyListener proportionalKeyListener;

    public WHDScaleGroup(Composite parent, String name, double factor, double w, double h, double d, int width, int height, int depth, boolean proportional, boolean excludeDepth, int length, boolean fillVertical) {
        super(parent, name, new String[]{"width (double click to adapt height and depth automatically)", "height (double click to adapt width and depth automatically)", "depth (double click to adapt width and height automatically)"}, Icons.getSWTImages(parent.getDisplay(), "width_focus.png", "height_focus.png", "depth_focus.png"), new double[]{w, h, d}, new ScaleGroup.Function[]{ScaleGroup.linear(factor, 0), ScaleGroup.linear(-factor, height), ScaleGroup.linear(-factor, depth)}, new int[3], new int[]{width, height, depth}, new int[]{256, 512, 512}, new int[]{length, length, length}, fillVertical);
        Composite proportionalFrame = new Composite(this.group, 0);
        proportionalFrame.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, false, false));
        proportionalFrame.setLayout(new GridLayout(4, false));
        ((GridData)proportionalFrame.getLayoutData()).horizontalSpan = 3;
        this.proportionalCheckButton = new Button(proportionalFrame, 32);
        this.proportionalLabel = new Label(proportionalFrame, 0);
        this.proportionalCheckButton.setLayoutData(SWTUtils.gridData(1, 2, 0, 0, -1, -1, false, false));
        this.proportionalCheckButton.setSelection(proportional);
        this.proportionalLabel.setLayoutData(SWTUtils.gridData(1, 2, 2, 0, -1, -1, false, false));
        this.proportionalLabel.setText("proportional");
        this.proportionalSelectionListener = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent event) {
                WHDScaleGroup.this.scaleProportinal(event.getSource());
            }

            @Override
            public void widgetSelected(SelectionEvent event) {
                WHDScaleGroup.this.scaleProportinal(event.getSource());
            }
        };
        this.proportionalKeyListener = new KeyListener(){

            @Override
            public void keyPressed(KeyEvent event) {
            }

            @Override
            public void keyReleased(KeyEvent event) {
                WHDScaleGroup.this.scaleProportinal(event.getSource());
            }
        };
        this.proportionalCheckButton.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent event) {
                WHDScaleGroup.this.activateProportionalScaling(WHDScaleGroup.this.proportionalCheckButton.getSelection());
            }
        });
        this.activateProportionalScaling(proportional);
    }

    public double getWidth() {
        return this.getValue(0);
    }

    public double getHeight() {
        return this.getValue(1);
    }

    public double getDepth() {
        return this.getValue(2);
    }

    private void activateProportionalScaling(boolean activate) {
        if (activate) {
            this.refWidth = this.getWidth();
            this.refHeight = this.getHeight();
            this.refDepth = this.getDepth();
            int i = 0;
            while (i < 3) {
                this.texts[i].addKeyListener(this.proportionalKeyListener);
                this.scales[i].addSelectionListener(this.proportionalSelectionListener);
                ++i;
            }
        } else {
            int i = 0;
            while (i < 3) {
                this.texts[i].removeKeyListener(this.proportionalKeyListener);
                this.scales[i].removeSelectionListener(this.proportionalSelectionListener);
                ++i;
            }
        }
    }

    private void scaleProportinal(Object source) {
        if (source == this.texts[0] || source == this.scales[0]) {
            this.setValue(1, this.getValue(0) * this.refHeight / this.refWidth);
            this.setValue(2, this.getValue(0) * this.refDepth / this.refWidth);
        } else if (source == this.texts[1] || source == this.scales[1]) {
            this.setValue(0, this.getValue(1) * this.refWidth / this.refHeight);
            this.setValue(2, this.getValue(1) * this.refDepth / this.refHeight);
        } else if (source == this.texts[2] || source == this.scales[2]) {
            this.setValue(0, this.getValue(2) * this.refWidth / this.refDepth);
            this.setValue(1, this.getValue(2) * this.refHeight / this.refDepth);
        }
    }
}

