/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.scales;

import e3d.gui.groups.scales.HorizontalScaleGroup;
import e3d.gui.groups.scales.ScaleGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.SWTUtils;
import e3d.visualization.util.E3DColor;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;

public class SimpleColorScaleGroup
extends HorizontalScaleGroup {
    final Composite coloredComposite;
    final double saturation;
    final double brightness;
    final int baseColor;

    public SimpleColorScaleGroup(Composite parent, String name, int hue, double saturation, double brightness, int baseColor, int orientation, int length, boolean fillHorizontal) {
        super(parent, name, new String[]{"hue"}, Icons.getSWTImages(parent.getDisplay(), "hue_focus.png"), new double[]{hue}, new ScaleGroup.Function[]{ScaleGroup.linear(-1.0, 360)}, new int[1], new int[]{361}, new int[]{256}, new int[]{length}, fillHorizontal);
        this.saturation = saturation;
        this.brightness = brightness;
        this.baseColor = baseColor;
        this.coloredComposite = new Composite(this.group, 0);
        this.coloredComposite.setLayoutData(SWTUtils.gridData(4, 4, 0, 0, 20, 20, true, true));
        this.updateColor();
        ((GridData)this.coloredComposite.getLayoutData()).horizontalSpan = 6;
        SelectionListener colorListener = new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
                SimpleColorScaleGroup.this.updateColor();
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                SimpleColorScaleGroup.this.updateColor();
            }
        };
        MouseAdapter colorListener2 = new MouseAdapter(){

            @Override
            public void mouseUp(MouseEvent e) {
                SimpleColorScaleGroup.this.updateColor();
            }
        };
        this.scales[0].addSelectionListener(colorListener);
        this.texts[0].addSelectionListener(colorListener);
        this.downs[0].addMouseListener(colorListener2);
        this.ups[0].addMouseListener(colorListener2);
    }

    public void setColor(int hue) {
        super.setValue(0, hue);
        this.updateColor();
    }

    public Integer getColor() {
        double hue = this.getValue(0);
        if (hue < -0.5) {
            return -1;
        }
        return E3DColor.changeHSB(this.baseColor, hue / 360.0, this.saturation, this.brightness);
    }

    private void updateColor() {
        Color oldColor = this.coloredComposite.getBackground();
        E3DColor color = new E3DColor(this.getColor());
        this.coloredComposite.setBackground(new Color(this.coloredComposite.getDisplay(), color.getRed(), color.getGreen(), color.getBlue()));
        if (oldColor != null) {
            oldColor.dispose();
        }
        this.coloredComposite.update();
    }
}

