/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.scales;

import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public abstract class ScaleGroup
extends WidgetGroup {
    public static final int FIELD_VALUE = 0;
    private static final int TEXT_INVALID_VALUE_COLOR_ID = 3;
    protected final double[] values;
    protected final Scale[] scales;
    protected final Label[] ups;
    protected final Label[] downs;
    protected final Text[] texts;
    protected final Label[] labels;
    protected final Function[] functions;
    protected final Color[] textBackgrounds;

    public static Function linear(final double factor, final int offset) {
        return new Function(){

            @Override
            public double selection2Value(int selection) {
                return (double)(selection - offset) / factor;
            }

            @Override
            public int value2Selection(double value) {
                return (int)(value * factor) + offset;
            }
        };
    }

    public static Function powerOf2() {
        return new Function(){

            @Override
            public double selection2Value(int selection) {
                return Math.pow(2.0, selection);
            }

            @Override
            public int value2Selection(double value) {
                return (int)(Math.log(value) / Math.log(2.0));
            }
        };
    }

    public ScaleGroup(Composite parent, String name, int columns, boolean fillHorizontal, boolean fillVertical, String[] labels, Image[] icons, double[] values, Function[] function, int[] min, int[] max, int[] scaleOrientation) {
        super(parent, name, columns, fillHorizontal, fillVertical);
        this.values = values;
        this.functions = function;
        this.scales = new Scale[values.length];
        this.texts = new Text[values.length];
        this.labels = new Label[values.length];
        this.ups = new Label[values.length];
        this.downs = new Label[values.length];
        this.textBackgrounds = new Color[values.length];
    }

    protected void createActions() {
        int index = 0;
        while (index < this.values.length) {
            final int i = index++;
            this.scales[i].addSelectionListener(new SelectionListener(){

                @Override
                public void widgetSelected(SelectionEvent e) {
                    ScaleGroup.this.values[i] = ScaleGroup.this.functions[i].selection2Value(ScaleGroup.this.scales[i].getSelection());
                    ScaleGroup.this.scales[i].update();
                    ScaleGroup.this.texts[i].setText(String.valueOf(ScaleGroup.this.values[i]));
                    ScaleGroup.this.texts[i].setBackground(ScaleGroup.this.textBackgrounds[i]);
                    ScaleGroup.this.texts[i].update();
                    ScaleGroup.this.setChanged(true);
                    for (WidgetGroupEditedListener listener : ScaleGroup.this.listeners) {
                        listener.edited(ScaleGroup.this.getThis(), i, 0);
                    }
                }

                @Override
                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.scales[i].addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                }

                @Override
                public void mouseUp(MouseEvent e) {
                    for (WidgetGroupEditedListener listener : ScaleGroup.this.listeners) {
                        listener.finished(ScaleGroup.this.getThis(), i, 0);
                    }
                }
            });
            this.texts[i].addKeyListener(new KeyListener(){

                @Override
                public void keyPressed(KeyEvent event) {
                }

                @Override
                public void keyReleased(KeyEvent event) {
                    try {
                        double oldValue = ScaleGroup.this.values[i];
                        ScaleGroup.this.values[i] = Double.parseDouble(ScaleGroup.this.texts[i].getText());
                        if (ScaleGroup.this.values[i] != oldValue) {
                            ScaleGroup.this.scales[i].setSelection(ScaleGroup.this.functions[i].value2Selection(ScaleGroup.this.values[i]));
                            ScaleGroup.this.scales[i].update();
                            ScaleGroup.this.texts[i].setBackground(ScaleGroup.this.textBackgrounds[i]);
                            ScaleGroup.this.texts[i].update();
                            ScaleGroup.this.setChanged(true);
                            for (WidgetGroupEditedListener listener : ScaleGroup.this.listeners) {
                                listener.edited(ScaleGroup.this.getThis(), i, 0);
                                listener.finished(ScaleGroup.this.getThis(), i, 0);
                            }
                        }
                    }
                    catch (Exception exception) {
                        ScaleGroup.this.texts[i].setBackground(ScaleGroup.this.texts[i].getDisplay().getSystemColor(3));
                        ScaleGroup.this.texts[i].update();
                    }
                }
            });
            this.ups[i].addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                }

                @Override
                public void mouseUp(MouseEvent e) {
                    ScaleGroup.this.scales[i].setSelection(ScaleGroup.this.scales[i].getSelection() + ((ScaleGroup.this.scales[i].getStyle() & 0x100) != 0 ? 1 : -1));
                    ScaleGroup.this.values[i] = ScaleGroup.this.functions[i].selection2Value(ScaleGroup.this.scales[i].getSelection());
                    ScaleGroup.this.scales[i].update();
                    ScaleGroup.this.texts[i].setText(String.valueOf(ScaleGroup.this.values[i]));
                    ScaleGroup.this.texts[i].setBackground(ScaleGroup.this.textBackgrounds[i]);
                    ScaleGroup.this.texts[i].update();
                    ScaleGroup.this.setChanged(true);
                    for (WidgetGroupEditedListener listener : ScaleGroup.this.listeners) {
                        listener.edited(ScaleGroup.this.getThis(), i, 0);
                        listener.finished(ScaleGroup.this.getThis(), i, 0);
                    }
                }
            });
            this.downs[i].addMouseListener(new MouseListener(){

                @Override
                public void mouseDoubleClick(MouseEvent e) {
                }

                @Override
                public void mouseDown(MouseEvent e) {
                }

                @Override
                public void mouseUp(MouseEvent e) {
                    ScaleGroup.this.scales[i].setSelection(ScaleGroup.this.scales[i].getSelection() - ((ScaleGroup.this.scales[i].getStyle() & 0x100) != 0 ? 1 : -1));
                    ScaleGroup.this.values[i] = ScaleGroup.this.functions[i].selection2Value(ScaleGroup.this.scales[i].getSelection());
                    ScaleGroup.this.scales[i].update();
                    ScaleGroup.this.texts[i].setText(String.valueOf(ScaleGroup.this.values[i]));
                    ScaleGroup.this.texts[i].setBackground(ScaleGroup.this.textBackgrounds[i]);
                    ScaleGroup.this.texts[i].update();
                    ScaleGroup.this.setChanged(true);
                    for (WidgetGroupEditedListener listener : ScaleGroup.this.listeners) {
                        listener.edited(ScaleGroup.this.getThis(), i, 0);
                        listener.finished(ScaleGroup.this.getThis(), i, 0);
                    }
                }
            });
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.group.setEnabled(enabled);
        int i = 0;
        while (i < this.values.length) {
            this.labels[i].setEnabled(enabled);
            this.scales[i].setEnabled(enabled);
            this.texts[i].setEnabled(enabled);
            ++i;
        }
    }

    public void setEnabled(boolean enabled, int ... indices) {
        int[] nArray = indices;
        int n = indices.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            this.labels[i].setEnabled(enabled);
            this.scales[i].setEnabled(enabled);
            this.texts[i].setEnabled(enabled);
            ++n2;
        }
    }

    @Override
    public Group getGroup() {
        return this.group;
    }

    public double getValue(int index) {
        return this.values[index];
    }

    public void setValue(int index, double value) {
        this.values[index] = value;
        this.texts[index].setText(String.valueOf(this.values[index]));
        this.scales[index].setSelection(this.functions[index].value2Selection(this.values[index]));
        this.scales[index].update();
        this.texts[index].update();
    }

    public Scale getScale(int index) {
        return this.scales[index];
    }

    public Text getText(int index) {
        return this.texts[index];
    }

    public Label getLabel(int index) {
        return this.labels[index];
    }

    public static interface Function {
        public int value2Selection(double var1);

        public double selection2Value(int var1);
    }
}

