/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui.groups.scales;

import e3d.gui.groups.scales.ScaleGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Text;

public class HorizontalScaleGroup
extends ScaleGroup {
    protected final Composite[] leftGenericSections;
    protected final Composite[] rightGenericSections;

    public HorizontalScaleGroup(Composite parent, String name, String[] labels, Image[] icons, double[] values, ScaleGroup.Function[] function, int[] min, int[] max, int[] scaleOrientation, int[] length, boolean fillHorizontal) {
        super(parent, name, 7, fillHorizontal, false, labels, icons, values, function, min, max, scaleOrientation);
        this.leftGenericSections = new Composite[values.length];
        this.rightGenericSections = new Composite[values.length];
        int index = 0;
        while (index < values.length) {
            this.leftGenericSections[index] = SWTUtils.space(this.group);
            this.labels[index] = new Label(this.group, 0x1000000);
            this.labels[index].setLayoutData(SWTUtils.gridData(1, 2, 0, 0, -1, -1, false, false));
            if (icons[index] != null) {
                this.labels[index].setImage(icons[index]);
                this.labels[index].setToolTipText(labels[index]);
            } else {
                this.labels[index].setText(labels[index]);
            }
            this.scales[index] = new Scale(this.group, scaleOrientation[index]);
            this.scales[index].setLayoutData(SWTUtils.gridData(4, 2, 0, 0, scaleOrientation[index] == 256 ? length[index] : -1, scaleOrientation[index] == 512 ? length[index] : -1, true, false));
            this.scales[index].setMinimum(min[index]);
            this.scales[index].setMaximum(max[index]);
            this.scales[index].setSelection(this.functions[index].value2Selection(values[index]));
            this.downs[index] = new IconButton(this.group, true, Icons.getSWTImage(parent.getDisplay(), "left.png"), Icons.getSWTImage(parent.getDisplay(), "left_focus.png"), Icons.getSWTImage(parent.getDisplay(), "left_pressed.png"), null).getButton();
            this.downs[index].setLayoutData(SWTUtils.gridData(1, 2, 0, 0, 7, 35, false, false));
            this.texts[index] = new Text(this.group, 0x1000800);
            this.texts[index].setLayoutData(SWTUtils.gridData(3, 2, 0, 0, 35, -1, false, false));
            this.texts[index].setText(String.valueOf(values[index]));
            this.ups[index] = new IconButton(this.group, true, Icons.getSWTImage(parent.getDisplay(), "right.png"), Icons.getSWTImage(parent.getDisplay(), "right_focus.png"), Icons.getSWTImage(parent.getDisplay(), "right_pressed.png"), null).getButton();
            this.ups[index].setLayoutData(SWTUtils.gridData(1, 2, 0, 0, 7, 35, false, false));
            this.rightGenericSections[index] = SWTUtils.space(this.group);
            ++index;
        }
        this.createActions();
    }

    public Composite getLeftGenericSection(int index) {
        return this.leftGenericSections[index];
    }

    public Composite getRightGenericSection(int index) {
        return this.rightGenericSections[index];
    }
}

