/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui;

import e3d.euclidean.E3DVector;
import e3d.gui.E3DGUI;
import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.icons.Icons;
import e3d.gui.images.ScrollableImage;
import e3d.gui.utils.E3DFileDialog;
import e3d.io.obj.WavefrontSpaceExporter;
import e3d.io.obj.WavefrontZBufferExporter;
import e3d.utils.ProgressListener;
import e3d.visualization.environment.E3DEnvironment;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageSWT;
import e3d.visualization.image.filter.BGColorFilter;
import e3d.visualization.image.filter.BGImageFilter;
import e3d.visualization.image.filter.ColorShiftFilter;
import e3d.visualization.image.filter.E3DImageFilter;
import e3d.visualization.image.filter.FocusDepthFilter;
import e3d.visualization.image.filter.HSBFilter;
import e3d.visualization.renderer.E3DNoShadingRayTracer;
import e3d.visualization.renderer.E3DRayTracer;
import e3d.visualization.scanner.Statistics;
import e3d.visualization.space.BinarySpace;
import e3d.visualization.space.Scan;
import e3d.visualization.util.E3DAtom;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DLight;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.E3DScene;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.MenuItem;

public abstract class SpaceGUI
extends E3DGUI {
    protected Scan<E3DAtom> scan = null;
    protected float[][][] xyzBuffer = null;
    protected double[] dMinMax = null;
    protected E3DImageSWT unfilteredImage = null;
    protected E3DImageSWT filteredImage = null;
    protected boolean auto = false;
    protected boolean switchOffShading = false;
    protected boolean envDirectlyVisible = false;
    protected boolean applyAllFiltersOnBackground = false;
    protected Step step = null;
    protected final E3DVector voxelSize = new E3DVector();
    protected final E3DVector viewPos = new E3DVector();
    protected Statistics statistics = new Statistics();
    protected File objFile = null;

    @Override
    public void setAutomaticRestart(boolean auto) {
        this.auto = auto;
        if (auto) {
            this.restart(Step.COMPLETE);
        }
    }

    protected abstract ScrollableImage getScrollableImage();

    protected abstract E3DMaterial getDefaultMaterial();

    protected abstract E3DVector getViewPosition();

    protected abstract E3DVector getFocusPoint();

    protected abstract List<E3DVector> getLightPositions();

    protected abstract int getLightColor();

    protected abstract int getAmbientLightColor();

    protected abstract double getAmbient();

    protected abstract double getHue();

    protected abstract double getSaturation();

    protected abstract double getBrightness();

    protected abstract int getBGColor();

    protected abstract int getShiftColor();

    protected abstract double getBlueShift();

    protected abstract double getWhiteShift();

    public abstract double getMaxBlurRadius();

    public abstract double getFocalDistance();

    protected abstract E3DImage getBGImage();

    protected abstract E3DBoundingBox getBounds();

    protected abstract int getImageWidth();

    protected abstract int getImageHeight();

    protected abstract int getZBufferDepth();

    protected abstract ProgressListener getProgressListener();

    protected abstract ProgressListener getSubProgressListener();

    protected abstract E3DEnvironment getEnvironment();

    protected abstract void showStatistics(String var1);

    protected void setViews(E3DVector viewPos, E3DVector focusPoint, Collection<E3DLight> lights) throws InterruptedException {
    }

    @Override
    public boolean hasOptionsMenu() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart(Step startWithStep) {
        final Step firstStep = this.first(startWithStep, this.step);
        Runnable task = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block39: {
                    try {
                        Object object = SpaceGUI.this.sync;
                        synchronized (object) {
                            SpaceGUI.this.coolBar.setBusyFromOtherThread(true);
                        }
                        int steps = 0;
                        switch (firstStep) {
                            case COMPLETE: 
                            case SCANNING: {
                                steps += 75;
                            }
                            case RENDERING: {
                                steps += 20;
                            }
                            case FILTERING: {
                                steps += 5;
                            }
                        }
                        SpaceGUI.this.getProgressListener().init(steps, "CREATE IMAGE");
                        switch (firstStep) {
                            case COMPLETE: 
                            case SCANNING: {
                                SpaceGUI.this.step = Step.SCANNING;
                                SpaceGUI.this.getProgressListener().done(SpaceGUI.this.getProgressListener().done(), "scanning");
                                SpaceGUI.this.scan = null;
                                SpaceGUI.this.scan = SpaceGUI.this.scanning();
                                SpaceGUI.this.getProgressListener().done(SpaceGUI.this.getProgressListener().done() + 50, "finished scanning");
                                SpaceGUI.this.showStatistics();
                            }
                            case RENDERING: {
                                SpaceGUI.this.step = Step.RENDERING;
                                SpaceGUI.this.getProgressListener().done(SpaceGUI.this.getProgressListener().done(), "rendering");
                                SpaceGUI.this.unfilteredImage = SpaceGUI.this.rendering(SpaceGUI.this.scan);
                                SpaceGUI.this.getProgressListener().done(SpaceGUI.this.getProgressListener().done() + 20, "finished rendering");
                                SpaceGUI.this.showStatistics();
                            }
                            case FILTERING: {
                                SpaceGUI.this.step = Step.FILTERING;
                                SpaceGUI.this.filteredImage = SpaceGUI.this.filtering(SpaceGUI.this.unfilteredImage, SpaceGUI.this.filteredImage);
                                SpaceGUI.this.showStatistics();
                            }
                        }
                        SpaceGUI.this.display.asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                SpaceGUI.this.getScrollableImage().setE3DImage((this).SpaceGUI.this.filteredImage);
                                (this).SpaceGUI.this.menu.setSavable(true);
                                (this).SpaceGUI.this.coolBar.setSavable(true);
                            }
                        });
                    }
                    catch (InterruptedException steps) {
                        Object object = SpaceGUI.this.sync;
                        synchronized (object) {
                            SpaceGUI.this.step = null;
                            if (SpaceGUI.this.next != null) {
                                SpaceGUI.this.future = SpaceGUI.this.executorService.submit(SpaceGUI.this.next);
                                SpaceGUI.this.next = null;
                            } else {
                                SpaceGUI.this.future = null;
                            }
                            SpaceGUI.this.getProgressListener().finish();
                            SpaceGUI.this.getSubProgressListener().finish();
                            SpaceGUI.this.updateFromOtherThread(SpaceGUI.this.getScrollableImage());
                            SpaceGUI.this.coolBar.setBusyFromOtherThread(false);
                        }
                        SpaceGUI.this.finish();
                        break block39;
                    }
                    catch (Throwable throwable) {
                        Object object;
                        try {
                            SpaceGUI.this.showGeneralError(throwable);
                            object = SpaceGUI.this.sync;
                        }
                        catch (Throwable throwable2) {
                            Object object2 = SpaceGUI.this.sync;
                            synchronized (object2) {
                                SpaceGUI.this.step = null;
                                if (SpaceGUI.this.next != null) {
                                    SpaceGUI.this.future = SpaceGUI.this.executorService.submit(SpaceGUI.this.next);
                                    SpaceGUI.this.next = null;
                                } else {
                                    SpaceGUI.this.future = null;
                                }
                                SpaceGUI.this.getProgressListener().finish();
                                SpaceGUI.this.getSubProgressListener().finish();
                                SpaceGUI.this.updateFromOtherThread(SpaceGUI.this.getScrollableImage());
                                SpaceGUI.this.coolBar.setBusyFromOtherThread(false);
                            }
                            SpaceGUI.this.finish();
                            throw throwable2;
                        }
                        synchronized (object) {
                            SpaceGUI.this.step = null;
                            if (SpaceGUI.this.next != null) {
                                SpaceGUI.this.future = SpaceGUI.this.executorService.submit(SpaceGUI.this.next);
                                SpaceGUI.this.next = null;
                            } else {
                                SpaceGUI.this.future = null;
                            }
                            SpaceGUI.this.getProgressListener().finish();
                            SpaceGUI.this.getSubProgressListener().finish();
                            SpaceGUI.this.updateFromOtherThread(SpaceGUI.this.getScrollableImage());
                            SpaceGUI.this.coolBar.setBusyFromOtherThread(false);
                        }
                        SpaceGUI.this.finish();
                        break block39;
                    }
                    Object object = SpaceGUI.this.sync;
                    synchronized (object) {
                        SpaceGUI.this.step = null;
                        if (SpaceGUI.this.next != null) {
                            SpaceGUI.this.future = SpaceGUI.this.executorService.submit(SpaceGUI.this.next);
                            SpaceGUI.this.next = null;
                        } else {
                            SpaceGUI.this.future = null;
                        }
                        SpaceGUI.this.getProgressListener().finish();
                        SpaceGUI.this.getSubProgressListener().finish();
                        SpaceGUI.this.updateFromOtherThread(SpaceGUI.this.getScrollableImage());
                        SpaceGUI.this.coolBar.setBusyFromOtherThread(false);
                    }
                    SpaceGUI.this.finish();
                }
            }
        };
        Object object = this.sync;
        synchronized (object) {
            if (this.future == null || !this.future.cancel(true)) {
                this.future = this.executorService.submit(task);
            } else {
                this.next = task;
            }
        }
    }

    private Step first(Step step1, Step step2) {
        if (step1 == Step.COMPLETE || step2 == Step.COMPLETE) {
            return Step.COMPLETE;
        }
        if (step1 == Step.SCANNING || step2 == Step.SCANNING) {
            return Step.SCANNING;
        }
        if (step1 == Step.RENDERING || step2 == Step.RENDERING) {
            return Step.RENDERING;
        }
        if (step1 == Step.FILTERING || step2 == Step.FILTERING) {
            return Step.FILTERING;
        }
        return null;
    }

    protected abstract Scan<E3DAtom> scanning() throws Exception;

    protected E3DImageSWT rendering(Scan<E3DAtom> scan) throws InterruptedException {
        if (scan == null) {
            return null;
        }
        E3DVector focusPoint = scan.getCenter();
        E3DVector offset = this.getFocusPoint();
        this.voxelSize.set(scan.getElementSize());
        this.viewPos.set(this.getViewPosition());
        this.viewPos.add(offset);
        double ambient = this.getAmbient();
        Integer directedLightColor = this.getLightColor();
        Integer ambientLightColor = this.getAmbientLightColor();
        ArrayList<E3DLight> lights = new ArrayList<E3DLight>();
        for (E3DVector lightPos : this.getLightPositions()) {
            lightPos.add(offset);
            lights.add(new E3DLight.E3DUndirectedLight(directedLightColor, 2.0 - ambient, lightPos.dist(focusPoint), lightPos));
            lights.add(new E3DLight.E3DUndirectedLight(ambientLightColor, ambient, this.viewPos.dist(focusPoint), this.viewPos));
        }
        this.setViews(this.viewPos, focusPoint, lights);
        this.statistics.renderingClock.start();
        E3DEnvironment env = this.getEnvironment();
        E3DBoundingBox bounds = scan.getTightBounds();
        E3DScene scene = new E3DScene(bounds, scan, lights, this.viewPos, focusPoint, env);
        E3DMaterial defaultMaterial = this.getDefaultMaterial();
        E3DRayTracer rayTracer = this.switchOffShading ? new E3DNoShadingRayTracer() : new E3DRayTracer();
        rayTracer.setImageType(E3DImage.Type.SWT);
        rayTracer.setDefaultMaterial(defaultMaterial);
        rayTracer.setOffsetFactor(3.0);
        rayTracer.setMaxDepth(3);
        int width = this.getImageWidth();
        int height = this.getImageHeight();
        int depth = this.getZBufferDepth();
        float[][][] xyzBuffer = new float[width][height][3];
        rayTracer.addProgressListener(this.getSubProgressListener());
        E3DImageSWT image = (E3DImageSWT)rayTracer.getImage(scene, width, height, depth, xyzBuffer);
        rayTracer.removeProgressListener(this.getSubProgressListener());
        this.xyzBuffer = xyzBuffer;
        double r = bounds.radius();
        double d0 = this.viewPos.dist(focusPoint);
        this.dMinMax = new double[]{d0 - r, d0 + r};
        this.statistics.renderingClock.stop();
        return image;
    }

    protected E3DImageSWT filtering(E3DImageSWT source, E3DImageSWT target) throws Exception {
        HSBFilter hsbFilter;
        if (source == null) {
            return null;
        }
        this.statistics.filteringClock.start();
        if (target == null || target.getWidth() != source.getWidth() || target.getHeight() != source.getHeight()) {
            target = source.image(source.getWidth(), source.getHeight());
        }
        if (this.applyAllFiltersOnBackground) {
            source = this.setBG(source, target);
        }
        if (((E3DImageFilter)(hsbFilter = new HSBFilter(this.getHue(), this.getSaturation(), this.getBrightness()))).isChanging()) {
            this.getProgressListener().done(this.getProgressListener().done(), "HSB-filtering");
            hsbFilter.addProgressListener(this.getSubProgressListener());
            hsbFilter.filter(source, target);
            hsbFilter.removeProgressListener(this.getSubProgressListener());
            source = target;
            this.getProgressListener().done(this.getProgressListener().done() + 1, "finished HSB-filtering");
        } else {
            this.getProgressListener().done(this.getProgressListener().done() + 1, "no HSB-filtering");
        }
        ColorShiftFilter colorShiftFilter = new ColorShiftFilter(this.getShiftColor(), this.getBlueShift(), this.getWhiteShift(), this.viewPos, this.xyzBuffer, this.dMinMax[0], this.dMinMax[1]);
        if (this.xyzBuffer != null && colorShiftFilter.isChanging()) {
            this.getProgressListener().done(this.getProgressListener().done(), "color shifting");
            colorShiftFilter.addProgressListener(this.getSubProgressListener());
            colorShiftFilter.filter(source, target);
            colorShiftFilter.removeProgressListener(this.getSubProgressListener());
            source = target;
            this.getProgressListener().done(this.getProgressListener().done() + 1, "finished color shifting");
        } else {
            this.getProgressListener().done(this.getProgressListener().done() + 1, "no color shifting");
        }
        if (!this.applyAllFiltersOnBackground) {
            source = this.setBG(source, target);
        }
        double focalDistance = this.getFocalDistance();
        double maxBlurRadius = this.getMaxBlurRadius();
        FocusDepthFilter focusDepthFilter = new FocusDepthFilter(focalDistance, maxBlurRadius, this.viewPos, this.xyzBuffer, this.dMinMax[0], this.dMinMax[1]);
        if (this.xyzBuffer != null && focusDepthFilter.isChanging()) {
            this.getProgressListener().done(this.getProgressListener().done(), "introducing depth of focus");
            focusDepthFilter.addProgressListener(this.getSubProgressListener());
            focusDepthFilter.filter(source, target);
            focusDepthFilter.removeProgressListener(this.getSubProgressListener());
            source = target;
            this.getProgressListener().done(this.getProgressListener().done() + 1, "finished introducing depth of focus");
        } else {
            this.getProgressListener().done(this.getProgressListener().done() + 1, "no introducing depth of focus");
        }
        if (source != target) {
            int y = 0;
            while (y < source.getHeight()) {
                int x = 0;
                while (x < source.getWidth()) {
                    target.setRGB(x, y, source.getRGB(x, y));
                    ++x;
                }
                ++y;
            }
        }
        this.statistics.filteringClock.stop();
        return target;
    }

    protected void finish() {
    }

    private E3DImageSWT setBG(E3DImageSWT source, E3DImageSWT target) throws InterruptedException {
        BGImageFilter bgImageFilter = new BGImageFilter(this.getBGImage(), -1.0, BGImageFilter.HorizontalAlignment.CENTER, BGImageFilter.VerticalAlignment.MIDDLE);
        if (bgImageFilter.isChanging()) {
            this.getProgressListener().done(this.getProgressListener().done(), "setting background image");
            bgImageFilter.addProgressListener(this.getSubProgressListener());
            bgImageFilter.filter(source, target);
            bgImageFilter.removeProgressListener(this.getSubProgressListener());
            source = target;
            this.getProgressListener().done(this.getProgressListener().done() + 1, "finished setting background image");
        } else {
            this.getProgressListener().done(this.getProgressListener().done() + 1, "no setting background image");
        }
        BGColorFilter bgColorFilter = new BGColorFilter(this.getBGColor());
        if (bgColorFilter.isChanging()) {
            this.getProgressListener().done(this.getProgressListener().done(), "setting background color");
            bgColorFilter.addProgressListener(this.getSubProgressListener());
            bgColorFilter.filter(source, target);
            bgColorFilter.removeProgressListener(this.getSubProgressListener());
            source = target;
            this.getProgressListener().done(this.getProgressListener().done() + 1, "finished setting background color");
        } else {
            this.getProgressListener().done(this.getProgressListener().done() + 1, "no setting background color");
        }
        return source;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportOBJ() {
        if (this.xyzBuffer != null) {
            E3DFileDialog dialog = new E3DFileDialog(this.shell, "Export Wavefront OBJ file", 8192, new File[]{this.objFile}, new String[]{"OBJ Files", "All Files"}, new String[]{"*.obj;*.OBJ", "*.*"});
            File[] files = dialog.open();
            if (files != null && files.length == 1 && files[0] != null) {
                this.objFile = files[0];
                this.getProgressListener().init(1, "Exporting to Wavefront obj");
                Runnable task = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block25: {
                            try {
                                try {
                                    Object exporter;
                                    Object object = SpaceGUI.this.sync;
                                    synchronized (object) {
                                        SpaceGUI.this.coolBar.setBusyFromOtherThread(true);
                                    }
                                    if (SpaceGUI.this.scan instanceof BinarySpace) {
                                        exporter = new WavefrontSpaceExporter();
                                        ((WavefrontSpaceExporter)exporter).addProgressListener(SpaceGUI.this.getSubProgressListener());
                                        File imgFile = new File(String.valueOf(SpaceGUI.this.objFile.getAbsolutePath()) + ".png");
                                        ((WavefrontSpaceExporter)exporter).export((BinarySpace)SpaceGUI.this.scan, SpaceGUI.this.objFile, imgFile);
                                        SpaceGUI.this.getProgressListener().done(1, "finished exporting to Wavefront obj");
                                    } else {
                                        exporter = new WavefrontZBufferExporter();
                                        ((WavefrontZBufferExporter)exporter).addProgressListener(SpaceGUI.this.getSubProgressListener());
                                        ((WavefrontZBufferExporter)exporter).export(SpaceGUI.this.xyzBuffer, SpaceGUI.this.objFile);
                                        SpaceGUI.this.getProgressListener().done(1, "finished exporting to Wavefront obj");
                                    }
                                }
                                catch (InterruptedException interruptedException) {
                                    Object object = SpaceGUI.this.sync;
                                    synchronized (object) {
                                        if (SpaceGUI.this.next != null) {
                                            SpaceGUI.this.future = SpaceGUI.this.executorService.submit(SpaceGUI.this.next);
                                            SpaceGUI.this.next = null;
                                        } else {
                                            SpaceGUI.this.future = null;
                                        }
                                        SpaceGUI.this.getProgressListener().finish();
                                        SpaceGUI.this.getSubProgressListener().finish();
                                        SpaceGUI.this.updateFromOtherThread(SpaceGUI.this.getScrollableImage());
                                        SpaceGUI.this.coolBar.setBusyFromOtherThread(false);
                                        break block25;
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object object = SpaceGUI.this.sync;
                                synchronized (object) {
                                    if (SpaceGUI.this.next != null) {
                                        SpaceGUI.this.future = SpaceGUI.this.executorService.submit(SpaceGUI.this.next);
                                        SpaceGUI.this.next = null;
                                    } else {
                                        SpaceGUI.this.future = null;
                                    }
                                    SpaceGUI.this.getProgressListener().finish();
                                    SpaceGUI.this.getSubProgressListener().finish();
                                    SpaceGUI.this.updateFromOtherThread(SpaceGUI.this.getScrollableImage());
                                    SpaceGUI.this.coolBar.setBusyFromOtherThread(false);
                                }
                                throw throwable;
                            }
                            Object object = SpaceGUI.this.sync;
                            synchronized (object) {
                                if (SpaceGUI.this.next != null) {
                                    SpaceGUI.this.future = SpaceGUI.this.executorService.submit(SpaceGUI.this.next);
                                    SpaceGUI.this.next = null;
                                } else {
                                    SpaceGUI.this.future = null;
                                }
                                SpaceGUI.this.getProgressListener().finish();
                                SpaceGUI.this.getSubProgressListener().finish();
                                SpaceGUI.this.updateFromOtherThread(SpaceGUI.this.getScrollableImage());
                                SpaceGUI.this.coolBar.setBusyFromOtherThread(false);
                            }
                        }
                    }
                };
                Object object = this.sync;
                synchronized (object) {
                    if (this.future == null || !this.future.cancel(true)) {
                        this.future = this.executorService.submit(task);
                    } else {
                        this.next = task;
                    }
                }
            } else {
                this.getProgressListener().finish();
            }
        } else {
            this.getProgressListener().finish();
        }
    }

    protected void extendFileMenu() {
        new MenuItem(this.menu.fileMenu, 2);
        MenuItem exportOBJItem = new MenuItem(this.menu.fileMenu, 8);
        exportOBJItem.setEnabled(true);
        exportOBJItem.setImage(Icons.getSWTImage(this.shell.getDisplay(), "get_focus.png"));
        exportOBJItem.setText("Export Wavefront OBJ file...\tCtrl+E");
        exportOBJItem.setAccelerator(262213);
        exportOBJItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SpaceGUI.this.exportOBJ();
            }
        });
    }

    protected void extendViewMenu() {
        final MenuItem switchOffShadingItem = new MenuItem(this.menu.optionsMenu, 32);
        switchOffShadingItem.setText("Switch off shading?\tCtrl + R");
        switchOffShadingItem.setAccelerator(262226);
        switchOffShadingItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SpaceGUI.this.switchOffShading = switchOffShadingItem.getSelection();
                if (SpaceGUI.this.auto) {
                    SpaceGUI.this.restart(Step.RENDERING);
                }
            }
        });
        final MenuItem directlyVisibleItem = new MenuItem(this.menu.optionsMenu, 32);
        directlyVisibleItem.setText("Is environment directly visible?\tCtrl + D");
        directlyVisibleItem.setAccelerator(262212);
        directlyVisibleItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SpaceGUI.this.envDirectlyVisible = directlyVisibleItem.getSelection();
                if (SpaceGUI.this.auto) {
                    SpaceGUI.this.restart(Step.RENDERING);
                }
            }
        });
        final MenuItem applyAllFiltersOnBGItem = new MenuItem(this.menu.optionsMenu, 32);
        applyAllFiltersOnBGItem.setText("Apply all filters on background?\tCtrl + A");
        applyAllFiltersOnBGItem.setAccelerator(262209);
        applyAllFiltersOnBGItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                SpaceGUI.this.applyAllFiltersOnBackground = applyAllFiltersOnBGItem.getSelection();
                if (SpaceGUI.this.auto) {
                    SpaceGUI.this.restart(Step.FILTERING);
                }
            }
        });
    }

    protected void showStatistics() {
        int points = this.scan == null ? 0 : this.scan.getWidth() * this.scan.getHeight() * this.scan.getDepth();
        this.showStatistics(String.format("- Search space has %d points\n- Calculated %d points (%g%%)\n- Found %d solid points (%g%%)\n- Found %d points on the surface (%g%%)\n- Scanning took %s\n- Rendering took %s\n- Filtering took %s", points, this.statistics.getNumberOfCalculatedPoints(), (double)this.statistics.getNumberOfCalculatedPoints() * 100.0 / (double)points, this.statistics.getNumberOfSolidPoints(), (double)this.statistics.getNumberOfSolidPoints() * 100.0 / (double)this.statistics.getNumberOfCalculatedPoints(), this.statistics.getNumberOfSurfacePoints(), (double)this.statistics.getNumberOfSurfacePoints() * 100.0 / (double)this.statistics.getNumberOfSolidPoints(), this.statistics.getPreciseScanningTime(), this.statistics.getPreciseRenderingTime(), this.statistics.getPreciseFilteringTime()));
    }

    protected WidgetGroupEditedListener getAutoListener(final Step step) {
        return new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
                if (SpaceGUI.this.auto) {
                    SpaceGUI.this.restart(step);
                }
            }
        };
    }

    protected static enum Step {
        COMPLETE,
        SCANNING,
        RENDERING,
        FILTERING;

    }
}

