/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui;

import com.sun.j3d.utils.picking.PickIntersection;
import e3d.bezier.BezierCurve2P2N;
import e3d.bezier.Needle;
import e3d.bezier.NeedleMesh;
import e3d.bezier.NeedleMeshes;
import e3d.bezier.PointMesh;
import e3d.bezier.PointMeshes;
import e3d.bezier.Position;
import e3d.bezier.Surfaces;
import e3d.euclidean.E3DVector;
import e3d.gui.E3DGUI;
import e3d.gui.groups.FileGroup;
import e3d.gui.groups.ListGroup;
import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.groups.scales.ColorScaleGroup;
import e3d.gui.groups.scales.RotationScaleGroup;
import e3d.gui.groups.scales.SingleHorizontalScaleGroup;
import e3d.gui.groups.scales.SingleVerticalScaleGroup;
import e3d.gui.groups.scales.XYZScaleGroup;
import e3d.gui.groups.scales.ZoomScaleGroup;
import e3d.gui.groups.scales.special.InterpolationRadiusScaleGroup;
import e3d.gui.groups.scales.special.MaterialScaleGroup;
import e3d.gui.groups.scales.special.MeltingRadiusScaleGroup;
import e3d.gui.groups.scales.special.OpacityScaleGroup;
import e3d.gui.groups.scales.special.RoundnessScaleGroup;
import e3d.gui.groups.special.BrushGroup;
import e3d.gui.groups.special.CircleTemplateGroup;
import e3d.gui.groups.special.CylinderTemplateGroup;
import e3d.gui.groups.special.LayerMeshTemplateGroup;
import e3d.gui.groups.special.RectangleTemplateGroup;
import e3d.gui.groups.special.ShapeTemplateGroup;
import e3d.gui.groups.special.SphereTemplateGroup;
import e3d.gui.groups.special.TagListGroup;
import e3d.gui.groups.special.VolumeTemplateGroup;
import e3d.gui.icons.Icons;
import e3d.gui.utils.E3DFileDialog;
import e3d.gui.utils.E3DHelp;
import e3d.gui.utils.IconButton;
import e3d.gui.utils.SWTUtils;
import e3d.gui.utils.ToggleButton;
import e3d.io.obj.WavefrontMeshExporter;
import e3d.io.xml.XMLMeshObjects;
import e3d.io.xml.XMLMeshParser;
import e3d.j3d.J3DCanvas;
import e3d.j3d.history.GroupHistoryState;
import e3d.j3d.history.HistoryState;
import e3d.j3d.history.J3DHistory;
import e3d.j3d.history.NeedleHistoryState;
import e3d.j3d.history.PointHistoryState;
import e3d.j3d.interfaces.J3DColoredObject;
import e3d.j3d.interfaces.J3DInstance;
import e3d.j3d.interfaces.J3DMasterObject;
import e3d.j3d.interfaces.J3DMaterialObject;
import e3d.j3d.interfaces.J3DOrientedObject;
import e3d.j3d.interfaces.J3DSlaveObject;
import e3d.j3d.interfaces.J3DTexturedObject;
import e3d.j3d.objects.J3DAmbientLight;
import e3d.j3d.objects.J3DCenteredObject;
import e3d.j3d.objects.J3DDirectLight;
import e3d.j3d.objects.J3DDoubleNeedle;
import e3d.j3d.objects.J3DGroup;
import e3d.j3d.objects.J3DInterpolationRadius;
import e3d.j3d.objects.J3DLayerMesh;
import e3d.j3d.objects.J3DNeedle;
import e3d.j3d.objects.J3DNeedleMesh;
import e3d.j3d.objects.J3DPoint;
import e3d.j3d.objects.J3DPointMesh;
import e3d.j3d.objects.J3DRectangle;
import e3d.j3d.objects.J3DRuler;
import e3d.j3d.objects.J3DSelectionGroup;
import e3d.j3d.objects.J3DSurface;
import e3d.j3d.objects.J3DVolume;
import e3d.j3d.util.J3DEventAdapter;
import e3d.j3d.util.J3DEventListener;
import e3d.j3d.util.J3DLockListener;
import e3d.j3d.util.J3DSceneView;
import e3d.j3d.util.J3DTexturePainter;
import e3d.j3d.util.J3DTextureUtils;
import e3d.texture.E3DTextureFile;
import e3d.texture.TexturePlane;
import e3d.texture.TexturePlanes;
import e3d.utils.ArrayFactory;
import e3d.utils.ArrayUtils;
import e3d.utils.Getter;
import e3d.utils.Tagger;
import e3d.visualization.image.E3DImageAWT;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import e3d.visualization.util.Matrix2D;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.media.j3d.ImageComponent2D;
import javax.media.j3d.Texture;
import javax.media.j3d.Texture2D;
import javax.media.j3d.Texture3D;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord3f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.jdom2.DataConversionException;
import org.jdom2.JDOMException;

public class J3DEditorGUI
extends E3DGUI {
    public static final int FRONT = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int BACK = 3;
    public static final int BOTTOM = 4;
    public static final int RIGHT = 5;
    private static final String NAME = "3D Bezier Editor (V3.5)";
    private static final String HELP_URI = "help/bezier-editor/index";
    private static final int IMAGE_DEFAULT_WIDTH = 600;
    private static final int IMAGE_DEFAULT_HEIGHT = 600;
    private static final double STANDARD_ZOOM_FACTOR = 1.5;
    private static final Map<Integer, Integer> SWTKEYCODE2AWTKEYCODE = new HashMap<Integer, Integer>();
    protected File sceneFile = null;
    protected final J3DCanvas canvas;
    protected final J3DHistory history;
    protected Texture2D[] textures = new Texture2D[6];
    protected final J3DRectangle frontBackRectangle;
    protected final J3DRectangle leftRightRectangle;
    protected final J3DRectangle topBottomRectangle;
    private final J3DNeedle.Parameters needleParameters = J3DNeedle.getDefaultParameters();
    private final J3DPoint.Parameters pointParameters = J3DPoint.getDefaultParameters();
    private final J3DNeedleMesh.Parameters needleMeshParameters = J3DNeedleMesh.getDefaultParameters();
    private final J3DPointMesh.Parameters pointMeshParameters = J3DPointMesh.getDefaultParameters();
    public final J3DLayerMesh.Parameters layerMeshParameters = J3DLayerMesh.getDefaultParameters();
    private final J3DAmbientLight.Parameters ambientLightParameters = J3DAmbientLight.getDefaultParameters();
    private final J3DDirectLight.Parameters directLightParameters = J3DDirectLight.getDefaultParameters();
    private final J3DRuler.Parameters rulerParametes = J3DRuler.getDefaultParameters();
    public final J3DVolume.Parameters volumeParameters = J3DVolume.getDefaultParameters();
    public final J3DInterpolationRadius.Parameters interpolationSphereParameters = J3DInterpolationRadius.getDefaultParameters();
    private final J3DHistory.Parameters historyParameters = J3DHistory.getDefaultParameters();
    protected final XYZScaleGroup viewDirectionScales;
    protected final XYZScaleGroup viewTranslationScales;
    protected final RotationScaleGroup viewRotationScales;
    final ZoomScaleGroup zoomScale;
    protected final XYZScaleGroup lightPositionScales;
    protected final XYZScaleGroup rectanglePositionScales;
    protected final SingleVerticalScaleGroup focalScale;
    protected final SingleHorizontalScaleGroup pointAndNeedleSizeScale;
    protected final FileGroup textureFiles;
    protected final ColorScaleGroup colorScales;
    protected final BrushGroup brushGroup;
    protected final OpacityScaleGroup opacityScale;
    protected final MaterialScaleGroup materialScales;
    protected final RoundnessScaleGroup roundnessScales;
    protected final MeltingRadiusScaleGroup meltingRadiusScale;
    protected final InterpolationRadiusScaleGroup interpolationRadiusScale;
    protected final Getter<J3DNeedle.Function> needleInterpolationFunctionGetter;
    protected final Getter<J3DPoint.Function> pointInterpolationFunctionGetter;
    protected final FileGroup individualTexture;
    protected final SingleHorizontalScaleGroup scalingScale;
    protected final WidgetGroup polygonAndShadingButtons;
    protected final SingleHorizontalScaleGroup resolutionScales;
    protected double currentScalingFactor = 1.0;
    protected final ListGroup tagLists;
    protected final XMLMeshObjects copied = new XMLMeshObjects(new NeedleMeshes(), new PointMeshes(), new Surfaces(), new TexturePlanes(), new Tagger<Object>());
    protected Set<J3DInstance> interpolationObjects = null;
    protected final Tagger<J3DInstance> tagger = new Tagger();
    protected final J3DRuler ruler;
    protected final J3DInterpolationRadius interpolationRadius;
    private TexCoord3f lastPaintCoordinates = null;
    private J3DInstance lastPaintedObject = null;
    private final Set<J3DInstance> paintedObjects = new HashSet<J3DInstance>();
    protected boolean selectionAddMode = false;
    protected boolean selectColumnMode = false;
    protected boolean selectRowMode = false;
    protected boolean paintMode = false;

    static {
        SWTKEYCODE2AWTKEYCODE.put(131072, 16);
        SWTKEYCODE2AWTKEYCODE.put(262144, 17);
        SWTKEYCODE2AWTKEYCODE.put(65536, 18);
        SWTKEYCODE2AWTKEYCODE.put(0x1000007, 65368);
        SWTKEYCODE2AWTKEYCODE.put(0x1000008, 35);
        SWTKEYCODE2AWTKEYCODE.put(0x1000005, 33);
        SWTKEYCODE2AWTKEYCODE.put(0x1000006, 34);
        SWTKEYCODE2AWTKEYCODE.put(0x1000009, 155);
        SWTKEYCODE2AWTKEYCODE.put(0x1000055, 19);
        SWTKEYCODE2AWTKEYCODE.put(0x1000003, 37);
        SWTKEYCODE2AWTKEYCODE.put(0x1000004, 39);
        SWTKEYCODE2AWTKEYCODE.put(0x1000001, 38);
        SWTKEYCODE2AWTKEYCODE.put(0x1000002, 40);
        SWTKEYCODE2AWTKEYCODE.put(9, 9);
        SWTKEYCODE2AWTKEYCODE.put(13, 10);
        SWTKEYCODE2AWTKEYCODE.put(127, 127);
        SWTKEYCODE2AWTKEYCODE.put(327680, 65406);
    }

    public J3DEditorGUI() throws IOException {
        this.shell.setText(NAME);
        this.extendEditMenu();
        this.extendViewMenu();
        Composite main = new Composite(this.shell, 0);
        main.setLayoutData(new GridData(4, 4, true, true));
        main.setLayout(new GridLayout(2, false));
        final Composite canvasFrame = new Composite(main, 0x1000000);
        canvasFrame.setLayoutData(new GridData(4, 4, true, true));
        canvasFrame.setLayout(new GridLayout(1, false));
        ((GridData)canvasFrame.getLayoutData()).widthHint = 600;
        ((GridData)canvasFrame.getLayoutData()).heightHint = 600;
        this.canvas = new J3DCanvas();
        this.canvas.setSize(600, 600);
        final Frame swtAWT = SWT_AWT.new_Frame(canvasFrame);
        swtAWT.setSize(600, 600);
        swtAWT.add((Component)((Object)this.canvas));
        canvasFrame.forceFocus();
        canvasFrame.addKeyListener(new KeyListener(){

            private java.awt.event.KeyEvent swt2awt(KeyEvent event, int type) {
                Integer keyCode = (Integer)SWTKEYCODE2AWTKEYCODE.get(event.keyCode);
                return new java.awt.event.KeyEvent((Component)((Object)J3DEditorGUI.this.canvas), type, (long)event.time & 0xFFFFFFFFL, event.stateMask, keyCode != null ? keyCode : event.keyCode, event.character);
            }

            @Override
            public void keyPressed(KeyEvent event) {
                event.doit = false;
                J3DEditorGUI.this.canvas.keyPressed(this.swt2awt(event, 401));
            }

            @Override
            public void keyReleased(KeyEvent event) {
                event.doit = false;
                J3DEditorGUI.this.canvas.keyReleased(this.swt2awt(event, 402));
            }
        });
        System.out.println("[PROPERTIES]__________________________________________");
        for (Object key : this.canvas.queryProperties().keySet()) {
            System.out.println(String.valueOf(String.format("%-42s = ", key)) + this.canvas.queryProperties().get(key));
        }
        System.out.println("[PROPERTIES END]______________________________________");
        if ((Integer)this.canvas.queryProperties().get("textureUnitStateMax") < 4) {
            this.showWarning("Sorry, your system cannot show at least 4 different textures on one object,\nso you won't be able to see all \"world-box textures\" on your objects.");
        }
        canvasFrame.addPaintListener(new PaintListener(){

            @Override
            public void paintControl(PaintEvent e) {
                J3DEditorGUI.this.canvas.repaint();
            }
        });
        J3DRectangle.Parameters rectangleParameters = J3DRectangle.getDefaultParameters();
        Needle bgTangent = new Needle(new Position(0.0, 0.0, 0.0), new E3DVector(0.0, 0.0, -1.0));
        Needle topTangent = new Needle(new Position(0.0, 0.0, 0.0), new E3DVector(0.0, -1.0, 0.0));
        Needle sideTangent = new Needle(new Position(0.0, 0.0, 0.0), new E3DVector(1.0, 0.0, 0.0));
        this.frontBackRectangle = new J3DRectangle(null, 0, 2.0, 2.0, 0.02, bgTangent, false, rectangleParameters);
        this.topBottomRectangle = new J3DRectangle(null, 0, 2.0, 2.0, 0.02, topTangent, false, rectangleParameters);
        this.leftRightRectangle = new J3DRectangle(null, 3, 2.0, 2.0, 0.02, sideTangent, false, rectangleParameters);
        this.frontBackRectangle.compile();
        this.topBottomRectangle.compile();
        this.leftRightRectangle.compile();
        this.canvas.addEventListener(this.createCanvasListener());
        this.canvas.getScene().addEventListener(this.createSceneListener());
        this.canvas.addLockListener(new J3DLockListener(){

            private void enable(final boolean enable) {
                J3DEditorGUI.this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).J3DEditorGUI.this.shell.setEnabled(enable);
                    }
                });
            }

            @Override
            public void locked() {
                this.enable(false);
            }

            @Override
            public void unlocked() {
                this.enable(true);
            }
        });
        WidgetGroupEditedListener canvasFocusListener = new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
                canvasFrame.forceFocus();
                swtAWT.requestFocus();
                J3DEditorGUI.this.canvas.requestFocus();
            }
        };
        J3DAmbientLight ambientLight = this.createAmbientLight();
        J3DDirectLight directLight = this.createDirectLight();
        ambientLight.compile();
        directLight.compile();
        this.canvas.getLights().addObject(ambientLight);
        this.canvas.getLights().addObject(directLight);
        this.history = new J3DHistory(this.historyParameters, this.tagger);
        this.history.add(this.canvas.getScene());
        this.history.add(this.canvas.getSelection());
        this.history.add(this.canvas.getHidden());
        this.history.next();
        Composite controlFrame = new Composite(main, 0);
        controlFrame.setLayout(new GridLayout(1, false));
        controlFrame.setLayoutData(new GridData(4, 4, false, true));
        final TabFolder tabFolder = new TabFolder(controlFrame, 128);
        tabFolder.setLayoutData(new GridData(4));
        tabFolder.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                tabFolder.update();
            }
        });
        Composite euclideanFrame = new Composite(tabFolder, 0);
        euclideanFrame.setLayout(new GridLayout(4, false));
        euclideanFrame.setLayoutData(new GridData(4, 4, true, true));
        this.zoomScale = this.createZoomScales(euclideanFrame);
        ((GridData)this.zoomScale.getGroup().getLayoutData()).verticalSpan = 2;
        this.viewDirectionScales = this.createViewDirectionScales(euclideanFrame);
        this.viewRotationScales = this.createViewRotationScales(euclideanFrame);
        this.viewTranslationScales = this.createViewTranslationScales(euclideanFrame);
        this.lightPositionScales = this.createLightPositionScales(euclideanFrame, directLight);
        this.focalScale = this.createFocalScales(euclideanFrame);
        this.rectanglePositionScales = this.createRectanglePositionScales(euclideanFrame);
        this.textureFiles = this.createBoxTextureFileGroup(euclideanFrame);
        ((GridData)this.textureFiles.getGroup().getLayoutData()).horizontalSpan = 4;
        ((GridData)this.textureFiles.getGroup().getLayoutData()).horizontalAlignment = 4;
        this.pointAndNeedleSizeScale = this.createPointAndNeedleSizeScales(euclideanFrame);
        ((GridData)this.pointAndNeedleSizeScale.getGroup().getLayoutData()).horizontalSpan = 2;
        ((GridData)this.pointAndNeedleSizeScale.getGroup().getLayoutData()).horizontalAlignment = 4;
        this.scalingScale = this.createScalingScales(euclideanFrame);
        ((GridData)this.scalingScale.getGroup().getLayoutData()).horizontalSpan = 2;
        ((GridData)this.scalingScale.getGroup().getLayoutData()).horizontalAlignment = 4;
        this.resolutionScales = this.createResolutionScales(euclideanFrame);
        ((GridData)this.resolutionScales.getGroup().getLayoutData()).horizontalSpan = 2;
        ((GridData)this.resolutionScales.getGroup().getLayoutData()).horizontalAlignment = 4;
        this.polygonAndShadingButtons = this.createPolygonAndShadingButtons(euclideanFrame);
        ((GridData)this.polygonAndShadingButtons.getGroup().getLayoutData()).horizontalSpan = 2;
        ((GridData)this.polygonAndShadingButtons.getGroup().getLayoutData()).horizontalAlignment = 4;
        TabItem euclideanTab = new TabItem(tabFolder, 0);
        euclideanTab.setText("3D / VIEW");
        euclideanTab.setControl(euclideanFrame);
        Composite optionFrame = new Composite(tabFolder, 0);
        optionFrame.setLayout(new GridLayout(3, false));
        optionFrame.setLayoutData(new GridData(4, 4, true, true));
        this.tagLists = this.createTagListGroup(optionFrame);
        ((GridData)this.tagLists.getGroup().getLayoutData()).verticalSpan = 2;
        this.colorScales = this.createColorScaleGroup(optionFrame);
        this.colorScales.addListener(canvasFocusListener);
        ((GridData)this.colorScales.getGroup().getLayoutData()).horizontalSpan = 2;
        this.roundnessScales = this.createRoundnessScaleGroup(optionFrame);
        this.materialScales = this.createMaterialScaleGroup(optionFrame);
        this.interpolationRadiusScale = new InterpolationRadiusScaleGroup(optionFrame, "Interpolation Radius", 0, 50, true);
        this.interpolationRadiusScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                J3DEditorGUI.this.interpolationRadius.setRadius((float)J3DEditorGUI.this.interpolationRadiusScale.getRadius());
                J3DEditorGUI.this.canvas.setTraceMouseMotions(J3DEditorGUI.this.needToTraceMouseMotions());
            }
        });
        this.needleInterpolationFunctionGetter = new Getter<J3DNeedle.Function>(){

            @Override
            public J3DNeedle.Function get() {
                switch (J3DEditorGUI.this.interpolationRadiusScale.getFunction()) {
                    case QUADRATIC: {
                        return J3DNeedle.Function.QUADRATIC;
                    }
                    case SIGMOIDAL: {
                        return J3DNeedle.Function.SIGMOIDAL;
                    }
                    case PLATEAU: {
                        return J3DNeedle.Function.PLATEAU;
                    }
                }
                return J3DNeedle.Function.LINEAR;
            }
        };
        this.pointInterpolationFunctionGetter = new Getter<J3DPoint.Function>(){

            @Override
            public J3DPoint.Function get() {
                switch (J3DEditorGUI.this.interpolationRadiusScale.getFunction()) {
                    case QUADRATIC: {
                        return J3DPoint.Function.QUADRATIC;
                    }
                    case SIGMOIDAL: {
                        return J3DPoint.Function.SIGMOIDAL;
                    }
                    case PLATEAU: {
                        return J3DPoint.Function.PLATEAU;
                    }
                }
                return J3DPoint.Function.LINEAR;
            }
        };
        this.meltingRadiusScale = this.createMeltingRadiusScaleGroup(optionFrame);
        ((GridData)this.meltingRadiusScale.getGroup().getLayoutData()).horizontalSpan = 2;
        this.individualTexture = this.createIndividualTextureFileGroup(optionFrame);
        ((GridData)this.individualTexture.getGroup().getLayoutData()).horizontalSpan = 3;
        this.brushGroup = new BrushGroup(optionFrame);
        this.brushGroup.getGroup().setToolTipText("Press 'Shift' while moving the mouse\nto paint on objects (objects must have\ntextures to paint on them)");
        this.brushGroup.addListener(canvasFocusListener);
        this.opacityScale = new OpacityScaleGroup(optionFrame, "Opacity", 1, 100, true);
        this.opacityScale.addListener(canvasFocusListener);
        ((GridData)this.opacityScale.getGroup().getLayoutData()).horizontalSpan = 2;
        TabItem optionTab = new TabItem(tabFolder, 0);
        optionTab.setText("EDIT");
        optionTab.setControl(optionFrame);
        Composite templateFrame = new Composite(tabFolder, 0);
        templateFrame.setLayout(new GridLayout(1, false));
        templateFrame.setLayoutData(new GridData(4, 4, true, true));
        this.createTemplateGroups(templateFrame);
        TabItem templateTab = new TabItem(tabFolder, 0);
        templateTab.setText("TEMPLATES");
        templateTab.setControl(templateFrame);
        Point size = this.shell.computeSize(-1, -1);
        this.shell.setSize(Math.min(1800, size.x), Math.min(1200, size.y));
        this.tagger.addTags(TexturePlane.SIDETAGS);
        this.updateTagLists();
        this.coolBar.setSavable(true);
        this.menu.setSavable(true);
        this.ruler = this.createRuler(this.canvas);
        this.canvas.getScene().addObject(this.ruler);
        this.interpolationRadius = new J3DInterpolationRadius(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, this.interpolationSphereParameters);
        this.canvas.addEventListener(new J3DEventAdapter(){

            @Override
            public void movedOver(J3DInstance object, MouseEvent event, PickIntersection intersection) {
                if (object != null && intersection != null) {
                    try {
                        Point3d pos = intersection.getPointCoordinates();
                        object.transform(pos);
                        J3DEditorGUI.this.interpolationRadius.setPosition(pos);
                        if (J3DEditorGUI.this.interpolationRadius.getGroup() == null) {
                            J3DEditorGUI.this.canvas.getScene().addObject(J3DEditorGUI.this.interpolationRadius);
                        }
                    }
                    catch (Exception exception) {}
                } else if (J3DEditorGUI.this.interpolationRadius.getGroup() != null) {
                    J3DEditorGUI.this.canvas.getScene().removeObject(J3DEditorGUI.this.interpolationRadius);
                }
            }
        });
        this.run();
    }

    @Override
    public void exit() {
        try {
            this.canvas.dispose();
            this.shell.dispose();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public J3DCanvas getCanvas() {
        return this.canvas;
    }

    public J3DHistory getHistory() {
        return this.history;
    }

    public Tagger<J3DInstance> getTagger() {
        return this.tagger;
    }

    public Texture2D getTexture(int side) {
        return this.textures[side];
    }

    public List<J3DInstance> getSelected() {
        return this.canvas.getSelection().getObjectOrder();
    }

    public Set<J3DInstance> getNormal() {
        return this.canvas.getScene().getObjects();
    }

    public Set<J3DInstance> getHidden() {
        return this.canvas.getHidden().getObjects();
    }

    public void clear() {
        for (J3DInstance object : new Vector<J3DInstance>(this.getNormal())) {
            if (!(object instanceof J3DNeedle) && !(object instanceof J3DPoint) && !(object instanceof J3DPointMesh) && !(object instanceof J3DNeedleMesh)) continue;
            this.canvas.getScene().removeObject(object);
        }
        this.canvas.getSelection().removeAllObjects();
        this.canvas.getSelection().getAnchor().setTransform(new Transform3D());
        this.canvas.getHidden().removeAllObjects();
        this.tagger.clear();
        this.tagger.addTags(TexturePlane.SIDETAGS);
        this.updateTagLists();
        this.setViewDirection(ViewDirection.FRONT);
        this.history.clear();
        this.history.add(this.canvas.getScene());
        this.history.add(this.canvas.getSelection());
        this.history.add(this.canvas.getHidden());
        this.history.next();
    }

    @Override
    public float getJPGQuality() {
        return 0.9f;
    }

    @Override
    public boolean isStartable() {
        return false;
    }

    @Override
    public boolean hasEditMenu() {
        return true;
    }

    @Override
    public boolean hasViewMenu() {
        return true;
    }

    @Override
    public boolean hasOptionsMenu() {
        return false;
    }

    @Override
    public void setAutomaticRestart(boolean auto) {
    }

    @Override
    public boolean hasLoadItem() {
        return true;
    }

    @Override
    public void load() {
        this.load(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(boolean merge) {
        E3DFileDialog dialog = new E3DFileDialog(this.shell, "Load File", 4096, new File[]{this.sceneFile}, new String[]{"XML Files", "All Files"}, new String[]{"*.xml;*.XML", "*.*"});
        File[] files = dialog.open();
        if (files != null) {
            this.sceneFile = files[0];
            J3DCanvas j3DCanvas = this.canvas;
            synchronized (j3DCanvas) {
                block10: {
                    J3DCanvas.Lock lock = this.canvas.lock();
                    try {
                        try {
                            if (!merge) {
                                this.clear();
                            }
                            this.loadFile(files[0], merge);
                        }
                        catch (Exception exception) {
                            MessageBox msgBox = new MessageBox(this.shell, 33);
                            msgBox.setText("Load Error");
                            msgBox.setMessage(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
                            msgBox.open();
                            exception.printStackTrace();
                            this.history.next();
                            this.canvas.unlock(lock);
                            break block10;
                        }
                    }
                    catch (Throwable throwable) {
                        this.history.next();
                        this.canvas.unlock(lock);
                        throw throwable;
                    }
                    this.history.next();
                    this.canvas.unlock(lock);
                }
            }
        }
    }

    public void loadFile(File file, boolean select) throws IOException, DataConversionException, JDOMException {
        if (file.getName().endsWith(".dmp")) {
            throw new UnsupportedOperationException("Sorry \"dump-files\" are not supported anymore.");
        }
        XMLMeshParser parser = new XMLMeshParser();
        parser.setBaseDirectory(file.getParentFile());
        XMLMeshObjects objects = (XMLMeshObjects)parser.readXML(file);
        NeedleMeshes needleMeshes = objects.getNeedleMeshes();
        PointMeshes pointMeshes = objects.getPointMeshes();
        TexturePlanes texturePlanes = objects.getTexturePlanes();
        Tagger<Object> tagger = objects.getTagger();
        HashMap<Needle, J3DNeedle> tangent2needle = new HashMap<Needle, J3DNeedle>();
        for (NeedleMesh mesh : needleMeshes) {
            Matrix2D<J3DNeedle> needles = new Matrix2D<J3DNeedle>(mesh.width(), mesh.height(), ArrayFactory.J3DNEEDLE, null);
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    Needle tangent = (Needle)mesh.get(x, y);
                    if (tangent != null) {
                        J3DNeedle needle = (J3DNeedle)tangent2needle.get(tangent);
                        if (needle == null) {
                            Needle transformedTangent = tangent.clone();
                            transformedTangent.point.y *= -1.0;
                            transformedTangent.point.z *= -1.0;
                            transformedTangent.normal.y *= -1.0;
                            transformedTangent.normal.z *= -1.0;
                            Set<String> tags = objects.getTagger().getTags(tangent);
                            needle = this.createNeedle(transformedTangent, tags, select);
                            tangent2needle.put(tangent, needle);
                        }
                        needles.set(x, y, needle);
                    }
                    ++x;
                }
                ++y;
            }
            Set<String> tags = tagger.getTags(mesh);
            Color3f color = new Color3f((float)mesh.getColor().getRed() / 255.0f, (float)mesh.getColor().getGreen() / 255.0f, (float)mesh.getColor().getBlue() / 255.0f);
            this.createNeedleMesh(needles, color, mesh.getMaterial(), mesh.getTexture(), mesh.getRoundness(), tags, select);
        }
        HashMap<Position, J3DPoint> position2point = new HashMap<Position, J3DPoint>();
        for (PointMesh mesh : pointMeshes) {
            Matrix2D<J3DPoint> points = new Matrix2D<J3DPoint>(mesh.width(), mesh.height(), ArrayFactory.J3DPOINT, null);
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    Position position = (Position)mesh.get(x, y);
                    if (position != null) {
                        J3DPoint point = (J3DPoint)position2point.get(position);
                        if (point == null) {
                            Position transformedPosition = position.clone();
                            transformedPosition.y *= -1.0;
                            transformedPosition.z *= -1.0;
                            Set<String> tags = objects.getTagger().getTags(position);
                            point = this.createPoint(transformedPosition, tags, select);
                            position2point.put(position, point);
                        }
                        points.set(x, y, point);
                    }
                    ++x;
                }
                ++y;
            }
            Set<String> tags = tagger.getTags(mesh);
            Color3f color = new Color3f((float)mesh.getColor().getRed() / 255.0f, (float)mesh.getColor().getGreen() / 255.0f, (float)mesh.getColor().getBlue() / 255.0f);
            this.createPointMesh(points, color, mesh.getMaterial(), mesh.getTexture(), mesh.getRoundness(), tags, select);
        }
        this.updateTagLists();
        for (TexturePlane texturePlane : texturePlanes) {
            Texture2D texture = J3DTextureUtils.createTexture2D(texturePlane.getFile(), texturePlane.isEnabled(), texturePlane.getTag().equals("_BACK") || texturePlane.getTag().equals("_RIGHT"), !texturePlane.getTag().equals("_TOP"), true);
            if (texturePlane.getTag().equals("_FRONT")) {
                this.textureFiles.setFiles(new File[]{texturePlane.getFile()}, texturePlane.isEnabled(), 0);
                this.setTexture(texture, this.frontBackRectangle, 0, "_FRONT", 2);
                continue;
            }
            if (texturePlane.getTag().equals("_LEFT")) {
                this.textureFiles.setFiles(new File[]{texturePlane.getFile()}, texturePlane.isEnabled(), 1);
                this.setTexture(texture, this.leftRightRectangle, 2, "_LEFT", 2);
                continue;
            }
            if (texturePlane.getTag().equals("_TOP")) {
                this.textureFiles.setFiles(new File[]{texturePlane.getFile()}, texturePlane.isEnabled(), 2);
                this.setTexture(texture, this.topBottomRectangle, 1, "_TOP", 1);
                continue;
            }
            if (texturePlane.getTag().equals("_BACK")) {
                this.textureFiles.setFiles(new File[]{texturePlane.getFile()}, texturePlane.isEnabled(), 3);
                this.setTexture(texture, this.frontBackRectangle, 3, "_BACK", 1);
                continue;
            }
            if (texturePlane.getTag().equals("_RIGHT")) {
                this.textureFiles.setFiles(new File[]{texturePlane.getFile()}, texturePlane.isEnabled(), 4);
                this.setTexture(texture, this.leftRightRectangle, 5, "_RIGHT", 1);
                continue;
            }
            if (!texturePlane.getTag().equals("_BOTTOM")) continue;
            this.textureFiles.setFiles(new File[]{texturePlane.getFile()}, texturePlane.isEnabled(), 5);
            this.setTexture(texture, this.topBottomRectangle, 4, "_BOTTOM", 2);
        }
        this.enableTextures();
    }

    @Override
    public void save() {
        E3DFileDialog dialog = new E3DFileDialog(this.shell, "Save Bezier File", 8192, new File[]{this.sceneFile}, new String[]{"XML Files", "OBJ Files", "All Files"}, new String[]{"*.xml;*.XML", "*.obj;*.OBJ", "*.*"});
        File[] files = dialog.open();
        if (files != null) {
            this.sceneFile = files[0];
            try {
                this.saveFile(files[0]);
            }
            catch (Exception exception) {
                MessageBox msgBox = new MessageBox(this.shell, 33);
                msgBox.setText("Save Error");
                msgBox.setMessage(exception.getMessage() == null ? "<unkown>" : exception.getMessage());
                msgBox.open();
                exception.printStackTrace();
            }
        }
    }

    public void saveFile(File file) throws IOException {
        NeedleMeshes needleMeshes = new NeedleMeshes();
        PointMeshes pointMeshes = new PointMeshes();
        Surfaces surfaces = new Surfaces();
        HashMap<Needle, Needle> original2formattedTangents = new HashMap<Needle, Needle>();
        HashMap<Position, Position> original2formattedPositions = new HashMap<Position, Position>();
        Tagger<Object> tagger = new Tagger<Object>();
        for (J3DInstance object : this.getNormal()) {
            this.j3dNeedleMeshToNeedleMesh(object, original2formattedTangents, needleMeshes, tagger);
        }
        for (J3DInstance object : this.getSelected()) {
            this.j3dNeedleMeshToNeedleMesh(object, original2formattedTangents, needleMeshes, tagger);
        }
        for (J3DInstance object : this.getHidden()) {
            this.j3dNeedleMeshToNeedleMesh(object, original2formattedTangents, needleMeshes, tagger);
        }
        for (J3DInstance object : this.getNormal()) {
            this.j3dPointMeshToPointMesh(object, original2formattedPositions, pointMeshes, tagger);
        }
        for (J3DInstance object : this.getSelected()) {
            this.j3dPointMeshToPointMesh(object, original2formattedPositions, pointMeshes, tagger);
        }
        for (J3DInstance object : this.getHidden()) {
            this.j3dPointMeshToPointMesh(object, original2formattedPositions, pointMeshes, tagger);
        }
        TexturePlanes texturePlanes = new TexturePlanes(6);
        texturePlanes.add(new TexturePlane(ArrayUtils.get(this.textureFiles.getLastFiles(0), 0, null), "_FRONT", true));
        texturePlanes.add(new TexturePlane(ArrayUtils.get(this.textureFiles.getLastFiles(1), 0, null), "_LEFT", true));
        texturePlanes.add(new TexturePlane(ArrayUtils.get(this.textureFiles.getLastFiles(2), 0, null), "_TOP", true));
        texturePlanes.add(new TexturePlane(ArrayUtils.get(this.textureFiles.getLastFiles(3), 0, null), "_BACK", true));
        texturePlanes.add(new TexturePlane(ArrayUtils.get(this.textureFiles.getLastFiles(4), 0, null), "_RIGHT", true));
        texturePlanes.add(new TexturePlane(ArrayUtils.get(this.textureFiles.getLastFiles(5), 0, null), "_BOTTOM", true));
        ((TexturePlane)texturePlanes.get(0)).set(this.frontBackRectangle.getTangent().normal, this.frontBackRectangle.getTangent().point);
        ((TexturePlane)texturePlanes.get(1)).set(this.leftRightRectangle.getTangent().normal, this.leftRightRectangle.getTangent().point);
        ((TexturePlane)texturePlanes.get(2)).set(this.topBottomRectangle.getTangent().normal, this.topBottomRectangle.getTangent().point);
        ((TexturePlane)texturePlanes.get(3)).set(this.frontBackRectangle.getTangent().normal, this.frontBackRectangle.getTangent().point);
        ((TexturePlane)texturePlanes.get(4)).set(this.leftRightRectangle.getTangent().normal, this.leftRightRectangle.getTangent().point);
        ((TexturePlane)texturePlanes.get(5)).set(this.topBottomRectangle.getTangent().normal, this.topBottomRectangle.getTangent().point);
        if (file.getName().endsWith(".dmp")) {
            throw new UnsupportedOperationException("Sorry \"dump-files\" are not supported anymore.");
        }
        if (file.getName().endsWith(".obj")) {
            WavefrontMeshExporter exporter = new WavefrontMeshExporter();
            exporter.export(new XMLMeshObjects(needleMeshes, pointMeshes, surfaces, texturePlanes, tagger), file);
        } else {
            XMLMeshParser parser = new XMLMeshParser();
            parser.setBaseDirectory(file.getParentFile());
            parser.writeXML(new XMLMeshObjects(needleMeshes, pointMeshes, surfaces, texturePlanes, tagger), file);
        }
    }

    private void j3dNeedleMeshToNeedleMesh(J3DInstance object, Map<Needle, Needle> original2formatted, NeedleMeshes meshes, Tagger<Object> tagger) {
        if (object instanceof J3DNeedleMesh) {
            J3DNeedleMesh j3dNeedleMesh = (J3DNeedleMesh)object;
            E3DColor color = new E3DColor((int)(j3dNeedleMesh.getColor().x * 255.0f), (int)(j3dNeedleMesh.getColor().y * 255.0f), (int)(j3dNeedleMesh.getColor().z * 255.0f));
            Matrix2D<J3DNeedle> needles = j3dNeedleMesh.getMasters();
            NeedleMesh mesh = new NeedleMesh(needles.width(), needles.height());
            int y = 0;
            while (y < needles.height()) {
                int x = 0;
                while (x < needles.width()) {
                    J3DNeedle needle = needles.get(x, y);
                    if (needle != null) {
                        Needle tangent = needle.getTangent();
                        Needle formatted = original2formatted.get(needle.getTangent());
                        if (formatted == null) {
                            formatted = new Needle(new Position(tangent.point.x, -tangent.point.y, -tangent.point.z), new E3DVector(tangent.normal.x, -tangent.normal.y, -tangent.normal.z));
                            original2formatted.put(needle.getTangent(), formatted);
                        }
                        mesh.set(x, y, formatted);
                    }
                    ++x;
                }
                ++y;
            }
            mesh.setColor(color);
            mesh.setRoundness(j3dNeedleMesh.getRoundness());
            mesh.setTexture(j3dNeedleMesh.getIndividualTexture());
            mesh.setMaterial(j3dNeedleMesh.getMaterial());
            meshes.add(mesh);
            tagger.addTags((Object)mesh, this.tagger.getTags(j3dNeedleMesh));
        }
    }

    private void j3dPointMeshToPointMesh(J3DInstance object, Map<Position, Position> original2formatted, PointMeshes meshes, Tagger<Object> tagger) {
        if (object instanceof J3DPointMesh) {
            J3DPointMesh j3dPointMesh = (J3DPointMesh)object;
            E3DColor color = new E3DColor((int)(j3dPointMesh.getColor().x * 255.0f), (int)(j3dPointMesh.getColor().y * 255.0f), (int)(j3dPointMesh.getColor().z * 255.0f));
            Matrix2D<J3DPoint> points = j3dPointMesh.getMasters();
            PointMesh mesh = new PointMesh(points.width(), points.height());
            int y = 0;
            while (y < points.height()) {
                int x = 0;
                while (x < points.width()) {
                    J3DPoint point = points.get(x, y);
                    if (point != null) {
                        Position position = point.getPosition();
                        Position formatted = original2formatted.get(point.getPosition());
                        if (formatted == null) {
                            formatted = new Position(position.x, -position.y, -position.z);
                            original2formatted.put(point.getPosition(), formatted);
                        }
                        mesh.set(x, y, formatted);
                    }
                    ++x;
                }
                ++y;
            }
            mesh.setColor(color);
            mesh.setRoundness(j3dPointMesh.getRoundness());
            mesh.setTexture(j3dPointMesh.getIndividualTexture());
            mesh.setMaterial(j3dPointMesh.getMaterial());
            meshes.add(mesh);
            tagger.addTags((Object)mesh, this.tagger.getTags(j3dPointMesh));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() {
        if (this.future != null) {
            this.showBusyMessage();
        } else {
            Runnable task = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    J3DEditorGUI.this.coolBar.setBusyFromOtherThread(false);
                    Object object = J3DEditorGUI.this.sync;
                    synchronized (object) {
                        J3DEditorGUI.this.future = null;
                    }
                }
            };
            this.coolBar.setBusy(true);
            Object object = this.sync;
            synchronized (object) {
                this.future = this.executorService.submit(task);
            }
        }
    }

    @Override
    public void help() {
        new E3DHelp(this.display, NAME, HELP_URI, this);
    }

    @Override
    public void about() {
        this.about(NAME, "V3.5");
    }

    @Override
    public void delete() {
        this.removeSelectedObjects();
    }

    @Override
    public void copy() {
        NeedleMeshes needleMeshes = this.copied.getNeedleMeshes();
        PointMeshes pointMeshes = this.copied.getPointMeshes();
        TexturePlanes texturePlanes = this.copied.getTexturePlanes();
        Tagger<Object> tagger = this.copied.getTagger();
        needleMeshes.clear();
        pointMeshes.clear();
        texturePlanes.clear();
        tagger.clear();
        HashMap<J3DNeedle, Needle> needle2tangent = new HashMap<J3DNeedle, Needle>();
        for (J3DInstance sel : this.getSelected()) {
            if (!(sel instanceof J3DNeedle)) continue;
            J3DNeedle j3dNeedle = (J3DNeedle)sel;
            Needle tangent = j3dNeedle.getTangent().clone();
            needle2tangent.put(j3dNeedle, tangent);
        }
        for (J3DInstance sel : this.getSelected()) {
            if (!(sel instanceof J3DNeedleMesh)) continue;
            J3DNeedleMesh j3dMesh = (J3DNeedleMesh)sel;
            Matrix2D<J3DNeedle> masters = j3dMesh.getMasters();
            NeedleMesh mesh = new NeedleMesh(masters.width(), masters.height());
            mesh.setColor(new Color((int)(j3dMesh.getColor().x * 255.0f), (int)(j3dMesh.getColor().y * 255.0f), (int)(j3dMesh.getColor().z * 255.0f)));
            if (j3dMesh.getMaterial() != null) {
                mesh.setMaterial(j3dMesh.getMaterial().clone());
            }
            mesh.setTexture(j3dMesh.getIndividualTexture());
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    J3DNeedle needle = masters.get(x, y);
                    mesh.set(x, y, (Needle)needle2tangent.get(needle));
                    ++x;
                }
                ++y;
            }
            needleMeshes.add(mesh);
            tagger.addTags((Object)mesh, this.tagger.getTags(sel));
        }
        HashMap<J3DPoint, Position> point2position = new HashMap<J3DPoint, Position>();
        for (J3DInstance sel : this.getSelected()) {
            if (!(sel instanceof J3DPoint)) continue;
            J3DPoint j3dPoint = (J3DPoint)sel;
            Position position = j3dPoint.getPosition().clone();
            point2position.put(j3dPoint, position);
        }
        for (J3DInstance sel : this.getSelected()) {
            if (!(sel instanceof J3DPointMesh)) continue;
            J3DPointMesh j3dMesh = (J3DPointMesh)sel;
            Matrix2D<J3DPoint> masters = j3dMesh.getMasters();
            PointMesh mesh = new PointMesh(masters.width(), masters.height());
            mesh.setColor(new Color((int)(j3dMesh.getColor().x * 255.0f), (int)(j3dMesh.getColor().y * 255.0f), (int)(j3dMesh.getColor().z * 255.0f)));
            if (j3dMesh.getMaterial() != null) {
                mesh.setMaterial(j3dMesh.getMaterial().clone());
            }
            mesh.setTexture(j3dMesh.getIndividualTexture());
            int y = 0;
            while (y < mesh.height()) {
                int x = 0;
                while (x < mesh.width()) {
                    J3DPoint point = masters.get(x, y);
                    mesh.set(x, y, (Position)point2position.get(point));
                    ++x;
                }
                ++y;
            }
            pointMeshes.add(mesh);
            tagger.addTags((Object)mesh, this.tagger.getTags(sel));
        }
    }

    @Override
    public void cut() {
        this.copy();
        this.removeSelectedObjects();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paste() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                this.clearSelection();
                NeedleMeshes needleMeshes = this.copied.getNeedleMeshes();
                PointMeshes pointMeshes = this.copied.getPointMeshes();
                Tagger<Object> tagger = this.copied.getTagger();
                HashMap<Needle, J3DNeedle> tangent2needle = new HashMap<Needle, J3DNeedle>();
                for (NeedleMesh mesh : needleMeshes) {
                    int y = 0;
                    while (y < mesh.height()) {
                        int x = 0;
                        while (x < mesh.width()) {
                            Needle tangent = (Needle)mesh.get(x, y);
                            J3DNeedle needle = (J3DNeedle)tangent2needle.get(tangent);
                            if (needle == null) {
                                Needle movedTangent = tangent.clone();
                                movedTangent.point.x += 0.1;
                                movedTangent.point.y += 0.1;
                                movedTangent.point.z += 0.1;
                                Set<String> tags = tagger.getTags(tangent);
                                needle = this.createNeedle(movedTangent, tags, true);
                                tangent2needle.put(tangent, needle);
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
                for (NeedleMesh mesh : needleMeshes) {
                    Color3f color = new Color3f((float)mesh.getColor().getRed() / 255.0f, (float)mesh.getColor().getGreen() / 255.0f, (float)mesh.getColor().getBlue() / 255.0f);
                    Matrix2D<J3DNeedle> needles = new Matrix2D<J3DNeedle>(mesh.width(), mesh.height(), ArrayFactory.J3DNEEDLE, null);
                    int y = 0;
                    while (y < mesh.height()) {
                        int x = 0;
                        while (x < mesh.width()) {
                            needles.set(x, y, (J3DNeedle)tangent2needle.get(mesh.get(x, y)));
                            ++x;
                        }
                        ++y;
                    }
                    Set<String> tags = tagger.getTags(mesh);
                    this.createNeedleMesh(needles, color, mesh.getMaterial(), mesh.getTexture(), mesh.getRoundness(), tags, true);
                }
                HashMap<Position, J3DPoint> position2point = new HashMap<Position, J3DPoint>();
                for (PointMesh mesh : pointMeshes) {
                    int y = 0;
                    while (y < mesh.height()) {
                        int x = 0;
                        while (x < mesh.width()) {
                            Position position = (Position)mesh.get(x, y);
                            J3DPoint point = (J3DPoint)position2point.get(position);
                            if (point == null && position != null) {
                                Position movedVector = position.clone();
                                movedVector.x += 0.1;
                                movedVector.y += 0.1;
                                movedVector.z += 0.1;
                                Set<String> tags = tagger.getTags(position);
                                point = this.createPoint(movedVector, tags, true);
                                position2point.put(position, point);
                            }
                            ++x;
                        }
                        ++y;
                    }
                }
                for (PointMesh mesh : pointMeshes) {
                    Color3f color = new Color3f((float)mesh.getColor().getRed() / 255.0f, (float)mesh.getColor().getGreen() / 255.0f, (float)mesh.getColor().getBlue() / 255.0f);
                    Matrix2D<J3DPoint> points = new Matrix2D<J3DPoint>(mesh.width(), mesh.height(), ArrayFactory.J3DPOINT, null);
                    int y = 0;
                    while (y < mesh.height()) {
                        int x = 0;
                        while (x < mesh.width()) {
                            points.set(x, y, (J3DPoint)position2point.get(mesh.get(x, y)));
                            ++x;
                        }
                        ++y;
                    }
                    Set<String> tags = tagger.getTags(mesh);
                    this.createPointMesh(points, color, mesh.getMaterial(), mesh.getTexture(), mesh.getRoundness(), tags, true);
                }
                this.updateTagLists();
            }
            finally {
                this.history.next();
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHidden() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                for (J3DInstance obj : new Vector<J3DInstance>(this.getHidden())) {
                    this.canvas.getScene().addObject(obj);
                }
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    public void hide(J3DInstance object) {
        if (object.isSelected()) {
            object.setSelected(false);
        }
        this.canvas.getHidden().addObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideSelected() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                for (J3DInstance obj : new Vector<J3DInstance>(this.getSelected())) {
                    if (obj instanceof J3DMasterObject) {
                        if (!this.isAllDependentObjectsSelectedOrHidden((J3DMasterObject)obj)) continue;
                        this.hide(obj);
                        continue;
                    }
                    if (!(obj instanceof J3DSurface)) continue;
                    this.hide(obj);
                }
                this.clearSelection();
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hideNormal() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                for (J3DInstance obj : new Vector<J3DInstance>(this.getNormal())) {
                    if (obj instanceof J3DMasterObject) {
                        if (!this.isAllDependentObjectsNormalOrHidden((J3DMasterObject)obj)) continue;
                        this.hide(obj);
                        continue;
                    }
                    if (!(obj instanceof J3DSurface)) continue;
                    this.hide(obj);
                }
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    private boolean isAllDependentObjectsSelectedOrHidden(J3DMasterObject object) {
        for (J3DInstance j3DInstance : object.getDependencies().getSlaves()) {
            if (this.canvas.getSelection().contains(j3DInstance) || this.canvas.getHidden().contains(j3DInstance)) continue;
            return false;
        }
        return true;
    }

    private boolean isAllDependentObjectsNormalOrHidden(J3DMasterObject object) {
        for (J3DInstance j3DInstance : object.getDependencies().getSlaves()) {
            if (this.canvas.getScene().contains(j3DInstance) || this.canvas.getHidden().contains(j3DInstance)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSelection() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                for (J3DInstance sel : new Vector<J3DInstance>(this.getSelected())) {
                    this.canvas.getScene().addObject(sel);
                    sel.setSelected(false);
                }
                this.canvas.getSelection().getAnchor().setTransform(new Transform3D());
                this.currentScalingFactor = 1.0;
                this.display.syncExec(new Runnable(){

                    @Override
                    public void run() {
                        J3DEditorGUI.this.scalingScale.setValue(0, 100.0);
                    }
                });
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectAll() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                for (J3DInstance object : new Vector<J3DInstance>(this.getNormal())) {
                    this.select(object);
                }
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void select(J3DInstance object) {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                if ((this.selectColumnMode || this.selectRowMode) && object instanceof J3DMasterObject) {
                    J3DMasterObject master = (J3DMasterObject)object;
                    for (J3DSlaveObject slave : master.getDependencies().getSlaves()) {
                        if (this.selectColumnMode) {
                            for (J3DMasterObject j3DMasterObject : slave.getAllInColumnOf(master)) {
                                this.selectThisObject(j3DMasterObject);
                            }
                        }
                        if (!this.selectRowMode) continue;
                        for (J3DMasterObject j3DMasterObject : slave.getAllInRowOf(master)) {
                            this.selectThisObject(j3DMasterObject);
                        }
                    }
                } else if (object instanceof J3DPoint || object instanceof J3DNeedle || object instanceof J3DPointMesh || object instanceof J3DNeedleMesh || object instanceof J3DLayerMesh || object instanceof J3DVolume) {
                    this.selectThisObject(object);
                    if (object instanceof J3DSlaveObject) {
                        Matrix2D<? extends J3DMasterObject> masters = ((J3DSlaveObject)object).getMasters();
                        int y = 0;
                        while (y < masters.height()) {
                            int x = 0;
                            while (x < masters.width()) {
                                this.selectThisObject(masters.get(x, y));
                                ++x;
                            }
                            ++y;
                        }
                    }
                }
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    private void selectThisObject(J3DInstance object) {
        if (object != null && !object.isSelected()) {
            this.canvas.getSelection().addObject(object);
            object.setSelected(true);
            this.history.changed(object, J3DHistory.Part.SELECTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deselect(J3DInstance object) {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                this.canvas.getScene().addObject(object);
                object.setSelected(false);
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSelectedObjects() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                HashSet<J3DInstance> all = new HashSet<J3DInstance>(this.getSelected());
                HashSet<J3DInstance> reduced = new HashSet<J3DInstance>(all);
                for (J3DInstance object : all) {
                    if (!(object instanceof J3DSlaveObject)) continue;
                    Matrix2D<? extends J3DMasterObject> masters = ((J3DSlaveObject)object).getMasters();
                    int j = 0;
                    while (j < masters.height()) {
                        int i = 0;
                        while (i < masters.width()) {
                            reduced.remove(masters.get(i, j));
                            ++i;
                        }
                        ++j;
                    }
                }
                for (J3DInstance object : reduced) {
                    if (object instanceof J3DNeedle) {
                        this.removeNeedle((J3DNeedle)object);
                        continue;
                    }
                    if (object instanceof J3DPoint) {
                        this.removePoint((J3DPoint)object);
                        continue;
                    }
                    if (object instanceof J3DNeedleMesh) {
                        this.removeNeedleMesh((J3DNeedleMesh)object);
                        continue;
                    }
                    if (object instanceof J3DPointMesh) {
                        this.removePointMesh((J3DPointMesh)object);
                        continue;
                    }
                    if (object instanceof J3DLayerMesh) {
                        this.removeObject(object);
                        continue;
                    }
                    if (!(object instanceof J3DVolume)) continue;
                    this.removeObject(object);
                }
            }
            finally {
                this.history.next();
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scaleSelected(double factor) {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                if (factor != 0.0) {
                    HashSet<J3DSlaveObject> slaves = new HashSet<J3DSlaveObject>();
                    for (J3DInstance object : this.getSelected().isEmpty() ? this.getNormal() : this.getSelected()) {
                        if (!(object instanceof J3DMasterObject)) continue;
                        J3DMasterObject master = (J3DMasterObject)object;
                        master.scale(factor);
                        slaves.addAll(master.getDependencies().getSlaves());
                    }
                    for (J3DSlaveObject slave : slaves) {
                        slave.reshape();
                    }
                }
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transformSelected(J3DMasterObject.Transformation transformation) {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                HashSet<J3DSlaveObject> slaves = new HashSet<J3DSlaveObject>();
                for (J3DInstance object : this.getSelected().isEmpty() ? this.getNormal() : this.getSelected()) {
                    if (!(object instanceof J3DMasterObject)) continue;
                    J3DMasterObject master = (J3DMasterObject)object;
                    master.transform(transformation);
                    slaves.addAll(master.getDependencies().getSlaves());
                    this.history.changed(master, J3DHistory.Part.TRANFORMATION);
                }
                for (J3DSlaveObject slave : slaves) {
                    slave.reshape();
                    this.history.changed(slave, J3DHistory.Part.SHAPE);
                }
            }
            finally {
                this.history.next();
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void orientateSelected(J3DOrientedObject.Orientation orientation) {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                for (J3DInstance object : this.getSelected().isEmpty() ? this.getNormal() : this.getSelected()) {
                    if (!(object instanceof J3DOrientedObject)) continue;
                    J3DOrientedObject orientedObject = (J3DOrientedObject)object;
                    orientedObject.orientate(orientation);
                    orientedObject.reshape();
                    this.history.changed(orientedObject, J3DHistory.Part.ORIENTATION);
                }
            }
            finally {
                this.history.next();
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void meltSelected() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                double maxDistance = this.meltingRadiusScale.getRadius();
                Collection<J3DInstance> selected = this.getSelected().isEmpty() ? this.getNormal() : this.getSelected();
                HashSet<J3DCenteredObject> removed = new HashSet<J3DCenteredObject>();
                for (J3DInstance object : new Vector<J3DInstance>(selected)) {
                    J3DSurface mesh;
                    HashSet<J3DSurface> meshes;
                    if (removed.contains(object)) continue;
                    if (object instanceof J3DNeedle) {
                        J3DNeedle needle = (J3DNeedle)object;
                        Set<J3DNeedle> needles = needle.getNeighbors(maxDistance, J3DNeedle.class);
                        meshes = new HashSet<J3DSurface>();
                        for (J3DNeedle j3DNeedle : needles) {
                            if (j3DNeedle.isSelected() != needle.isSelected()) continue;
                            for (J3DSlaveObject slave : j3DNeedle.getDependencies().getSlaves()) {
                                if (!(slave instanceof J3DNeedleMesh)) continue;
                                mesh = (J3DNeedleMesh)slave;
                                for (Matrix2D.Coordinates coord : new Vector<Matrix2D.Coordinates>(((J3DNeedleMesh)mesh).getMeshCoordinates(j3DNeedle))) {
                                    ((J3DNeedleMesh)mesh).replaceNeedle(coord.x, coord.y, needle);
                                }
                                meshes.add(mesh);
                            }
                            this.removeObject(j3DNeedle);
                            removed.add(j3DNeedle);
                        }
                        needle.getDependencies().addSlaves(meshes);
                        this.history.changed(needle, J3DHistory.Part.DEPENDECIES);
                        for (J3DNeedleMesh j3DNeedleMesh : meshes) {
                            j3DNeedleMesh.reshape();
                            this.history.changed(j3DNeedleMesh, J3DHistory.Part.ORIENTATION);
                        }
                        continue;
                    }
                    if (!(object instanceof J3DPoint)) continue;
                    J3DPoint point = (J3DPoint)object;
                    Set<J3DPoint> points = point.getNeighbors(maxDistance, J3DPoint.class);
                    meshes = new HashSet();
                    for (J3DPoint j3DPoint : points) {
                        if (j3DPoint.isSelected() != point.isSelected()) continue;
                        for (J3DSlaveObject slave : j3DPoint.getDependencies().getSlaves()) {
                            if (!(slave instanceof J3DPointMesh)) continue;
                            mesh = (J3DPointMesh)slave;
                            for (Matrix2D.Coordinates coord : new Vector<Matrix2D.Coordinates>(((J3DPointMesh)mesh).getMeshCoordinates(j3DPoint))) {
                                ((J3DPointMesh)mesh).replacePoint(coord.x, coord.y, point);
                            }
                            meshes.add(mesh);
                        }
                        this.removeObject(j3DPoint);
                        removed.add(j3DPoint);
                    }
                    point.getDependencies().addSlaves(meshes);
                    this.history.changed(point, J3DHistory.Part.DEPENDECIES);
                    for (J3DPointMesh j3DPointMesh : meshes) {
                        j3DPointMesh.reshape();
                        this.history.changed(j3DPointMesh, J3DHistory.Part.ORIENTATION);
                    }
                }
            }
            finally {
                this.history.next();
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertColRowBetweenSelectedMasters() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                boolean done = false;
                List<J3DInstance> selected = this.getSelected();
                if (selected.size() == 2 && (selected.get(0) instanceof J3DNeedle && selected.get(1) instanceof J3DNeedle || selected.get(0) instanceof J3DPoint && selected.get(1) instanceof J3DPoint)) {
                    J3DMasterObject master1 = (J3DMasterObject)selected.get(0);
                    J3DMasterObject master2 = (J3DMasterObject)selected.get(1);
                    for (J3DSlaveObject slave : master1.getDependencies().getSlaves()) {
                        List<Matrix2D.Coordinates> coords1 = slave.getMeshCoordinates(master1);
                        List<Matrix2D.Coordinates> coords2 = slave.getMeshCoordinates(master2);
                        if (coords1 == null || coords2 == null) continue;
                        for (Matrix2D.Coordinates coord1 : coords1) {
                            for (Matrix2D.Coordinates coord2 : coords2) {
                                if (coord1.x == coord2.x && Math.abs(coord1.y - coord2.y) == 1) {
                                    if (slave instanceof J3DNeedleMesh) {
                                        this.insertRow((J3DNeedleMesh)slave, (coord1.y + coord2.y) / 2 + 1);
                                    } else if (slave instanceof J3DPointMesh) {
                                        this.insertRow((J3DPointMesh)slave, (coord1.y + coord2.y) / 2 + 1);
                                    }
                                    this.history.changed(slave, J3DHistory.Part.ORIENTATION);
                                    done = true;
                                    continue;
                                }
                                if (coord1.y != coord2.y || Math.abs(coord1.x - coord2.x) != 1) continue;
                                if (slave instanceof J3DNeedleMesh) {
                                    this.insertCol((J3DNeedleMesh)slave, (coord1.x + coord2.x) / 2 + 1);
                                } else if (slave instanceof J3DPointMesh) {
                                    this.insertCol((J3DPointMesh)slave, (coord1.x + coord2.x) / 2 + 1);
                                }
                                this.history.changed(slave, J3DHistory.Part.ORIENTATION);
                                done = true;
                            }
                        }
                    }
                }
                if (!done) {
                    MessageBox msgBox = new MessageBox(this.shell, 33);
                    msgBox.setText("Cannot remove a row or column");
                    msgBox.setMessage("Select exactly two neighboring points in the same row or column!");
                    msgBox.open();
                }
                this.history.next();
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    private void insertRow(J3DNeedleMesh mesh, int row) {
        Object masters = mesh.getMasters().clone();
        ((Matrix2D)masters).insertRow(row, null);
        int x = 0;
        while (x < ((Matrix2D)masters).width()) {
            J3DNeedle master1 = (J3DNeedle)((Matrix2D)masters).get(x, row - 1);
            J3DNeedle master2 = (J3DNeedle)((Matrix2D)masters).get(x, row + 1);
            if (master1 == null) {
                ((Matrix2D)masters).set(x, row, master2);
            } else if (master2 == null) {
                ((Matrix2D)masters).set(x, row, master1);
            } else if (master1 == master2) {
                ((Matrix2D)masters).set(x, row, master1);
            } else {
                Needle tangent = this.mean(master1.getTangent(), master2.getTangent(), mesh.getRoundness());
                J3DNeedle needle = this.createNeedle(tangent, null, true);
                needle.getDependencies().addSlave(mesh);
                ((Matrix2D)masters).set(x, row, needle);
            }
            ++x;
        }
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DNeedle[])((Matrix2D)masters).toArray());
    }

    private void insertRow(J3DPointMesh mesh, int row) {
        Object masters = mesh.getMasters().clone();
        ((Matrix2D)masters).insertRow(row, null);
        int x = 0;
        while (x < ((Matrix2D)masters).width()) {
            J3DPoint master1 = (J3DPoint)((Matrix2D)masters).get(x, row - 1);
            J3DPoint master2 = (J3DPoint)((Matrix2D)masters).get(x, row + 1);
            if (master1 == null) {
                ((Matrix2D)masters).set(x, row, master2);
            } else if (master2 == null) {
                ((Matrix2D)masters).set(x, row, master1);
            } else if (master1 == master2) {
                ((Matrix2D)masters).set(x, row, master1);
            } else {
                Position position = (Position)master1.getPosition().mean(master2.getPosition());
                J3DPoint point = this.createPoint(position, null, true);
                point.getDependencies().addSlave(mesh);
                ((Matrix2D)masters).set(x, row, point);
            }
            ++x;
        }
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DPoint[])((Matrix2D)masters).toArray());
    }

    private void insertCol(J3DNeedleMesh mesh, int col) {
        Object masters = mesh.getMasters().clone();
        ((Matrix2D)masters).insertCol(col, null);
        int y = 0;
        while (y < ((Matrix2D)masters).height()) {
            J3DNeedle master1 = (J3DNeedle)((Matrix2D)masters).get(col - 1, y);
            J3DNeedle master2 = (J3DNeedle)((Matrix2D)masters).get(col + 1, y);
            if (master1 == null) {
                ((Matrix2D)masters).set(col, y, master2);
            } else if (master2 == null) {
                ((Matrix2D)masters).set(col, y, master1);
            } else if (master1 == master2) {
                ((Matrix2D)masters).set(col, y, master1);
            } else {
                Needle tangent = this.mean(master1.getTangent(), master2.getTangent(), mesh.getRoundness());
                J3DNeedle needle = this.createNeedle(tangent, null, true);
                needle.getDependencies().addSlave(mesh);
                ((Matrix2D)masters).set(col, y, needle);
            }
            ++y;
        }
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DNeedle[])((Matrix2D)masters).toArray());
    }

    private void insertCol(J3DPointMesh mesh, int col) {
        Object masters = mesh.getMasters().clone();
        ((Matrix2D)masters).insertCol(col, null);
        int y = 0;
        while (y < ((Matrix2D)masters).height()) {
            J3DPoint master1 = (J3DPoint)((Matrix2D)masters).get(col - 1, y);
            J3DPoint master2 = (J3DPoint)((Matrix2D)masters).get(col + 1, y);
            if (master1 == null) {
                ((Matrix2D)masters).set(col, y, master2);
            } else if (master2 == null) {
                ((Matrix2D)masters).set(col, y, master1);
            } else if (master1 == master2) {
                ((Matrix2D)masters).set(col, y, master1);
            } else {
                Position position = (Position)master1.getPosition().mean(master2.getPosition());
                J3DPoint point = this.createPoint(position, null, true);
                point.getDependencies().addSlave(mesh);
                ((Matrix2D)masters).set(col, y, point);
            }
            ++y;
        }
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DPoint[])((Matrix2D)masters).toArray());
    }

    private Needle mean(Needle tangent1, Needle tangent2, double roundness) {
        BezierCurve2P2N bezier = new BezierCurve2P2N();
        E3DVector[] points = bezier.intermediates(tangent1.point, tangent1.normal, roundness, tangent2.point, tangent2.normal, roundness);
        Position point = bezier.direct(0.5, tangent1.point, points[0], points[1], tangent2.point);
        E3DVector normal = tangent1.normal.clone();
        normal.along(tangent2.normal);
        normal.norm(tangent2.normal.length());
        normal.add(tangent2.normal);
        return new Needle(point, normal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeColumnOrRowOfSelectedMasters() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                boolean done = false;
                List<J3DInstance> selected = this.getSelected();
                if (selected.size() == 2 && (selected.get(0) instanceof J3DNeedle && selected.get(1) instanceof J3DNeedle || selected.get(0) instanceof J3DPoint && selected.get(1) instanceof J3DPoint)) {
                    J3DMasterObject master1 = (J3DMasterObject)selected.get(0);
                    J3DMasterObject master2 = (J3DMasterObject)selected.get(1);
                    for (J3DSlaveObject slave : master1.getDependencies().getSlaves()) {
                        List<Matrix2D.Coordinates> coords1 = slave.getMeshCoordinates(master1);
                        List<Matrix2D.Coordinates> coords2 = slave.getMeshCoordinates(master2);
                        if (coords1 == null || coords2 == null) continue;
                        for (Matrix2D.Coordinates coord1 : coords1) {
                            for (Matrix2D.Coordinates coord2 : coords2) {
                                if (coord1.x != coord2.x && coord1.y == coord2.y) {
                                    if (slave instanceof J3DNeedleMesh) {
                                        this.removeRow((J3DNeedleMesh)slave, coord1.y);
                                    } else if (slave instanceof J3DPointMesh) {
                                        this.removeRow((J3DPointMesh)slave, coord1.y);
                                    }
                                    this.history.changed(slave, J3DHistory.Part.ORIENTATION);
                                    done = true;
                                    continue;
                                }
                                if (coord1.y == coord2.y || coord1.x != coord2.x) continue;
                                if (slave instanceof J3DNeedleMesh) {
                                    this.removeCol((J3DNeedleMesh)slave, coord1.x);
                                } else if (slave instanceof J3DPointMesh) {
                                    this.removeCol((J3DPointMesh)slave, coord1.x);
                                }
                                this.history.changed(slave, J3DHistory.Part.ORIENTATION);
                                done = true;
                            }
                        }
                    }
                }
                if (!done) {
                    MessageBox msgBox = new MessageBox(this.shell, 33);
                    msgBox.setText("Cannot remove a row or column");
                    msgBox.setMessage("Select exactly two neighboring points in the same row or column!");
                    msgBox.open();
                }
                this.history.next();
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    private void removeRow(J3DNeedleMesh mesh, int row) {
        Object masters = mesh.getMasters().clone();
        int x = 0;
        while (x < ((Matrix2D)masters).width()) {
            J3DNeedle needle = (J3DNeedle)((Matrix2D)masters).get(x, row);
            if (needle != null) {
                needle.getDependencies().removeSlave(mesh);
                if (needle.getDependencies().getSlaves().isEmpty()) {
                    this.removeNeedle(needle);
                } else {
                    this.history.changed(needle, J3DHistory.Part.DEPENDECIES);
                }
            }
            ++x;
        }
        ((Matrix2D)masters).removeRow(row);
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DNeedle[])((Matrix2D)masters).toArray());
    }

    private void removeRow(J3DPointMesh mesh, int row) {
        Object masters = mesh.getMasters().clone();
        int x = 0;
        while (x < ((Matrix2D)masters).width()) {
            J3DPoint point = (J3DPoint)((Matrix2D)masters).get(x, row);
            if (point != null) {
                point.getDependencies().removeSlave(mesh);
                if (point.getDependencies().getSlaves().isEmpty()) {
                    this.removePoint(point);
                } else {
                    this.history.changed(point, J3DHistory.Part.DEPENDECIES);
                }
            }
            ++x;
        }
        ((Matrix2D)masters).removeRow(row);
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DPoint[])((Matrix2D)masters).toArray());
    }

    private void removeCol(J3DNeedleMesh mesh, int col) {
        Object masters = mesh.getMasters().clone();
        int y = 0;
        while (y < ((Matrix2D)masters).height()) {
            J3DNeedle needle = (J3DNeedle)((Matrix2D)masters).get(col, y);
            if (needle != null) {
                needle.getDependencies().removeSlave(mesh);
                if (needle.getDependencies().getSlaves().isEmpty()) {
                    this.removeNeedle(needle);
                } else {
                    this.history.changed(needle, J3DHistory.Part.DEPENDECIES);
                }
            }
            ++y;
        }
        ((Matrix2D)masters).removeCol(col);
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DNeedle[])((Matrix2D)masters).toArray());
    }

    private void removeCol(J3DPointMesh mesh, int col) {
        Object masters = mesh.getMasters().clone();
        int y = 0;
        while (y < ((Matrix2D)masters).height()) {
            J3DPoint point = (J3DPoint)((Matrix2D)masters).get(col, y);
            if (point != null) {
                point.getDependencies().removeSlave(mesh);
                if (point.getDependencies().getSlaves().isEmpty()) {
                    this.removePoint(point);
                } else {
                    this.history.changed(point, J3DHistory.Part.DEPENDECIES);
                }
            }
            ++y;
        }
        ((Matrix2D)masters).removeCol(col);
        mesh.restore(((Matrix2D)masters).width(), ((Matrix2D)masters).height(), (J3DPoint[])((Matrix2D)masters).toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pipette(J3DInstance object, PickIntersection intersection) {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            block10: {
                J3DCanvas.Lock lock = this.canvas.lock();
                try {
                    try {
                        Texture2D texture;
                        TexCoord3f coordinates = intersection.getPointTextureCoordinate(0);
                        if (coordinates != null && object instanceof J3DSurface && (texture = ((J3DSurface)object).getTexture(0)) != null) {
                            ImageComponent2D imageComp = (ImageComponent2D)texture.getImage(0);
                            BufferedImage image = imageComp.getImage();
                            int x = (int)((double)(coordinates.x * (float)image.getWidth()) + 0.5);
                            int y = (int)((double)(coordinates.y * (float)image.getHeight()) + 0.5);
                            if (x >= 0 && x < image.getWidth() && y >= 0 && y <= image.getHeight()) {
                                int color = image.getRGB(x, y);
                                this.colorScales.setColor(E3DColor.red(color), E3DColor.green(color), E3DColor.blue(color));
                                this.colorScales.setAlpha(E3DColor.alpha(color));
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        this.canvas.unlock(lock);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.canvas.unlock(lock);
                    throw throwable;
                }
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintOn(J3DInstance object, PickIntersection intersection) {
        Set<J3DInstance> set = this.paintedObjects;
        synchronized (set) {
            block12: {
                J3DCanvas.Lock lock = this.canvas.lock();
                try {
                    try {
                        TexCoord3f coordinates = intersection.getPointTextureCoordinate(0);
                        if (coordinates != null && object instanceof J3DSurface) {
                            Texture2D texture = ((J3DSurface)object).getTexture(0);
                            if (texture != null) {
                                if (this.lastPaintedObject != object) {
                                    this.lastPaintCoordinates = coordinates;
                                }
                                new J3DTexturePainter(texture, new TexCoord3f[]{this.lastPaintCoordinates, coordinates}, this.colorScales.getColor(), this.opacityScale.getOpacity(), this.brushGroup.getMask());
                                this.paintedObjects.add(object);
                            }
                            this.lastPaintedObject = object;
                            this.lastPaintCoordinates = coordinates;
                        } else {
                            this.lastPaintedObject = null;
                            this.lastPaintCoordinates = null;
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        this.canvas.unlock(lock);
                        break block12;
                    }
                }
                catch (Throwable throwable) {
                    this.canvas.unlock(lock);
                    throw throwable;
                }
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                this.history.undo();
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() {
        J3DCanvas j3DCanvas = this.canvas;
        synchronized (j3DCanvas) {
            J3DCanvas.Lock lock = this.canvas.lock();
            try {
                this.history.redo();
            }
            finally {
                this.canvas.unlock(lock);
            }
        }
    }

    public J3DNeedle createNeedle(Needle tangent, Collection<String> tags, boolean select) {
        final J3DDoubleNeedle needle = new J3DDoubleNeedle(tangent, this.needleParameters);
        if (select) {
            ((J3DNeedle)needle).setSelected(select);
        }
        if (tags != null) {
            this.tagger.addTags((J3DInstance)needle, tags);
        }
        if (select) {
            this.canvas.getSelection().addObject(needle);
        } else {
            this.canvas.getScene().addObject(needle);
        }
        this.history.add(needle);
        needle.addEventListener(new J3DEventAdapter(){

            @Override
            public void transformed(J3DInstance object, TransformGroup anchor, int type) {
                HistoryState current = J3DEditorGUI.this.history.getCurrent(object);
                if (current != null && current.getPrevious() != null) {
                    if (type == 0) {
                        double angle = ((NeedleHistoryState)current.getPrevious()).getTangent().normal.angle(needle.getTangent().normal);
                        J3DEditorGUI.this.ruler.setSliderPosition(Double.isNaN(angle) ? 0.0 : angle / Math.PI * 2.0);
                    } else {
                        double offset = ((NeedleHistoryState)current.getPrevious()).getTangent().point.dist(needle.getTangent().point);
                        J3DEditorGUI.this.ruler.setSliderPosition(offset);
                    }
                }
                double radius = J3DEditorGUI.this.interpolationRadiusScale.getRadius();
                if (J3DEditorGUI.this.interpolationObjects == null) {
                    E3DVector pos = needle.getTangent().point;
                    J3DEditorGUI.this.interpolationObjects = J3DEditorGUI.this.canvas.getObjects(new Point3d(pos.x, pos.y, pos.z), radius);
                    for (J3DInstance obj : J3DEditorGUI.this.interpolationObjects) {
                        if (obj == needle || !(obj instanceof J3DNeedle)) continue;
                        obj.reshape();
                    }
                }
                needle.interpolate(radius, J3DEditorGUI.this.needleInterpolationFunctionGetter.get(), J3DEditorGUI.this.interpolationObjects, J3DEditorGUI.this.history);
            }

            @Override
            public void transformationFinished(J3DInstance object, TransformGroup anchor, int type) {
                J3DEditorGUI.this.ruler.resetSliderPosition();
                J3DEditorGUI.this.interpolationObjects = null;
            }
        });
        return needle;
    }

    public J3DNeedleMesh createNeedleMesh(Matrix2D<J3DNeedle> needles, Color3f color, E3DMaterial material, E3DTextureFile textureFile, double roundness, Collection<String> tags, boolean select) {
        J3DNeedleMesh meshShape = new J3DNeedleMesh(needles, color, material, textureFile, roundness, this.needleMeshParameters);
        if (select) {
            meshShape.setSelected(select);
        }
        int y = 0;
        while (y < needles.height()) {
            int x = 0;
            while (x < needles.width()) {
                J3DNeedle needle = needles.get(x, y);
                if (needle != null) {
                    needle.getDependencies().addSlave(meshShape);
                    this.history.changed(needle, J3DHistory.Part.DEPENDECIES);
                }
                ++x;
            }
            ++y;
        }
        if (tags != null) {
            this.tagger.addTags((J3DInstance)meshShape, tags);
        }
        if (this.tagger.getTags(meshShape).contains("_FRONT")) {
            meshShape.setTexture(this.textures[0], 1);
        }
        if (this.tagger.getTags(meshShape).contains("_TOP")) {
            meshShape.setTexture(this.textures[1], 2);
        }
        if (this.tagger.getTags(meshShape).contains("_LEFT")) {
            meshShape.setTexture(this.textures[2], 3);
        }
        if (this.tagger.getTags(meshShape).contains("_BACK")) {
            meshShape.setTexture(this.textures[3], 1);
        }
        if (this.tagger.getTags(meshShape).contains("_BOTTOM")) {
            meshShape.setTexture(this.textures[4], 2);
        }
        if (this.tagger.getTags(meshShape).contains("_RIGHT")) {
            meshShape.setTexture(this.textures[5], 3);
        }
        try {
            Texture2D texture = textureFile == null ? null : J3DTextureUtils.createTexture2D(textureFile, true, false, false, true);
            meshShape.setTexture(texture, 0);
        }
        catch (IOException exception) {
            this.showGeneralError(exception);
        }
        meshShape.compile();
        if (select) {
            this.canvas.getSelection().addObject(meshShape);
        } else {
            this.canvas.getScene().addObject(meshShape);
        }
        this.history.add(meshShape);
        return meshShape;
    }

    public J3DPoint createPoint(Position position, Collection<String> tags, boolean select) {
        final J3DPoint point = new J3DPoint(position, this.pointParameters);
        if (select) {
            point.setSelected(select);
        }
        if (tags != null) {
            this.tagger.addTags((J3DInstance)point, tags);
        }
        if (select) {
            this.canvas.getSelection().addObject(point);
        } else {
            this.canvas.getScene().addObject(point);
        }
        this.history.add(point);
        point.addEventListener(new J3DEventAdapter(){

            @Override
            public void transformed(J3DInstance object, TransformGroup anchor, int type) {
                HistoryState current = J3DEditorGUI.this.history.getCurrent(object);
                if (current != null && current.getPrevious() != null) {
                    double offset = ((PointHistoryState)current.getPrevious()).getPosition().dist(point.getPosition());
                    J3DEditorGUI.this.ruler.setSliderPosition(offset);
                }
                if (type == 1 || type == 2) {
                    double radius = J3DEditorGUI.this.interpolationRadiusScale.getRadius();
                    if (J3DEditorGUI.this.interpolationObjects == null) {
                        Position pos = point.getPosition();
                        J3DEditorGUI.this.interpolationObjects = J3DEditorGUI.this.canvas.getObjects(new Point3d(pos.x, pos.y, pos.z), radius);
                        for (J3DInstance obj : J3DEditorGUI.this.interpolationObjects) {
                            if (obj == point || !(obj instanceof J3DPoint)) continue;
                            obj.reshape();
                        }
                    }
                    point.interpolate(radius, J3DEditorGUI.this.pointInterpolationFunctionGetter.get(), J3DEditorGUI.this.interpolationObjects, J3DEditorGUI.this.history);
                }
            }

            @Override
            public void transformationFinished(J3DInstance object, TransformGroup anchor, int type) {
                J3DEditorGUI.this.ruler.resetSliderPosition();
                J3DEditorGUI.this.interpolationObjects = null;
            }
        });
        return point;
    }

    public J3DPointMesh createPointMesh(Matrix2D<J3DPoint> points, Color3f color, E3DMaterial material, E3DTextureFile textureFile, double roundness, Collection<String> tags, boolean select) {
        J3DPointMesh meshShape = new J3DPointMesh(points, color, material, textureFile, roundness, this.pointMeshParameters);
        if (select) {
            meshShape.setSelected(select);
        }
        int y = 0;
        while (y < points.height()) {
            int x = 0;
            while (x < points.width()) {
                J3DPoint point = points.get(x, y);
                if (point != null) {
                    point.getDependencies().addSlave(meshShape);
                    this.history.changed(point, J3DHistory.Part.DEPENDECIES);
                }
                ++x;
            }
            ++y;
        }
        if (tags != null) {
            this.tagger.addTags((J3DInstance)meshShape, tags);
        }
        if (this.tagger.getTags(meshShape).contains("_FRONT")) {
            meshShape.setTexture(this.textures[0], 1);
        }
        if (this.tagger.getTags(meshShape).contains("_TOP")) {
            meshShape.setTexture(this.textures[1], 2);
        }
        if (this.tagger.getTags(meshShape).contains("_LEFT")) {
            meshShape.setTexture(this.textures[2], 3);
        }
        if (this.tagger.getTags(meshShape).contains("_BACK")) {
            meshShape.setTexture(this.textures[3], 1);
        }
        if (this.tagger.getTags(meshShape).contains("_BOTTOM")) {
            meshShape.setTexture(this.textures[4], 2);
        }
        if (this.tagger.getTags(meshShape).contains("_RIGHT")) {
            meshShape.setTexture(this.textures[5], 3);
        }
        try {
            Texture2D texture = textureFile == null ? null : J3DTextureUtils.createTexture2D(textureFile, true, false, false, true);
            meshShape.setTexture(texture, 0);
        }
        catch (IOException exception) {
            this.showGeneralError(exception);
        }
        meshShape.compile();
        if (select) {
            this.canvas.getSelection().addObject(meshShape);
        } else {
            this.canvas.getScene().addObject(meshShape);
        }
        this.history.add(meshShape);
        return meshShape;
    }

    protected void removeObject(J3DInstance object) {
        if (object.isSelected()) {
            this.deselect(object);
        }
        if (this.canvas.getSelection().contains(object)) {
            this.canvas.getSelection().removeObject(object);
        } else if (this.canvas.getHidden().contains(object)) {
            this.canvas.getHidden().removeObject(object);
        } else if (this.canvas.getScene().contains(object)) {
            this.canvas.getScene().removeObject(object);
        }
        object.dispose();
        this.tagger.removeObject(object);
    }

    protected void removeNeedle(J3DNeedle needle) {
        Set<J3DSlaveObject> slaves = needle.getDependencies().getSlaves();
        for (J3DSlaveObject slave : new Vector<J3DSlaveObject>(slaves)) {
            if (!(slave instanceof J3DNeedleMesh)) continue;
            ((J3DNeedleMesh)slave).removeNeedle(needle);
            ((J3DNeedleMesh)slave).reshape();
        }
        this.removeObject(needle);
    }

    protected void removePoint(J3DPoint point) {
        Set<J3DSlaveObject> slaves = point.getDependencies().getSlaves();
        for (J3DSlaveObject slave : new Vector<J3DSlaveObject>(slaves)) {
            if (!(slave instanceof J3DPointMesh)) continue;
            ((J3DPointMesh)slave).removePoint(point);
            ((J3DPointMesh)slave).reshape();
        }
        this.removeObject(point);
    }

    protected void removeNeedleMesh(J3DNeedleMesh mesh) {
        J3DNeedle needle;
        int x;
        Matrix2D<J3DNeedle> needles = mesh.getMasters();
        int y = 0;
        while (y < needles.height()) {
            x = 0;
            while (x < needles.width()) {
                needle = needles.get(x, y);
                if (needle != null && needle.getDependencies().getSlaves().size() == 1 && needle.getDependencies().getSlaves().contains(mesh)) {
                    this.removeObject(needle);
                    needle.getDependencies().getSlaves().clear();
                }
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < needles.height()) {
            x = 0;
            while (x < needles.width()) {
                needle = needles.get(x, y);
                if (needle != null) {
                    needle.getDependencies().removeSlave(mesh);
                    this.history.changed(needle, J3DHistory.Part.DEPENDECIES);
                }
                ++x;
            }
            ++y;
        }
        this.removeObject(mesh);
    }

    protected void removePointMesh(J3DPointMesh mesh) {
        J3DPoint point;
        int x;
        Matrix2D<J3DPoint> points = mesh.getMasters();
        int y = 0;
        while (y < points.height()) {
            x = 0;
            while (x < points.width()) {
                point = points.get(x, y);
                if (point != null && point.getDependencies().getSlaves().size() == 1 && point.getDependencies().getSlaves().contains(mesh)) {
                    this.removeObject(point);
                    point.getDependencies().getSlaves().clear();
                }
                ++x;
            }
            ++y;
        }
        y = 0;
        while (y < points.height()) {
            x = 0;
            while (x < points.width()) {
                point = points.get(x, y);
                if (point != null) {
                    point.getDependencies().removeSlave(mesh);
                    this.history.changed(point, J3DHistory.Part.DEPENDECIES);
                }
                ++x;
            }
            ++y;
        }
        this.removeObject(mesh);
    }

    protected J3DAmbientLight createAmbientLight() {
        J3DAmbientLight ambientLight = new J3DAmbientLight(new Color3f(0.7f, 0.7f, 0.7f), this.ambientLightParameters);
        return ambientLight;
    }

    protected J3DDirectLight createDirectLight() {
        final J3DDirectLight directLight = new J3DDirectLight(new Color3f(0.7f, 0.7f, 0.7f), new Point3f(0.5f, 0.5f, 0.5f), this.directLightParameters);
        directLight.addEventListener(new J3DEventAdapter(){

            @Override
            public void transformed(J3DInstance object, TransformGroup anchor, int type) {
                J3DEditorGUI.this.display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Point3f position = directLight.getPosition();
                        (this).J3DEditorGUI.this.lightPositionScales.setValue(0, (double)((int)((double)(position.x * 10.0f) + 0.5)) / 10.0);
                        (this).J3DEditorGUI.this.lightPositionScales.setValue(1, (double)((int)((double)(position.y * 10.0f) + 0.5)) / 10.0);
                        (this).J3DEditorGUI.this.lightPositionScales.setValue(2, (double)((int)((double)(position.z * 10.0f) + 0.5)) / 10.0);
                    }
                });
            }
        });
        return directLight;
    }

    protected J3DRuler createRuler(J3DCanvas canvas) throws IOException {
        Needle tangent = new Needle(new Position(0.0, -1.0, 0.5), new E3DVector(0.0, 0.0, -1.0));
        final J3DRuler ruler = new J3DRuler(tangent, this.rulerParametes);
        canvas.addRotationCompensatingAnchor(ruler.getAnchor());
        ruler.setSliderPosition(0.0);
        final J3DSelectionGroup selection = canvas.getSelection();
        selection.addEventListener(new J3DEventAdapter(){

            @Override
            public void transformed(J3DInstance object, TransformGroup anchor, int type) {
                HistoryState current = J3DEditorGUI.this.history.getCurrent(object);
                if (current != null && current.getPrevious() != null && type != 0) {
                    Vector3d translation1 = new Vector3d();
                    Vector3d translation2 = new Vector3d();
                    Transform3D transform = new Transform3D();
                    ((GroupHistoryState)current.getPrevious()).getTransform().get(translation1);
                    selection.getAnchor().getTransform(transform);
                    transform.get(translation2);
                    translation1.sub((Tuple3d)translation2);
                    ruler.setSliderPosition(translation1.length());
                }
            }

            @Override
            public void transformationFinished(J3DInstance object, TransformGroup anchor, int type) {
                ruler.resetSliderPosition();
            }
        });
        return ruler;
    }

    protected J3DEventListener createSceneListener() {
        return new J3DEventAdapter(){

            @Override
            public void transformed(J3DInstance object, TransformGroup anchor, int type) {
                if (anchor == J3DEditorGUI.this.canvas.getScene().getAnchor()) {
                    J3DEditorGUI.this.display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            J3DSceneView sceneView = (this).J3DEditorGUI.this.canvas.getSceneView();
                            (this).J3DEditorGUI.this.viewTranslationScales.setValue(0, (double)((int)(sceneView.getTranslation().x * 10.0 + 0.5)) / 10.0);
                            (this).J3DEditorGUI.this.viewTranslationScales.setValue(1, (double)((int)(sceneView.getTranslation().y * 10.0 + 0.5)) / 10.0);
                            (this).J3DEditorGUI.this.viewTranslationScales.setValue(2, (double)((int)(sceneView.getTranslation().z * 10.0 + 0.5)) / 10.0);
                            (this).J3DEditorGUI.this.viewDirectionScales.setValue(0, (double)((int)(sceneView.getDirection().x * 10.0 + 0.5)) / 10.0);
                            (this).J3DEditorGUI.this.viewDirectionScales.setValue(1, (double)((int)(sceneView.getDirection().y * 10.0 + 0.5)) / 10.0);
                            (this).J3DEditorGUI.this.viewDirectionScales.setValue(2, (double)((int)(sceneView.getDirection().z * 10.0 + 0.5)) / 10.0);
                            (this).J3DEditorGUI.this.viewRotationScales.setValue(0, (double)((int)(sceneView.getAngle() / Math.PI * 1800.0 + 0.5)) / 10.0);
                            (this).J3DEditorGUI.this.zoomScale.setValue(0, (int)((this).J3DEditorGUI.this.canvas.getView().getScreenScale() * 100.0 + 0.5));
                        }
                    });
                }
            }
        };
    }

    protected J3DEventListener createCanvasListener() {
        return new J3DEventListener(){

            @Override
            public void clicked(J3DInstance object, MouseEvent event, PickIntersection intersection) {
                if (event.getButton() == 1 && event.getClickCount() == 1) {
                    if (J3DEditorGUI.this.paintMode) {
                        J3DEditorGUI.this.paintOn(object, intersection);
                    } else if (!J3DEditorGUI.this.selectionAddMode) {
                        J3DEditorGUI.this.clearSelection();
                        J3DEditorGUI.this.select(object);
                        J3DEditorGUI.this.history.next();
                    } else if (object != null) {
                        if (object.isSelected()) {
                            J3DEditorGUI.this.deselect(object);
                            J3DEditorGUI.this.history.next();
                        } else {
                            J3DEditorGUI.this.select(object);
                            J3DEditorGUI.this.history.next();
                        }
                    }
                }
            }

            @Override
            public void movedOver(J3DInstance object, MouseEvent event, PickIntersection intersection) {
                if (event.getButton() == 1 && J3DEditorGUI.this.paintMode && intersection != null) {
                    J3DEditorGUI.this.paintOn(object, intersection);
                }
            }

            @Override
            public void updated(J3DInstance object) {
            }

            @Override
            public void transformed(J3DInstance object, TransformGroup anchor, int type) {
            }

            @Override
            public void transformationFinished(J3DInstance object, TransformGroup anchor, int type) {
            }

            @Override
            public void typed(final J3DInstance object, final java.awt.event.KeyEvent event, final PickIntersection intersection) {
                J3DEditorGUI.this.display.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        if (event.getKeyCode() == 17) {
                            (this).J3DEditorGUI.this.selectionAddMode = true;
                        } else if (event.getKeyCode() == 113) {
                            (this).J3DEditorGUI.this.selectRowMode = true;
                        } else if (event.getKeyCode() == 97) {
                            (this).J3DEditorGUI.this.selectColumnMode = true;
                        } else if (event.getKeyCode() == 32) {
                            J3DCanvas j3DCanvas = (this).J3DEditorGUI.this.canvas;
                            synchronized (j3DCanvas) {
                                (this).J3DEditorGUI.this.paintMode = true;
                                System.out.println("PAINT");
                                (this).J3DEditorGUI.this.canvas.enableMouseBehaviors(false);
                                (this).J3DEditorGUI.this.canvas.setTraceMouseMotions(J3DEditorGUI.this.needToTraceMouseMotions());
                            }
                        } else if (event.getKeyCode() == 44) {
                            J3DEditorGUI.this.pipette(object, intersection);
                        } else if (event.getKeyCode() == 65485 || event.getKeyCode() == 67 && event.isControlDown()) {
                            J3DEditorGUI.this.copy();
                        } else if (event.getKeyCode() == 65489 || event.getKeyCode() == 88 && event.isControlDown()) {
                            J3DEditorGUI.this.cut();
                        } else if (event.getKeyCode() == 65487 || event.getKeyCode() == 86 && event.isControlDown()) {
                            J3DEditorGUI.this.paste();
                        } else if (event.getKeyCode() == 37 && event.isAltDown()) {
                            J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.X_MIRRORING);
                        } else if (event.getKeyCode() == 38 && event.isAltDown()) {
                            J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.Y_MIRRORING);
                        } else if (event.getKeyCode() == 33 && event.isAltDown()) {
                            J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.Z_MIRRORING);
                        } else if (event.getKeyCode() == 37 && event.isControlDown()) {
                            J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.ROTATE_LEFT);
                        } else if (event.getKeyCode() == 39 && event.isControlDown()) {
                            J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.ROTATE_RIGHT);
                        } else if (event.getKeyCode() == 38 && event.isShiftDown()) {
                            J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.VERTICAL_MIRRORING);
                        } else if (event.getKeyCode() == 40 && event.isShiftDown()) {
                            J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.VERTICAL_MIRRORING);
                        } else if (event.getKeyCode() == 37 && event.isShiftDown()) {
                            J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.HORIZONTAL_MIRRORING);
                        } else if (event.getKeyCode() == 39 && event.isShiftDown()) {
                            J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.HORIZONTAL_MIRRORING);
                        } else if (event.getKeyCode() == 127) {
                            J3DEditorGUI.this.delete();
                        } else if (event.getKeyCode() == 155 && event.isControlDown()) {
                            J3DEditorGUI.this.insertColRowBetweenSelectedMasters();
                        } else if (event.getKeyCode() == 127 && event.isControlDown()) {
                            J3DEditorGUI.this.removeColumnOrRowOfSelectedMasters();
                        } else if (event.getKeyCode() == 36) {
                            J3DEditorGUI.this.setViewDirection(ViewDirection.FRONT);
                        } else if (event.getKeyCode() == 35) {
                            J3DEditorGUI.this.setViewDirection(ViewDirection.BACK);
                        } else if (event.getKeyCode() == 38) {
                            J3DEditorGUI.this.setViewDirection(ViewDirection.TOP);
                        } else if (event.getKeyCode() == 40) {
                            J3DEditorGUI.this.setViewDirection(ViewDirection.BOTTOM);
                        } else if (event.getKeyCode() == 37) {
                            J3DEditorGUI.this.setViewDirection(ViewDirection.LEFT);
                        } else if (event.getKeyCode() == 39) {
                            J3DEditorGUI.this.setViewDirection(ViewDirection.RIGHT);
                        } else if (event.getKeyCode() == 72 && event.isControlDown()) {
                            J3DEditorGUI.this.hideSelected();
                        } else if (event.getKeyCode() == 72 && event.isControlDown() && event.isAltDown()) {
                            J3DEditorGUI.this.hideNormal();
                        } else if (event.getKeyCode() == 72 && event.isControlDown() && event.isShiftDown()) {
                            J3DEditorGUI.this.clearHidden();
                        } else if (event.getKeyCode() == 521) {
                            double factor = (this).J3DEditorGUI.this.zoomScale.getValue(0) * 1.5;
                            (this).J3DEditorGUI.this.zoomScale.setValue(0, (int)factor);
                            (this).J3DEditorGUI.this.canvas.getView().setScreenScale(factor / 100.0);
                        } else if (event.getKeyCode() == 521 && event.isControlDown()) {
                            double factor = (this).J3DEditorGUI.this.zoomScale.getValue(0) / 1.5;
                            (this).J3DEditorGUI.this.zoomScale.setValue(0, (int)factor);
                            (this).J3DEditorGUI.this.canvas.getView().setScreenScale(factor / 100.0);
                        }
                    }
                });
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void released(J3DInstance object, java.awt.event.KeyEvent event) {
                if (event.getKeyCode() == 17) {
                    J3DEditorGUI.this.selectionAddMode = false;
                } else if (event.getKeyCode() == 113) {
                    J3DEditorGUI.this.selectRowMode = false;
                } else if (event.getKeyCode() == 97) {
                    J3DEditorGUI.this.selectColumnMode = false;
                } else if (event.getKeyCode() == 32) {
                    J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                    synchronized (j3DCanvas) {
                        J3DEditorGUI.this.paintMode = false;
                        System.out.println("STOP PAINTING");
                        J3DEditorGUI.this.lastPaintedObject = null;
                        J3DEditorGUI.this.lastPaintCoordinates = null;
                        J3DEditorGUI.this.canvas.setTraceMouseMotions(J3DEditorGUI.this.needToTraceMouseMotions());
                        J3DEditorGUI.this.canvas.enableMouseBehaviors(true);
                        for (J3DInstance paintedObject : J3DEditorGUI.this.paintedObjects) {
                            J3DEditorGUI.this.history.changed(paintedObject, J3DHistory.Part.TEXTURE);
                        }
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.paintedObjects.clear();
                    }
                }
            }

            @Override
            public void selected(J3DInstance object) {
            }

            @Override
            public void colored(J3DInstance object) {
            }

            @Override
            public void reshaped(J3DInstance object) {
            }

            @Override
            public void assigned(J3DGroup group) {
            }
        };
    }

    private boolean needToTraceMouseMotions() {
        return this.interpolationRadiusScale.getRadius() > 0.0 || this.paintMode;
    }

    protected void extendEditMenu() {
        new MenuItem(this.menu.editMenu, 2);
        MenuItem meltItem = new MenuItem(this.menu.editMenu, 8);
        meltItem.setText("Unify selected needles/points within the \"melting radius\"\tCtrl + M");
        meltItem.setAccelerator(262221);
        meltItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.meltSelected();
            }
        });
        new MenuItem(this.menu.editMenu, 2);
        MenuItem addColRowItem = new MenuItem(this.menu.editMenu, 8);
        addColRowItem.setText("Insert col/row between 2 selected points/needles\tCtrl + Insert");
        addColRowItem.setAccelerator(17039369);
        addColRowItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.insertColRowBetweenSelectedMasters();
            }
        });
        MenuItem rmColRowItem = new MenuItem(this.menu.editMenu, 8);
        rmColRowItem.setText("Remove col/row of 2 selected points/needles\tCtrl + Delete");
        rmColRowItem.setAccelerator(262271);
        rmColRowItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.removeColumnOrRowOfSelectedMasters();
            }
        });
        new MenuItem(this.menu.editMenu, 2);
        MenuItem transformItem = new MenuItem(this.menu.editMenu, 64);
        transformItem.setText("Transformations");
        Menu transformMenu = new Menu(this.shell, 4);
        transformItem.setMenu(transformMenu);
        MenuItem xMirrorItem = new MenuItem(transformMenu, 8);
        xMirrorItem.setText("X-Mirror\tAlt + LEFT");
        xMirrorItem.setImage(Icons.getSWTImage(this.display, "horizontal_focus.png"));
        xMirrorItem.setAccelerator(0x1010003);
        xMirrorItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.X_MIRRORING);
            }
        });
        MenuItem yMirrorItem = new MenuItem(transformMenu, 8);
        yMirrorItem.setText("Y-Mirror\tAlt + UP");
        yMirrorItem.setImage(Icons.getSWTImage(this.display, "vertical_focus.png"));
        yMirrorItem.setAccelerator(0x1010001);
        yMirrorItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.Y_MIRRORING);
            }
        });
        MenuItem zMirrorItem = new MenuItem(transformMenu, 8);
        zMirrorItem.setText("Z-Mirror\tAlt + PAGE_UP");
        zMirrorItem.setImage(Icons.getSWTImage(this.display, "longitudinal_focus.png"));
        zMirrorItem.setAccelerator(0x1010005);
        zMirrorItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.Z_MIRRORING);
            }
        });
        new MenuItem(transformMenu, 2);
        MenuItem rotateLeftYItem = new MenuItem(transformMenu, 8);
        rotateLeftYItem.setText("Rotate 90deg to the left (around y-axis)");
        rotateLeftYItem.setImage(Icons.getSWTImage(this.display, "etator_focus.png"));
        rotateLeftYItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.ROTATE_LEFT_Y);
            }
        });
        MenuItem rotateRightYItem = new MenuItem(transformMenu, 8);
        rotateRightYItem.setText("Rotate 90deg to the right (around y-axis)");
        rotateRightYItem.setImage(Icons.getSWTImage(this.display, "rotate_focus.png"));
        rotateRightYItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.ROTATE_RIGHT_Y);
            }
        });
        MenuItem rotateLeftZItem = new MenuItem(transformMenu, 8);
        rotateLeftZItem.setText("Rotate 90deg to the left (around z-axis)");
        rotateLeftZItem.setImage(Icons.getSWTImage(this.display, "etator_focus.png"));
        rotateLeftZItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.ROTATE_LEFT_Z);
            }
        });
        MenuItem rotateRightZItem = new MenuItem(transformMenu, 8);
        rotateRightZItem.setText("Rotate 90deg to the right (around z-axis)");
        rotateRightZItem.setImage(Icons.getSWTImage(this.display, "rotate_focus.png"));
        rotateRightZItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.ROTATE_RIGHT_Z);
            }
        });
        MenuItem rotateFrontXItem = new MenuItem(transformMenu, 8);
        rotateFrontXItem.setText("Rotate 90deg to the front (around x-axis)");
        rotateFrontXItem.setImage(Icons.getSWTImage(this.display, "etator_focus.png"));
        rotateFrontXItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.ROTATE_FRONT_X);
            }
        });
        MenuItem rotateBackXItem = new MenuItem(transformMenu, 8);
        rotateBackXItem.setText("Rotate 90deg to the back (around x-axis)");
        rotateBackXItem.setImage(Icons.getSWTImage(this.display, "rotate_focus.png"));
        rotateBackXItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.transformSelected(J3DMasterObject.Transformation.ROTATE_BACK_X);
            }
        });
        new MenuItem(this.menu.editMenu, 2);
        MenuItem orientationItem = new MenuItem(this.menu.editMenu, 64);
        orientationItem.setText("Orientation");
        Menu orientationMenu = new Menu(this.shell, 4);
        orientationItem.setMenu(orientationMenu);
        MenuItem hMirrorItem = new MenuItem(orientationMenu, 8);
        hMirrorItem.setText("Mirror horizontally\tShift + LEFT");
        hMirrorItem.setImage(Icons.getSWTImage(this.display, "horizontal_focus.png"));
        hMirrorItem.setAccelerator(16908291);
        hMirrorItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.HORIZONTAL_MIRRORING);
            }
        });
        MenuItem vMirrorItem = new MenuItem(orientationMenu, 8);
        vMirrorItem.setText("Mirror vertically\tShift + UP");
        vMirrorItem.setImage(Icons.getSWTImage(this.display, "vertical_focus.png"));
        vMirrorItem.setAccelerator(0x1020001);
        vMirrorItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.VERTICAL_MIRRORING);
            }
        });
        new MenuItem(orientationMenu, 2);
        MenuItem rotLeftItem = new MenuItem(orientationMenu, 8);
        rotLeftItem.setText("Rotate 90deg left\tCtrl + LEFT");
        rotLeftItem.setImage(Icons.getSWTImage(this.display, "etator_focus.png"));
        rotLeftItem.setAccelerator(17039363);
        rotLeftItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.ROTATE_LEFT);
            }
        });
        MenuItem rotRightItem = new MenuItem(orientationMenu, 8);
        rotRightItem.setText("Rotate 90deg right\tCtrl + RIGHT");
        rotRightItem.setImage(Icons.getSWTImage(this.display, "rotate_focus.png"));
        rotRightItem.setAccelerator(0x1040004);
        rotRightItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.orientateSelected(J3DOrientedObject.Orientation.ROTATE_RIGHT);
            }
        });
        new MenuItem(this.menu.editMenu, 2);
        MenuItem mergeLoadItem = new MenuItem(this.menu.editMenu, 8);
        mergeLoadItem.setImage(Icons.getSWTImage(this.shell.getDisplay(), "load_focus.png"));
        mergeLoadItem.setText("Merge load\tCtrl + M");
        mergeLoadItem.setAccelerator(262221);
        mergeLoadItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.load(true);
            }
        });
    }

    protected void extendViewMenu() {
        MenuItem zoomIn = new MenuItem(this.menu.viewMenu, 8);
        zoomIn.setImage(Icons.getSWTImage(this.shell.getDisplay(), "zoom_focus.png"));
        zoomIn.setText("Zoom in\t'+'");
        zoomIn.setAccelerator(43);
        zoomIn.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                double factor = J3DEditorGUI.this.zoomScale.getValue(0) * 1.5;
                J3DEditorGUI.this.zoomScale.setValue(0, (int)factor);
                J3DEditorGUI.this.canvas.getView().setScreenScale(factor / 100.0);
            }
        });
        MenuItem zoomOut = new MenuItem(this.menu.viewMenu, 8);
        zoomOut.setImage(Icons.getSWTImage(this.shell.getDisplay(), "zoom_focus.png"));
        zoomOut.setText("Zoom out\tCtrl + '+'");
        zoomOut.setAccelerator(262187);
        zoomOut.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                double factor = J3DEditorGUI.this.zoomScale.getValue(0) / 1.5;
                J3DEditorGUI.this.zoomScale.setValue(0, (int)factor);
                J3DEditorGUI.this.canvas.getView().setScreenScale(factor / 100.0);
            }
        });
        new MenuItem(this.menu.viewMenu, 2);
        MenuItem frontViewItem = new MenuItem(this.menu.viewMenu, 8);
        frontViewItem.setText("Front view\tHOME/POS1");
        frontViewItem.setAccelerator(0x1000007);
        frontViewItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.setViewDirection(ViewDirection.FRONT);
            }
        });
        MenuItem backViewItem = new MenuItem(this.menu.viewMenu, 8);
        backViewItem.setText("Back view\tEND");
        backViewItem.setAccelerator(0x1000008);
        backViewItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.setViewDirection(ViewDirection.BACK);
            }
        });
        MenuItem leftViewItem = new MenuItem(this.menu.viewMenu, 8);
        leftViewItem.setText("Left View\tLEFT");
        leftViewItem.setAccelerator(0x1000003);
        leftViewItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.setViewDirection(ViewDirection.LEFT);
            }
        });
        MenuItem rightViewItem = new MenuItem(this.menu.viewMenu, 8);
        rightViewItem.setText("Right View\tRIGHT");
        rightViewItem.setAccelerator(0x1000004);
        rightViewItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.setViewDirection(ViewDirection.RIGHT);
            }
        });
        MenuItem topViewItem = new MenuItem(this.menu.viewMenu, 8);
        topViewItem.setText("Top View\tUP");
        topViewItem.setAccelerator(0x1000001);
        topViewItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.setViewDirection(ViewDirection.TOP);
            }
        });
        MenuItem bottomViewItem = new MenuItem(this.menu.viewMenu, 8);
        bottomViewItem.setText("Bottom View\tDOWN");
        bottomViewItem.setAccelerator(0x1000002);
        bottomViewItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.setViewDirection(ViewDirection.BOTTOM);
            }
        });
        new MenuItem(this.menu.viewMenu, 2);
        MenuItem hideSelectedItem = new MenuItem(this.menu.viewMenu, 8);
        hideSelectedItem.setImage(Icons.getSWTImage(this.shell.getDisplay(), "hide_focus.png"));
        hideSelectedItem.setText("Hide selected\tCtrl + 'h'");
        hideSelectedItem.setAccelerator(262248);
        hideSelectedItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.hideSelected();
            }
        });
        MenuItem hideNormalItem = new MenuItem(this.menu.viewMenu, 8);
        hideNormalItem.setImage(Icons.getSWTImage(this.shell.getDisplay(), "hide_focus.png"));
        hideNormalItem.setText("Hide not selected\tCtrl + Alt + 'h'");
        hideNormalItem.setAccelerator(327784);
        hideNormalItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.hideNormal();
            }
        });
        MenuItem unhideItem = new MenuItem(this.menu.viewMenu, 8);
        unhideItem.setImage(Icons.getSWTImage(this.shell.getDisplay(), "unhide_focus.png"));
        unhideItem.setText("Unhide all\tCtrl + Shift + 'h'");
        unhideItem.setAccelerator(393320);
        unhideItem.addSelectionListener(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent e) {
                J3DEditorGUI.this.clearHidden();
            }
        });
    }

    protected XYZScaleGroup createViewDirectionScales(Composite parent) {
        J3DSceneView initialSceneView = this.canvas.getSceneView();
        final XYZScaleGroup directionScales = new XYZScaleGroup(parent, "View-Direction", 1.0, initialSceneView.getDirection().x, initialSceneView.getDirection().y, initialSceneView.getDirection().z, -10, -10, -10, 10, 10, 10, 100, false);
        directionScales.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                J3DSceneView sceneView = J3DEditorGUI.this.canvas.getSceneView();
                sceneView.getDirection().setX(directionScales.getX());
                sceneView.getDirection().setY(directionScales.getY());
                sceneView.getDirection().setZ(directionScales.getZ());
                sceneView.setAngle((double)J3DEditorGUI.this.viewRotationScales.getDegrees() / 180.0 * Math.PI);
                J3DEditorGUI.this.canvas.setSceneView(sceneView, false);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return directionScales;
    }

    private void setViewDirection(ViewDirection direction) {
        switch (direction) {
            case FRONT: {
                this.viewDirectionScales.setXYZ(0.0, 0.0, -10.0);
                break;
            }
            case BACK: {
                this.viewDirectionScales.setXYZ(0.0, 0.0, 10.0);
                break;
            }
            case LEFT: {
                this.viewDirectionScales.setXYZ(-10.0, 0.0, 0.0);
                break;
            }
            case RIGHT: {
                this.viewDirectionScales.setXYZ(10.0, 0.0, 0.0);
                break;
            }
            case TOP: {
                this.viewDirectionScales.setXYZ(0.0, -10.0, 0.0);
                break;
            }
            case BOTTOM: {
                this.viewDirectionScales.setXYZ(0.0, 10.0, 0.0);
            }
        }
        J3DSceneView sceneView = this.canvas.getSceneView();
        sceneView.getDirection().setX(this.viewDirectionScales.getX());
        sceneView.getDirection().setY(this.viewDirectionScales.getY());
        sceneView.getDirection().setZ(this.viewDirectionScales.getZ());
        sceneView.setAngle(0.0);
        this.viewRotationScales.setValue(0, 0.0);
        this.canvas.setSceneView(sceneView, true);
    }

    protected RotationScaleGroup createViewRotationScales(Composite parent) {
        J3DSceneView initialSceneView = this.canvas.getSceneView();
        final RotationScaleGroup rotationScales = new RotationScaleGroup(parent, "Rot.", (int)(initialSceneView.getAngle() / Math.PI * 180.0), false, 100, false);
        rotationScales.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                J3DSceneView sceneView = J3DEditorGUI.this.canvas.getSceneView();
                sceneView.getDirection().setX(J3DEditorGUI.this.viewDirectionScales.getX());
                sceneView.getDirection().setY(J3DEditorGUI.this.viewDirectionScales.getY());
                sceneView.getDirection().setZ(J3DEditorGUI.this.viewDirectionScales.getZ());
                sceneView.setAngle((double)rotationScales.getDegrees() / 180.0 * Math.PI);
                J3DEditorGUI.this.canvas.setSceneView(sceneView, false);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return rotationScales;
    }

    protected XYZScaleGroup createViewTranslationScales(Composite parent) {
        J3DSceneView initialSceneView = this.canvas.getSceneView();
        final XYZScaleGroup translationScales = new XYZScaleGroup(parent, "Translation", 10.0, initialSceneView.getTranslation().x, initialSceneView.getTranslation().y, initialSceneView.getTranslation().z, -20, -20, -40, 20, 20, 40, 100, false);
        translationScales.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                J3DSceneView sceneView = J3DEditorGUI.this.canvas.getSceneView();
                sceneView.getTranslation().setX(translationScales.getX());
                sceneView.getTranslation().setY(translationScales.getY());
                sceneView.getTranslation().setZ(translationScales.getZ());
                J3DEditorGUI.this.canvas.setSceneView(sceneView, false);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return translationScales;
    }

    protected XYZScaleGroup createLightPositionScales(Composite parent, final J3DDirectLight light) {
        Point3f lightPosition = light.getPosition();
        final XYZScaleGroup lightPosScales = new XYZScaleGroup(parent, "Leight-Position", 10.0, lightPosition.x, lightPosition.y, lightPosition.z, -10, -10, -10, 10, 10, 10, 100, false);
        lightPosScales.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                light.setPosition(new Point3f((float)lightPosScales.getX(), (float)lightPosScales.getY(), (float)lightPosScales.getZ()));
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return lightPosScales;
    }

    protected XYZScaleGroup createRectanglePositionScales(Composite parent) {
        final XYZScaleGroup rectPosScales = new XYZScaleGroup(parent, "World-Box Side-Positions", 10.0, 0.0, 0.0, 0.0, -10, -10, -10, 10, 10, 10, 100, false);
        rectPosScales.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                if (index == 0) {
                    Needle tangent = J3DEditorGUI.this.leftRightRectangle.getTangent();
                    tangent.point.x = rectPosScales.getX();
                    J3DEditorGUI.this.leftRightRectangle.setTangent(tangent);
                } else if (index == 1) {
                    Needle tangent = J3DEditorGUI.this.topBottomRectangle.getTangent();
                    tangent.point.y = rectPosScales.getY();
                    J3DEditorGUI.this.topBottomRectangle.setTangent(tangent);
                } else {
                    Needle tangent = J3DEditorGUI.this.frontBackRectangle.getTangent();
                    tangent.point.z = rectPosScales.getZ();
                    J3DEditorGUI.this.frontBackRectangle.setTangent(tangent);
                }
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return rectPosScales;
    }

    protected ZoomScaleGroup createZoomScales(Composite parent) {
        final ZoomScaleGroup zoomScale = new ZoomScaleGroup(parent, "Zoom", this.canvas.getView().getScreenScale() * 100.0, false, 100, true);
        zoomScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                J3DEditorGUI.this.canvas.setZoom((double)zoomScale.getZoom() / 100.0);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return zoomScale;
    }

    protected SingleHorizontalScaleGroup createPointAndNeedleSizeScales(Composite parent) {
        final SingleHorizontalScaleGroup focalScale = new SingleHorizontalScaleGroup(parent, "Needle and Point Size", "Set the size of needles and points", "minsize_focus.png", 10.0, 1.0, 0, 50, 100, false);
        focalScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finished(WidgetGroup group, int index, int field) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        float s;
                        ((J3DEditorGUI)J3DEditorGUI.this).pointParameters.scale = s = (float)focalScale.getValue();
                        ((J3DEditorGUI)J3DEditorGUI.this).needleParameters.scale = s;
                        this.recreate(J3DEditorGUI.this.getNormal());
                        this.recreate(J3DEditorGUI.this.getSelected());
                        this.recreate(J3DEditorGUI.this.getHidden());
                    }
                    finally {
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }

            private void recreate(Collection<J3DInstance> objects) {
                for (J3DInstance object : objects) {
                    if (!(object instanceof J3DMasterObject)) continue;
                    object.recreate();
                }
            }
        });
        return focalScale;
    }

    protected SingleVerticalScaleGroup createFocalScales(Composite parent) {
        final SingleVerticalScaleGroup focalScale = new SingleVerticalScaleGroup(parent, "Lense", "Focal distance", "distance_focus.png", 10.0, 0.0, 0, 20, 100, false);
        focalScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                double s = focalScale.getValue();
                if (s <= 0.0) {
                    J3DEditorGUI.this.canvas.setParallelProjection(true);
                    J3DEditorGUI.this.canvas.setViewDistance(10.0);
                } else {
                    J3DEditorGUI.this.canvas.setParallelProjection(false);
                    J3DEditorGUI.this.canvas.setViewDistance(focalScale.getValue());
                }
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return focalScale;
    }

    protected SingleHorizontalScaleGroup createScalingScales(Composite parent) {
        final SingleHorizontalScaleGroup scalingScale = new SingleHorizontalScaleGroup(parent, "Scale Selected Objects", "Scale all selected objects", "scale_focus.png", 1.0, 100.0, 0, 500, 100, false);
        scalingScale.getLabel(0).setImage(Icons.getSWTImage(parent.getDisplay(), "scale_focus.png"));
        scalingScale.getLabel(0).setToolTipText("Scale selected objects");
        final J3DLockListener lockListener = new J3DLockListener(){

            @Override
            public void locked() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlocked() {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        double newScalingFactor = scalingScale.getValue(0) / 100.0;
                        J3DEditorGUI.this.scaleSelected(newScalingFactor / J3DEditorGUI.this.currentScalingFactor);
                        J3DEditorGUI.this.currentScalingFactor = newScalingFactor;
                        J3DEditorGUI.this.canvas.removeLockListener(this);
                    }
                    finally {
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        };
        scalingScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
                if (J3DEditorGUI.this.canvas.isLocked()) {
                    J3DEditorGUI.this.canvas.addLockListener(lockListener);
                } else {
                    lockListener.unlocked();
                }
                J3DEditorGUI.this.history.next();
            }
        });
        return scalingScale;
    }

    protected WidgetGroup createPolygonAndShadingButtons(Composite parent) {
        WidgetGroup widgetGroup = new WidgetGroup(parent, "Polygon and Shading Mode", 7, false, true);
        final ToggleButton points = new ToggleButton(widgetGroup.getGroup(), true, Icons.getSWTImage(parent.getDisplay(), "points.png"), Icons.getSWTImage(parent.getDisplay(), "points_focus.png"), Icons.getSWTImage(parent.getDisplay(), "points_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "points_pressed_focus.png"), "Show point meshes\n(no textures are visible)", this.needleMeshParameters.polygonMode == 0);
        final ToggleButton lines = new ToggleButton(widgetGroup.getGroup(), true, Icons.getSWTImage(parent.getDisplay(), "lines.png"), Icons.getSWTImage(parent.getDisplay(), "lines_focus.png"), Icons.getSWTImage(parent.getDisplay(), "lines_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "lines_pressed_focus.png"), "Show line meshes\n(no textures are visible)", this.needleMeshParameters.polygonMode == 1);
        final ToggleButton filled = new ToggleButton(widgetGroup.getGroup(), true, Icons.getSWTImage(parent.getDisplay(), "filled.png"), Icons.getSWTImage(parent.getDisplay(), "filled_focus.png"), Icons.getSWTImage(parent.getDisplay(), "filled_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "filled_pressed_focus.png"), "Show line meshes\n(no textures are visible)", this.needleMeshParameters.polygonMode == 2 && this.needleMeshParameters.creaseAngle <= 0.0);
        final ToggleButton smooth = new ToggleButton(widgetGroup.getGroup(), true, Icons.getSWTImage(parent.getDisplay(), "filled.png"), Icons.getSWTImage(parent.getDisplay(), "filled_focus.png"), Icons.getSWTImage(parent.getDisplay(), "filled_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "filled_pressed_focus.png"), "Show line meshes\n(no textures are visible)", this.needleMeshParameters.polygonMode == 2 && this.needleMeshParameters.creaseAngle > 0.0);
        ((GridData)SWTUtils.space((Composite)widgetGroup.getGroup()).getLayoutData()).grabExcessHorizontalSpace = true;
        final ToggleButton fastest = new ToggleButton(widgetGroup.getGroup(), true, Icons.getSWTImage(parent.getDisplay(), "fastest.png"), Icons.getSWTImage(parent.getDisplay(), "fastest_focus.png"), Icons.getSWTImage(parent.getDisplay(), "fastest_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "fastest_pressed_focus.png"), "Fastest rendering", this.needleMeshParameters.shadeModel == 0);
        final ToggleButton nicest = new ToggleButton(widgetGroup.getGroup(), true, Icons.getSWTImage(parent.getDisplay(), "nicest.png"), Icons.getSWTImage(parent.getDisplay(), "nicest_focus.png"), Icons.getSWTImage(parent.getDisplay(), "nicest_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "nicest_pressed_focus.png"), "Show line meshes\n(no textures are visible)", this.needleMeshParameters.shadeModel == 1);
        points.getButton().setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, true));
        lines.getButton().setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, true));
        filled.getButton().setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, true));
        fastest.getButton().setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, true));
        nicest.getButton().setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, true));
        MouseAdapter polygonListener = new MouseAdapter(){

            private void recreate(Collection<J3DInstance> objects) {
                for (J3DInstance object : objects) {
                    if (!(object instanceof J3DSurface)) continue;
                    object.recreate();
                }
            }

            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent event) {
                points.set(event.widget == points.getButton());
                lines.set(event.widget == lines.getButton());
                filled.set(event.widget == filled.getButton());
                smooth.set(event.widget == smooth.getButton());
                if (points.isOn()) {
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.polygonMode = 0;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.polygonMode = 0;
                    J3DEditorGUI.this.layerMeshParameters.polygonMode = 0;
                } else if (lines.isOn()) {
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.polygonMode = 1;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.polygonMode = 1;
                    J3DEditorGUI.this.layerMeshParameters.polygonMode = 1;
                } else if (filled.isOn()) {
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.polygonMode = 2;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.polygonMode = 2;
                    J3DEditorGUI.this.layerMeshParameters.polygonMode = 2;
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.creaseAngle = 0.0;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.creaseAngle = 0.0;
                    J3DEditorGUI.this.layerMeshParameters.creaseAngle = 0.0;
                } else if (smooth.isOn()) {
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.polygonMode = 2;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.polygonMode = 2;
                    J3DEditorGUI.this.layerMeshParameters.polygonMode = 2;
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.creaseAngle = 1.0471975511965976;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.creaseAngle = 1.0471975511965976;
                    J3DEditorGUI.this.layerMeshParameters.creaseAngle = 1.0471975511965976;
                }
                this.recreate(J3DEditorGUI.this.getNormal());
                this.recreate(J3DEditorGUI.this.getSelected());
                this.recreate(J3DEditorGUI.this.getHidden());
            }
        };
        points.getButton().addMouseListener(polygonListener);
        lines.getButton().addMouseListener(polygonListener);
        filled.getButton().addMouseListener(polygonListener);
        smooth.getButton().addMouseListener(polygonListener);
        MouseAdapter shadingListener = new MouseAdapter(){

            private void recreate(Collection<J3DInstance> objects) {
                for (J3DInstance object : objects) {
                    if (!(object instanceof J3DSurface)) continue;
                    object.recreate();
                }
            }

            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent event) {
                fastest.set(event.widget == fastest.getButton());
                nicest.set(event.widget == nicest.getButton());
                if (fastest.isOn()) {
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.shadeModel = 0;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.shadeModel = 0;
                    J3DEditorGUI.this.layerMeshParameters.shadeModel = 0;
                } else if (nicest.isOn()) {
                    ((J3DEditorGUI)J3DEditorGUI.this).pointMeshParameters.shadeModel = 1;
                    ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.shadeModel = 1;
                    J3DEditorGUI.this.layerMeshParameters.shadeModel = 1;
                }
                this.recreate(J3DEditorGUI.this.getNormal());
                this.recreate(J3DEditorGUI.this.getSelected());
                this.recreate(J3DEditorGUI.this.getHidden());
            }
        };
        fastest.getButton().addMouseListener(shadingListener);
        nicest.getButton().addMouseListener(shadingListener);
        return widgetGroup;
    }

    protected SingleHorizontalScaleGroup createResolutionScales(Composite parent) {
        final SingleHorizontalScaleGroup scaleGroup = new SingleHorizontalScaleGroup(parent, "Bezier Resolution", "Bezier Resolution", "density_focus.png", 1.0, this.needleMeshParameters.maxResolution, 2, 20, 50, false);
        scaleGroup.addListener(new WidgetGroupEditedListener(){

            private void recreate(Collection<J3DInstance> objects) {
                for (J3DInstance object : objects) {
                    if (!(object instanceof J3DNeedleMesh)) continue;
                    object.recreate();
                }
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
                ((J3DEditorGUI)J3DEditorGUI.this).needleMeshParameters.maxResolution = Math.max(2, (int)scaleGroup.getValue());
                this.recreate(J3DEditorGUI.this.getNormal());
                this.recreate(J3DEditorGUI.this.getSelected());
                this.recreate(J3DEditorGUI.this.getHidden());
            }

            @Override
            public void edited(WidgetGroup group, int index, int field) {
            }
        });
        return scaleGroup;
    }

    protected FileGroup createBoxTextureFileGroup(Composite parent) {
        final FileGroup fileGroup = new FileGroup(parent, "World-Box Texture-Files", new String[]{"Front:", "Left:", "Top:", "Back:", "Right:", "Bottom:"}, new String[6], new File[6][], new String[][]{{"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true, true, true, true, true, true}, new Boolean[]{false, false, false, false, false, false}, new Boolean[]{false, false, false, false, false, false}, 75, 350, false, false);
        fileGroup.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                try {
                    J3DRectangle rectangle;
                    J3DRectangle j3DRectangle = index % 3 == 0 ? J3DEditorGUI.this.frontBackRectangle : (rectangle = index % 3 == 1 ? J3DEditorGUI.this.leftRightRectangle : J3DEditorGUI.this.topBottomRectangle);
                    if (field == 0) {
                        J3DEditorGUI.this.enableTextures();
                    } else if (field == 1) {
                        File file = fileGroup.getFiles(index) == null ? null : fileGroup.getFiles(index)[0];
                        Texture2D texture = J3DTextureUtils.createTexture2D(file, file != null, index == 3 || index == 4, index != 2, true);
                        switch (index) {
                            case 0: {
                                J3DEditorGUI.this.setTexture(texture, rectangle, 0, "_FRONT", 2);
                                break;
                            }
                            case 1: {
                                J3DEditorGUI.this.setTexture(texture, rectangle, 2, "_LEFT", 2);
                                break;
                            }
                            case 2: {
                                J3DEditorGUI.this.setTexture(texture, rectangle, 1, "_TOP", 1);
                                break;
                            }
                            case 3: {
                                J3DEditorGUI.this.setTexture(texture, rectangle, 3, "_BACK", 1);
                                break;
                            }
                            case 4: {
                                J3DEditorGUI.this.setTexture(texture, rectangle, 5, "_RIGHT", 1);
                                break;
                            }
                            case 5: {
                                J3DEditorGUI.this.setTexture(texture, rectangle, 4, "_BOTTOM", 2);
                            }
                            default: {
                                break;
                            }
                        }
                    }
                }
                catch (IOException exception) {
                    J3DEditorGUI.this.showGeneralError(exception);
                }
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        return fileGroup;
    }

    private void setTexture(Texture2D texture, J3DRectangle rectangle, int side, String sideTag, int rectangleSide) {
        this.textures[side] = texture;
        for (J3DInstance object : this.getNormal()) {
            switch (side) {
                case 0: {
                    this.setTexture2Surface(texture, object, sideTag, 1);
                    break;
                }
                case 3: {
                    this.setTexture2Surface(texture, object, sideTag, 1);
                    break;
                }
                case 1: {
                    this.setTexture2Surface(texture, object, sideTag, 2);
                    break;
                }
                case 4: {
                    this.setTexture2Surface(texture, object, sideTag, 2);
                    break;
                }
                case 2: {
                    this.setTexture2Surface(texture, object, sideTag, 3);
                    break;
                }
                case 5: {
                    this.setTexture2Surface(texture, object, sideTag, 3);
                }
            }
        }
        for (J3DInstance object : this.getSelected()) {
            this.setTexture2Surface(texture, object, sideTag, side);
        }
        switch (rectangleSide) {
            case 1: {
                rectangle.setTexture1((Texture)texture);
                break;
            }
            case 2: {
                rectangle.setTexture2((Texture)texture);
            }
        }
    }

    private void setTexture2Surface(Texture2D texture, J3DInstance object, String sideTag, int side) {
        if (object instanceof J3DTexturedObject) {
            if (this.tagger.getTags(object).contains(sideTag)) {
                ((J3DTexturedObject)object).setTexture(texture, side);
            } else {
                ((J3DTexturedObject)object).setTexture(null, side);
            }
        }
    }

    private void enableTextures() {
        this.enableTextures(this.textures[3], this.textures[0], this.textureFiles.isChecked(3), this.textureFiles.isChecked(0), this.frontBackRectangle);
        this.enableTextures(this.textures[5], this.textures[2], this.textureFiles.isChecked(4), this.textureFiles.isChecked(1), this.leftRightRectangle);
        this.enableTextures(this.textures[1], this.textures[4], this.textureFiles.isChecked(2), this.textureFiles.isChecked(5), this.topBottomRectangle);
    }

    private void enableTextures(Texture2D texture1, Texture2D texture2, boolean enable1, boolean enable2, J3DRectangle rectangle) {
        if (texture1 != null) {
            texture1.setEnable(enable1);
        }
        if (texture2 != null) {
            texture2.setEnable(enable2);
        }
        if (!enable1 && !enable2) {
            if (rectangle.getParent() != null) {
                this.canvas.getScene().removeObject(rectangle);
            }
        } else if (rectangle.getParent() == null) {
            this.canvas.getScene().addObject(rectangle);
            rectangle.setTexture1((Texture)texture1);
            rectangle.setTexture2((Texture)texture2);
        }
    }

    protected ColorScaleGroup createColorScaleGroup(Composite parent) {
        final ColorScaleGroup scaleGroup = new ColorScaleGroup(parent, "Color", 255, 255, 255, 255, 100, false);
        Composite colorButtons = new Composite(scaleGroup.getGroup(), 0);
        colorButtons.setLayout(SWTUtils.gridLayout(2, true, 0, 0, 0, 0, 0, 0, 5, 0));
        colorButtons.setLayoutData(SWTUtils.gridData(2, 1, 0, 0, -1, -1, false, false));
        ((GridData)colorButtons.getLayoutData()).horizontalSpan = 3;
        Composite alphaButtons = new Composite(scaleGroup.getGroup(), 0);
        alphaButtons.setLayout(SWTUtils.gridLayout(2, true, 0, 0, 0, 0, 0, 0, 5, 0));
        alphaButtons.setLayoutData(SWTUtils.gridData(2, 1, 0, 0, -1, -1, false, false));
        ((GridData)alphaButtons.getLayoutData()).horizontalSpan = 1;
        Label getColorButton = new IconButton(colorButtons, true, Icons.getSWTImage(this.display, "get.png"), Icons.getSWTImage(this.display, "get_focus.png"), Icons.getSWTImage(this.display, "get_pressed.png"), "Get color from (1st) selected shape").getButton();
        getColorButton.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, true, false));
        getColorButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                    if (!(object instanceof J3DColoredObject)) continue;
                    Color3f color = ((J3DColoredObject)object).getColor();
                    scaleGroup.setColor((int)(color.x * 255.0f), (int)(color.y * 255.0f), (int)(color.z * 255.0f));
                    break;
                }
            }
        });
        Label getAlphaButton = new IconButton(alphaButtons, true, Icons.getSWTImage(this.display, "get.png"), Icons.getSWTImage(this.display, "get_focus.png"), Icons.getSWTImage(this.display, "get_pressed.png"), "Get alpha value from (1st) selected shape").getButton();
        getAlphaButton.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, true, false));
        getAlphaButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                            if (!(object instanceof J3DColoredObject)) continue;
                            scaleGroup.setValue(3, 255.0f * (1.0f - object.getTransparency()));
                            break;
                        }
                    }
                    finally {
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        Label setColorButton = new IconButton(colorButtons, true, Icons.getSWTImage(this.display, "start.png"), Icons.getSWTImage(this.display, "start_focus.png"), Icons.getSWTImage(this.display, "start_pressed.png"), "Set color for all selected shapes").getButton();
        setColorButton.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, true, false));
        setColorButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                            if (!(object instanceof J3DColoredObject)) continue;
                            ((J3DColoredObject)object).setColor(new Color3f((float)scaleGroup.getRed() / 255.0f, (float)scaleGroup.getGreen() / 255.0f, (float)scaleGroup.getBlue() / 255.0f));
                            J3DEditorGUI.this.history.changed(object, J3DHistory.Part.COLOR);
                        }
                    }
                    finally {
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        Label setAlphaButton = new IconButton(alphaButtons, true, Icons.getSWTImage(this.display, "start.png"), Icons.getSWTImage(this.display, "start_focus.png"), Icons.getSWTImage(this.display, "start_pressed.png"), "Set alpha value for all selected shapes").getButton();
        setAlphaButton.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, true, false));
        setAlphaButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                            if (!(object instanceof J3DColoredObject)) continue;
                            ((J3DColoredObject)object).setTransparency((float)((255.0 - scaleGroup.getValue(3)) / 255.0));
                        }
                    }
                    finally {
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        return scaleGroup;
    }

    protected RoundnessScaleGroup createRoundnessScaleGroup(Composite parent) {
        final RoundnessScaleGroup scaleGroup = new RoundnessScaleGroup(parent, "Round.", 1.0, 100, false);
        Composite buttons = new Composite(scaleGroup.getGroup(), 0);
        buttons.setLayout(SWTUtils.gridLayout(2, true, 0, 0, 0, 0, 0, 0, 5, 0));
        buttons.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        ((GridData)buttons.getLayoutData()).horizontalSpan = 2;
        Label getRoundnessButton = new IconButton(buttons, true, Icons.getSWTImage(this.display, "get.png"), Icons.getSWTImage(this.display, "get_focus.png"), Icons.getSWTImage(this.display, "get_pressed.png"), "Get roundness from (1st) selected mesh shape").getButton();
        getRoundnessButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        getRoundnessButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                    if (!(object instanceof J3DSurface)) continue;
                    double roundness = ((J3DSurface)object).getRoundness();
                    scaleGroup.setRoundness(roundness);
                    break;
                }
            }
        });
        Label setRoundnessButton = new IconButton(buttons, true, Icons.getSWTImage(this.display, "start.png"), Icons.getSWTImage(this.display, "start_focus.png"), Icons.getSWTImage(this.display, "start_pressed.png"), "Set roundness for all selected mesh shapes").getButton();
        setRoundnessButton.setLayoutData(SWTUtils.gridData(0x1000000, 0x1000000, 0, 0, -1, -1, false, false));
        setRoundnessButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        double roundness = scaleGroup.getRoundness();
                        for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                            if (!(object instanceof J3DSurface)) continue;
                            ((J3DSurface)object).setRoundness(roundness);
                        }
                    }
                    finally {
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        return scaleGroup;
    }

    protected MeltingRadiusScaleGroup createMeltingRadiusScaleGroup(Composite parent) {
        MeltingRadiusScaleGroup scaleGroup = new MeltingRadiusScaleGroup(parent, "Melting Radius", 0.01, 100, true);
        Composite buttons = scaleGroup.getRightGenericSection(0);
        buttons.setLayout(SWTUtils.gridLayout(1, true, 0, 0, 0, 0, 0, 0, 0, 0));
        buttons.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, false, false));
        Label setMaterialButton = new IconButton(buttons, true, Icons.getSWTImage(this.display, "start.png"), Icons.getSWTImage(this.display, "start_focus.png"), Icons.getSWTImage(this.display, "start_pressed.png"), "Unify selected needles/points within the \"melting radius\".").getButton();
        setMaterialButton.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, true, false));
        setMaterialButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DEditorGUI.this.meltSelected();
            }
        });
        return scaleGroup;
    }

    protected MaterialScaleGroup createMaterialScaleGroup(Composite parent) {
        final MaterialScaleGroup scaleGroup = new MaterialScaleGroup(parent, "Material", 1.0, 0.0, 0.0, 0.1, 100, false);
        Composite buttons = new Composite(scaleGroup.getGroup(), 0);
        buttons.setLayout(SWTUtils.gridLayout(3, true, 0, 0, 0, 0, 0, 0, 5, 0));
        buttons.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, true, false));
        ((GridData)buttons.getLayoutData()).horizontalSpan = 2;
        Label getMaterialButton = new IconButton(buttons, true, Icons.getSWTImage(this.display, "get.png"), Icons.getSWTImage(this.display, "get_focus.png"), Icons.getSWTImage(this.display, "get_pressed.png"), "Get material from (1st) selected shape").getButton();
        getMaterialButton.setLayoutData(SWTUtils.gridData(4, 2, 0, 0, -1, -1, true, false));
        getMaterialButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                    E3DMaterial material;
                    if (!(object instanceof J3DMaterialObject) || (material = ((J3DMaterialObject)object).getMaterial()) == null) continue;
                    scaleGroup.setMaterial(material.getGlossiness(), material.getReflectivity(), material.getGlow(), material.getRefractivity());
                    break;
                }
            }
        });
        Label setMaterialButton = new IconButton(buttons, true, Icons.getSWTImage(this.display, "start.png"), Icons.getSWTImage(this.display, "start_focus.png"), Icons.getSWTImage(this.display, "start_pressed.png"), "Set material for all selected shapes").getButton();
        setMaterialButton.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, true, false));
        setMaterialButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                            if (!(object instanceof J3DMaterialObject)) continue;
                            E3DMaterial material = new E3DMaterial(scaleGroup.getGloss(), scaleGroup.getMirror(), scaleGroup.getGlow(), null, scaleGroup.getRefractivity());
                            ((J3DMaterialObject)object).setMaterial(material);
                            J3DEditorGUI.this.history.changed(object, J3DHistory.Part.MATERIAL);
                        }
                    }
                    finally {
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        Label rmMaterialButton = new IconButton(buttons, true, Icons.getSWTImage(this.display, "stop.png"), Icons.getSWTImage(this.display, "stop_focus.png"), Icons.getSWTImage(this.display, "stop_pressed.png"), "Remove material").getButton();
        rmMaterialButton.setLayoutData(SWTUtils.gridData(4, 0x1000000, 0, 0, -1, -1, true, false));
        rmMaterialButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                            if (!(object instanceof J3DMaterialObject)) continue;
                            ((J3DMaterialObject)object).setMaterial(null);
                        }
                    }
                    finally {
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        return scaleGroup;
    }

    protected FileGroup createIndividualTextureFileGroup(Composite parent) {
        final FileGroup fileGroup = new FileGroup(parent, "Inidvidual Files", new String[]{"Texture:"}, new String[1], new File[1][], new String[][]{{"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true}, new Boolean[]{true}, new Boolean[1], 75, 350, false, false);
        Composite leftButtons = fileGroup.getLeftGenericSection(0);
        leftButtons.setLayout(SWTUtils.gridLayout(1, true, 0, 0, 0, 0, 0, 0, 0, 0));
        leftButtons.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, -1, -1, false, false));
        Composite rightButtons = fileGroup.getRightGenericSection(0);
        rightButtons.setLayout(SWTUtils.gridLayout(3, true, 0, 0, 0, 0, 0, 0, 0, 0));
        rightButtons.setLayoutData(SWTUtils.gridData(3, 2, 0, 0, -1, -1, false, false));
        Label getTextureButton = new IconButton(leftButtons, true, Icons.getSWTImage(this.display, "get.png"), Icons.getSWTImage(this.display, "get_focus.png"), Icons.getSWTImage(this.display, "get_pressed.png"), "Get texture file from (1st) selected shape").getButton();
        getTextureButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        getTextureButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                    if (!(object instanceof J3DTexturedObject)) continue;
                    E3DTextureFile file = ((J3DTexturedObject)object).getIndividualTexture();
                    fileGroup.setFiles(new File[]{file}, true, 0);
                    break;
                }
            }
        });
        Label setTextureButton = new IconButton(rightButtons, true, Icons.getSWTImage(this.display, "start.png"), Icons.getSWTImage(this.display, "start_focus.png"), Icons.getSWTImage(this.display, "start_pressed.png"), "Set texture for all selected shapes").getButton();
        setTextureButton.setLayoutData(SWTUtils.gridData(0x1000000, 0x1000000, 0, 0, -1, -1, false, false));
        setTextureButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    block10: {
                        J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                        try {
                            try {
                                File[] files = fileGroup.getFiles(0);
                                E3DTextureFile file = files == null || files.length != 1 || files[0] == null ? null : new E3DTextureFile(files[0].getPath());
                                Texture2D texture2D = file == null ? null : J3DTextureUtils.createTexture2D(file, true, false, false, true);
                                Texture3D texture3D = files == null || files.length <= 0 ? null : J3DTextureUtils.createTexture3D(files, true, false, false, false);
                                for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                                    if (object instanceof J3DTexturedObject) {
                                        ((J3DTexturedObject)object).setIndividualTexture(file);
                                        ((J3DTexturedObject)object).setTexture(texture2D, 0);
                                        J3DEditorGUI.this.history.changed(object, J3DHistory.Part.TEXTURE);
                                        continue;
                                    }
                                    if (!(object instanceof J3DVolume)) continue;
                                    ((J3DVolume)object).setTexture(texture3D);
                                }
                            }
                            catch (IOException exception) {
                                J3DEditorGUI.this.showGeneralError(exception);
                                J3DEditorGUI.this.history.next();
                                J3DEditorGUI.this.canvas.unlock(lock);
                                break block10;
                            }
                        }
                        catch (Throwable throwable) {
                            J3DEditorGUI.this.history.next();
                            J3DEditorGUI.this.canvas.unlock(lock);
                            throw throwable;
                        }
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        Label rmTextureButton = new IconButton(rightButtons, true, Icons.getSWTImage(this.display, "stop.png"), Icons.getSWTImage(this.display, "stop_focus.png"), Icons.getSWTImage(this.display, "stop_pressed.png"), "Remove textures from all selected shapes").getButton();
        rmTextureButton.setLayoutData(SWTUtils.gridData(0x1000000, 0x1000000, 0, 0, -1, -1, false, false));
        rmTextureButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                    try {
                        fileGroup.setFiles(new File[1], true, 0);
                        for (J3DInstance object : J3DEditorGUI.this.getSelected()) {
                            if (object instanceof J3DTexturedObject) {
                                ((J3DTexturedObject)object).setIndividualTexture(null);
                                ((J3DTexturedObject)object).setTexture(null, 0);
                                continue;
                            }
                            if (!(object instanceof J3DVolume)) continue;
                            ((J3DVolume)object).setTexture(null);
                        }
                    }
                    finally {
                        J3DEditorGUI.this.history.next();
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        Label saveTextureButton = new IconButton(rightButtons, true, Icons.getSWTImage(this.display, "save.png"), Icons.getSWTImage(this.display, "save_focus.png"), Icons.getSWTImage(this.display, "save_pressed.png"), "Save textures of all selected objects").getButton();
        saveTextureButton.setLayoutData(SWTUtils.gridData(2, 2, 0, 0, -1, -1, false, false));
        saveTextureButton.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                J3DCanvas j3DCanvas = J3DEditorGUI.this.canvas;
                synchronized (j3DCanvas) {
                    block11: {
                        J3DCanvas.Lock lock = J3DEditorGUI.this.canvas.lock();
                        try {
                            try {
                                J3DTexturedObject object = J3DEditorGUI.this.getOneAndOnlySelectedTexturedObject();
                                if (object == null) {
                                    MessageBox msgBox = new MessageBox(J3DEditorGUI.this.shell, 33);
                                    msgBox.setText("Select exactly one textured object!");
                                    msgBox.setMessage("Exactly one object must be selected, which must be textured to do this.");
                                    msgBox.open();
                                } else {
                                    E3DTextureFile file = object.getIndividualTexture();
                                    E3DFileDialog dialog = new E3DFileDialog(J3DEditorGUI.this.shell, "Save Texture", 8192, new File[]{file}, new String[]{"Supported Files", "All Files"}, new String[]{"*.png;*.jpg;*.JPG;*.PNG", "*.*"});
                                    File[] files = dialog.open();
                                    if (files != null) {
                                        Texture2D texture = object.getTexture(0);
                                        BufferedImage origImage = (BufferedImage)texture.getUserData();
                                        ImageComponent2D imageComponent = (ImageComponent2D)texture.getImage(0);
                                        E3DImageAWT currImage = new E3DImageAWT(imageComponent.getImage());
                                        E3DImageAWT image = currImage.scale(origImage.getWidth(), origImage.getHeight());
                                        image.setJPGQuality(0.9f);
                                        image.save(files[0]);
                                        fileGroup.setFiles(files, true, 0);
                                    }
                                }
                            }
                            catch (Exception exception) {
                                J3DEditorGUI.this.showGeneralError(exception);
                                J3DEditorGUI.this.canvas.unlock(lock);
                                break block11;
                            }
                        }
                        catch (Throwable throwable) {
                            J3DEditorGUI.this.canvas.unlock(lock);
                            throw throwable;
                        }
                        J3DEditorGUI.this.canvas.unlock(lock);
                    }
                }
            }
        });
        return fileGroup;
    }

    private J3DTexturedObject getOneAndOnlySelectedTexturedObject() {
        J3DTexturedObject object = null;
        for (J3DInstance sel : this.getSelected()) {
            if (!(sel instanceof J3DTexturedObject)) continue;
            if (object != null) {
                object = null;
                break;
            }
            object = (J3DTexturedObject)sel;
            if (object.getTexture(0) != null) continue;
            object = null;
            break;
        }
        return object;
    }

    protected ListGroup createTagListGroup(Composite parent) {
        String[] tags = this.tagger.getSortedTags().toArray(new String[this.tagger.getTags().size()]);
        return new TagListGroup(parent, this, tags);
    }

    protected void updateTagLists() {
        String[] tagArray = this.tagger.getSortedTags().toArray(new String[this.tagger.getTags().size()]);
        this.tagLists.setContent(0, tagArray);
        this.tagLists.setContent(1, tagArray);
    }

    protected void createTemplateGroups(Composite parent) {
        final SphereTemplateGroup sphereTemplateGroup = new SphereTemplateGroup(this, parent);
        final CylinderTemplateGroup cylinderTemplateGroup = new CylinderTemplateGroup(this, parent);
        final RectangleTemplateGroup rectangleTemplateGroup = new RectangleTemplateGroup(this, parent);
        final CircleTemplateGroup circleTemplateGroup = new CircleTemplateGroup(this, parent);
        SWTUtils.space(parent).setLayoutData(SWTUtils.gridData(1, 1, 0, 0, -1, 50, false, false));
        new VolumeTemplateGroup(this, parent);
        SWTUtils.space(parent).setLayoutData(SWTUtils.gridData(1, 1, 0, 0, -1, 50, false, false));
        new LayerMeshTemplateGroup(this, parent);
        Composite shapeTypeButtons = new Composite(parent, 0);
        shapeTypeButtons.setLayout(SWTUtils.gridLayout(2, true, 0, 0, 0, 0, 0, 0, 5, 0));
        shapeTypeButtons.setLayoutData(SWTUtils.gridData(2, 4, 0, 0, -1, -1, false, true));
        final ToggleButton bezierButton = new ToggleButton(shapeTypeButtons, true, Icons.getSWTImage(parent.getDisplay(), "bezier.png"), Icons.getSWTImage(parent.getDisplay(), "bezier_focus.png"), Icons.getSWTImage(parent.getDisplay(), "bezier_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "bezier_pressed_focus.png"), "Use multiple bezier surfaces for each template object", false);
        bezierButton.getButton().setLayoutData(SWTUtils.gridData(2, 3, 0, 0, -1, -1, false, true));
        final ToggleButton meshButton = new ToggleButton(shapeTypeButtons, true, Icons.getSWTImage(parent.getDisplay(), "mesh.png"), Icons.getSWTImage(parent.getDisplay(), "mesh_focus.png"), Icons.getSWTImage(parent.getDisplay(), "mesh_pressed.png"), Icons.getSWTImage(parent.getDisplay(), "mesh_pressed_focus.png"), "Use one mesh for each template", true);
        meshButton.getButton().setLayoutData(SWTUtils.gridData(2, 3, 0, 0, -1, -1, false, true));
        MouseAdapter shapeTypeListener = new MouseAdapter(){

            @Override
            public void mouseDown(org.eclipse.swt.events.MouseEvent event) {
                if (event.widget == bezierButton.getButton()) {
                    meshButton.set(!bezierButton.isOn());
                } else if (event.widget == meshButton.getButton()) {
                    bezierButton.set(!meshButton.isOn());
                }
                ShapeTemplateGroup.ShapeType shapeType = bezierButton.isOn() ? ShapeTemplateGroup.ShapeType.BEZIER : ShapeTemplateGroup.ShapeType.MESH;
                sphereTemplateGroup.setShapeType(shapeType);
                cylinderTemplateGroup.setShapeType(shapeType);
                rectangleTemplateGroup.setShapeType(shapeType);
                circleTemplateGroup.setShapeType(shapeType);
            }
        };
        bezierButton.getButton().addMouseListener(shapeTypeListener);
        meshButton.getButton().addMouseListener(shapeTypeListener);
    }

    public static void main(String[] args) {
        try {
            new J3DEditorGUI();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected static enum ViewDirection {
        FRONT,
        BACK,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM;

    }
}

