/*
 * Decompiled with CFR 0.152.
 */
package e3d.gui;

import e3d.bezier.SurfaceScan;
import e3d.bezier.Surfaces;
import e3d.euclidean.E3DVector;
import e3d.euclidean.transformations.E3DMultiTransformation;
import e3d.euclidean.transformations.E3DRotation;
import e3d.euclidean.transformations.E3DScale;
import e3d.euclidean.transformations.E3DTransformation;
import e3d.euclidean.transformations.E3DTranslation;
import e3d.gui.SpaceGUI;
import e3d.gui.groups.ImageGroup;
import e3d.gui.groups.RadioButtonGroup;
import e3d.gui.groups.WidgetGroup;
import e3d.gui.groups.WidgetGroupEditedListener;
import e3d.gui.groups.scales.ColorScaleGroup;
import e3d.gui.groups.scales.ColorShiftScaleGroup;
import e3d.gui.groups.scales.FocusScaleGroup;
import e3d.gui.groups.scales.HSBScaleGroup;
import e3d.gui.groups.scales.SingleHorizontalScaleGroup;
import e3d.gui.groups.scales.SingleVerticalScaleGroup;
import e3d.gui.groups.scales.XYZScaleGroup;
import e3d.gui.groups.scales.ZoomScaleGroup;
import e3d.gui.groups.scales.special.BezierScaleGroup;
import e3d.gui.groups.scales.special.MaterialScaleGroup;
import e3d.gui.icons.Icons;
import e3d.gui.images.ImageLocator;
import e3d.gui.images.ImageProgress;
import e3d.gui.images.Perspective;
import e3d.gui.images.ScrollableImage;
import e3d.gui.utils.E3DFileDialog;
import e3d.gui.utils.E3DHelp;
import e3d.gui.utils.SWTUtils;
import e3d.io.xml.XMLMeshObjects;
import e3d.io.xml.XMLMeshParser;
import e3d.utils.ArrayUtils;
import e3d.utils.Getter;
import e3d.utils.MathUtils;
import e3d.utils.ProgressListener;
import e3d.utils.Tagger;
import e3d.visualization.colorizer.E3DProjectionBox;
import e3d.visualization.environment.E3DBoxEnvironment;
import e3d.visualization.environment.E3DEnvironment;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageSWT;
import e3d.visualization.util.E3DBoundingBox;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class BezierGUI
extends SpaceGUI {
    private static final String NAME = "3D Bezier Renderer (V3.5)";
    private static final String HELP_URI = "help/bezier/index";
    private static final int IMAGE_DEFAULT_WIDTH = 400;
    private static final int IMAGE_DEFAULT_HEIGHT = 400;
    protected File bezierMeshFile = null;
    protected File bezierImageFile = null;
    protected final ScrollableImage scrollableImage;
    protected final ImageProgress progressListener;
    protected final ImageProgress subProgressListener;
    protected Surfaces surfaces = null;
    protected final XYZScaleGroup rotationScales;
    protected final XYZScaleGroup translationScales;
    protected final BezierScaleGroup bezierScales;
    protected final XYZScaleGroup viewScales;
    protected final XYZScaleGroup focusScales;
    protected final SingleVerticalScaleGroup distanceScales;
    protected final XYZScaleGroup lightScales;
    protected final ColorScaleGroup lightColorScales;
    protected final SingleHorizontalScaleGroup ambientShiftScales;
    protected final SingleVerticalScaleGroup ambientScales;
    protected final ColorScaleGroup bgScales;
    protected final HSBScaleGroup hsbScales;
    protected final MaterialScaleGroup materialScales;
    protected final ColorShiftScaleGroup colorShiftScales;
    protected final ColorScaleGroup shiftColorScales;
    protected final FocusScaleGroup focusFilterScales;
    protected final ImageGroup envImageGroup;
    protected final ImageGroup prjImageGroup;
    protected final ImageGroup texImageGroup;
    protected final ImageGroup bgImageGroup;
    protected final RadioButtonGroup texPolicyRadioButtons;
    final ZoomScaleGroup zoomScale;
    protected final SingleHorizontalScaleGroup jpgScale;

    public BezierGUI() {
        this.shell.setText(NAME);
        this.extendFileMenu();
        this.extendViewMenu();
        Composite main = new Composite(this.shell, 0);
        main.setLayoutData(new GridData(1808));
        main.setLayout(new GridLayout(2, false));
        this.scrollableImage = new ScrollableImage(main);
        ((GridData)this.scrollableImage.getScroll().getLayoutData()).widthHint = 400;
        ((GridData)this.scrollableImage.getScroll().getLayoutData()).heightHint = 400;
        this.progressListener = new ImageProgress(this.scrollableImage, -36, 1.0);
        this.subProgressListener = new ImageProgress(this.scrollableImage, 37, 0.67);
        Composite controlFrame = new Composite(main, 0);
        controlFrame.setLayout(new GridLayout(1, false));
        controlFrame.setLayoutData(new GridData(4, 4, false, true));
        final TabFolder tabFolder = new TabFolder(controlFrame, 128);
        tabFolder.setLayoutData(new GridData(4, 4, true, true));
        tabFolder.addSelectionListener(new SelectionListener(){

            @Override
            public void widgetDefaultSelected(SelectionEvent e) {
            }

            @Override
            public void widgetSelected(SelectionEvent e) {
                tabFolder.update();
            }
        });
        Composite bezierFrame = new Composite(tabFolder, 0);
        bezierFrame.setLayout(new GridLayout(2, false));
        bezierFrame.setLayoutData(new GridData(4, 4, true, true));
        this.bezierScales = new BezierScaleGroup(bezierFrame, "Meshes", 10.0, 2.0, 1.0, 1, 0, 0, 50, 5000, 10, 5, 5, 100, false);
        SWTUtils.space(bezierFrame);
        this.rotationScales = new XYZScaleGroup(bezierFrame, "Rotation", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        this.translationScales = new XYZScaleGroup(bezierFrame, "Translation", 10.0, 0.0, 0.0, 0.0, -10, -10, -10, 10, 10, 10, 100, false);
        TabItem bezierTab = new TabItem(tabFolder, 0);
        bezierTab.setText("Bezier");
        bezierTab.setControl(bezierFrame);
        Composite textureFrame = new Composite(tabFolder, 0);
        textureFrame.setLayout(new GridLayout(1, false));
        textureFrame.setLayoutData(new GridData(4, 4, true, true));
        this.prjImageGroup = new ImageGroup(textureFrame, "Projection Images", new String[]{"Front:", "Left:", "Upper:", "Back:", "Right:", "Lower:"}, new String[6], new File[6][], new String[][]{{"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true, true, true, true, true, true}, new Boolean[]{false, false, false, false, false, false}, new Boolean[]{false, false, false, false, false, false}, 50, 200);
        this.texImageGroup = new ImageGroup(textureFrame, "Texture Images", new String[]{"Images:"}, new String[1], new File[1][], new String[][]{{"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true}, new Boolean[]{true}, new Boolean[]{false}, 75, 200);
        this.texPolicyRadioButtons = new RadioButtonGroup(textureFrame, "Texture Choosing Policy", new String[]{"forward", "backward", "random"}, new String[]{"forward", "backward", "random"}, 0, 100, true, false);
        TabItem textureTab = new TabItem(tabFolder, 0);
        textureTab.setText("Texture");
        textureTab.setControl(textureFrame);
        Composite renderingFrame = new Composite(tabFolder, 0);
        renderingFrame.setLayout(new GridLayout(3, false));
        renderingFrame.setLayoutData(new GridData(4, 4, true, true));
        this.viewScales = new XYZScaleGroup(renderingFrame, "Viewer Position", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        Perspective viewPerspective = new Perspective(this.scrollableImage, this.viewScales, new Color(this.display, 192, 255, 129), 1);
        viewPerspective.show();
        this.distanceScales = new SingleVerticalScaleGroup(renderingFrame, "Dist.", "viewer distance", "distance_focus.png", 0.1, 0.0, 0, 100, 100, false);
        this.focusScales = new XYZScaleGroup(renderingFrame, "Focus-Point (offset)", 1.0, 0.0, 0.0, 0.0, -100, -100, -100, 100, 100, 100, 100, false);
        this.lightScales = new XYZScaleGroup(renderingFrame, "Light-Point", 1.0, 0.0, 0.0, -10.0, -10, -10, -10, 10, 10, 10, 100, false);
        Perspective lightPerspective = new Perspective(this.scrollableImage, this.lightScales, new Color(this.display, 255, 255, 129), 2);
        lightPerspective.show();
        this.ambientScales = new SingleVerticalScaleGroup(renderingFrame, "Amb.", "Ambient light", "diffusion_focus.png", 10.0, 0.1, 0, 20, 100, false);
        this.lightColorScales = new ColorScaleGroup(renderingFrame, "Light-Color", 255, 255, 255, 255, 100, false);
        ((GridData)this.lightColorScales.getGroup().getLayoutData()).verticalSpan = 2;
        this.ambientShiftScales = new SingleHorizontalScaleGroup(renderingFrame, "Ambient Light Color Shift", "Hue-Shift", "hue_focus.png", 10.0, 0.0, -10, 10, 100, true);
        ((GridData)this.ambientShiftScales.getGroup().getLayoutData()).horizontalSpan = 2;
        Composite envMaterialFrame = new Composite(renderingFrame, 0);
        envMaterialFrame.setLayout(SWTUtils.gridLayout(2, false, 5, 5, 0, 0, 0, 0, 0, 0));
        envMaterialFrame.setLayoutData(SWTUtils.gridData(4, 4, 0, 0, -1, -1, false, false));
        ((GridData)envMaterialFrame.getLayoutData()).horizontalSpan = 3;
        this.materialScales = new MaterialScaleGroup(envMaterialFrame, "Material", 0.5, 0.0, 0.0, 0.0, 100, false);
        this.envImageGroup = new ImageGroup(envMaterialFrame, "Environment Images (sourrounding box)", new String[]{"Front:", "Left:", "Upper:", "Back:", "Right:", "Lower:"}, new String[6], new File[6][], new String[][]{{"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}, {"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}, {"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true, true, true, true, true, true}, new Boolean[]{false, false, false, false, false, false}, new Boolean[]{false, false, false, false, false, false}, 50, 150);
        TabItem renderingTab = new TabItem(tabFolder, 0);
        renderingTab.setText("Rendering");
        renderingTab.setControl(renderingFrame);
        Composite filterFrame = new Composite(tabFolder, 0);
        filterFrame.setLayout(new GridLayout(3, false));
        filterFrame.setLayoutData(new GridData(4, 4, true, true));
        this.bgImageGroup = new ImageGroup(filterFrame, "Background Image", new String[]{"Background"}, new String[1], new File[1][], new String[][]{{"Supported Files", "All Files"}}, new String[][]{{"*.png;*.jpg;*.JPG;*.PNG", "*.*"}}, new Boolean[]{true}, new Boolean[]{false}, new Boolean[]{false}, 75, 200);
        ((GridData)this.bgImageGroup.getGroup().getLayoutData()).horizontalSpan = 3;
        this.bgScales = new ColorScaleGroup(filterFrame, "Background Color", 0, 0, 0, 0, 100, false);
        this.focusFilterScales = new FocusScaleGroup(filterFrame, "Focus", 0.0, 0.0, 100, false);
        this.hsbScales = new HSBScaleGroup(filterFrame, "HSB-Filter", 0.0, 1.0, 1.0, 100, false);
        this.shiftColorScales = new ColorScaleGroup(filterFrame, "Shift Color", 0, 0, 255, 255, 100, false);
        this.colorShiftScales = new ColorShiftScaleGroup(filterFrame, "Shift", 0.0, 0.0, 100, false);
        TabItem filterTab = new TabItem(tabFolder, 0);
        filterTab.setText("Filter");
        filterTab.setControl(filterFrame);
        Composite imageFrame = new Composite(tabFolder, 0);
        imageFrame.setLayout(new GridLayout(2, false));
        imageFrame.setLayoutData(new GridData(4, 4, true, false));
        this.zoomScale = new ZoomScaleGroup(imageFrame, "Zoom", 100.0, true, 100, false);
        this.zoomScale.addListener(new WidgetGroupEditedListener(){

            @Override
            public void edited(WidgetGroup group, int index, int field) {
                BezierGUI.this.scrollableImage.setZoom((double)BezierGUI.this.zoomScale.getZoom() / 100.0);
            }

            @Override
            public void finished(WidgetGroup group, int index, int field) {
            }
        });
        this.jpgScale = new SingleHorizontalScaleGroup(imageFrame, "JPEG Parameters", "Quality", null, 20.0, 0.9, 10, 20, 100, true);
        TabItem imageTab = new TabItem(tabFolder, 0);
        imageTab.setText("View");
        imageTab.setControl(imageFrame);
        Point size = this.shell.computeSize(-1, -1);
        this.shell.setSize(Math.min(1800, size.x), Math.min(1200, size.y));
        try {
            this.scrollableImage.setE3DImage(Icons.getE3DImageSWT("e3d_persp.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Getter<E3DVector> voxelSizeGetter = new Getter<E3DVector>(){

            @Override
            public E3DVector get() {
                return BezierGUI.this.voxelSize;
            }
        };
        Getter<E3DVector> viewPosGetter = new Getter<E3DVector>(){

            @Override
            public E3DVector get() {
                return BezierGUI.this.viewPos;
            }
        };
        Getter<float[][][]> xyzBufferGetter = new Getter<float[][][]>(){

            @Override
            public float[][][] get() {
                return BezierGUI.this.xyzBuffer;
            }
        };
        Getter<double[]> dMinMaxGetter = new Getter<double[]>(){

            @Override
            public double[] get() {
                return BezierGUI.this.dMinMax;
            }
        };
        new ImageLocator(this.scrollableImage, voxelSizeGetter, viewPosGetter, xyzBufferGetter, dMinMaxGetter);
        this.prepare4AutomaticRestart();
        this.coolBar.setStartable(true);
        this.run();
    }

    @Override
    protected ScrollableImage getScrollableImage() {
        return this.scrollableImage;
    }

    @Override
    protected E3DMaterial getDefaultMaterial() {
        return new E3DMaterial(this.materialScales.getGloss(), this.materialScales.getMirror(), this.materialScales.getGlow(), null, this.materialScales.getRefractivity());
    }

    @Override
    protected E3DVector getViewPosition() {
        E3DVector pos = this.viewScales.getXYZ();
        double dist = this.distanceScales.getValue();
        pos.norm(dist <= 0.0 ? 100000.0 : dist);
        return pos;
    }

    @Override
    protected E3DVector getFocusPoint() {
        return this.focusScales.getXYZ();
    }

    @Override
    protected List<E3DVector> getLightPositions() {
        ArrayList<E3DVector> lightPositions = new ArrayList<E3DVector>(1);
        E3DVector lightPos = this.lightScales.getXYZ();
        lightPos.multiplicate(10000.0);
        lightPositions.add(lightPos);
        return lightPositions;
    }

    @Override
    protected int getLightColor() {
        return this.lightColorScales.getColor();
    }

    @Override
    protected int getAmbientLightColor() {
        double shift = this.ambientShiftScales.getValue();
        return E3DColor.changeHSB(this.lightColorScales.getColor(), shift, 1.0, 1.0);
    }

    @Override
    protected double getAmbient() {
        return this.ambientScales.getValue();
    }

    @Override
    protected double getHue() {
        return this.hsbScales.getHue();
    }

    @Override
    protected double getSaturation() {
        return this.hsbScales.getSaturation();
    }

    @Override
    protected double getBrightness() {
        return this.hsbScales.getBrightness();
    }

    @Override
    protected int getBGColor() {
        return this.bgScales.getColor();
    }

    @Override
    protected int getShiftColor() {
        return this.shiftColorScales.getColor();
    }

    @Override
    protected double getBlueShift() {
        return this.colorShiftScales.getBlueShift();
    }

    @Override
    protected double getWhiteShift() {
        return this.colorShiftScales.getWhiteShift();
    }

    @Override
    public double getMaxBlurRadius() {
        return this.focusFilterScales.getMaxBlurRadius();
    }

    @Override
    public double getFocalDistance() {
        return this.focusFilterScales.getFocalDistance();
    }

    @Override
    protected E3DImage getBGImage() {
        E3DImageSWT[] images = this.bgImageGroup.getImages(0);
        return images != null && images.length > 0 ? images[0] : null;
    }

    @Override
    protected E3DBoundingBox getBounds() {
        return this.scan.getTightBounds();
    }

    @Override
    protected int getImageWidth() {
        return this.scan.getWidth();
    }

    @Override
    protected int getImageHeight() {
        return this.scan.getHeight();
    }

    @Override
    protected int getZBufferDepth() {
        return this.scan.getDepth();
    }

    @Override
    protected E3DEnvironment getEnvironment() {
        E3DImage leftImg = ArrayUtils.get(this.envImageGroup.getImages(1), 0, null);
        E3DImage upperImg = ArrayUtils.get(this.envImageGroup.getImages(2), 0, null);
        E3DImage frontImg = ArrayUtils.get(this.envImageGroup.getImages(0), 0, null);
        E3DImage rightImg = ArrayUtils.get(this.envImageGroup.getImages(4), 0, null);
        E3DImage lowerImg = ArrayUtils.get(this.envImageGroup.getImages(5), 0, null);
        E3DImage backImg = ArrayUtils.get(this.envImageGroup.getImages(3), 0, null);
        if (leftImg != null || upperImg != null || frontImg != null || rightImg != null || lowerImg != null || backImg != null) {
            E3DBoundingBox bounds = this.getBounds();
            E3DBoxEnvironment box = new E3DBoxEnvironment(this.envDirectlyVisible, bounds, leftImg, rightImg, upperImg, lowerImg, frontImg, backImg);
            return box;
        }
        return null;
    }

    @Override
    protected ProgressListener getProgressListener() {
        return this.progressListener;
    }

    @Override
    protected ProgressListener getSubProgressListener() {
        return this.subProgressListener;
    }

    @Override
    public float getJPGQuality() {
        return (float)this.jpgScale.getValue();
    }

    @Override
    public boolean hasLoadItem() {
        return true;
    }

    @Override
    public boolean isStartable() {
        return true;
    }

    @Override
    public boolean hasEditMenu() {
        return false;
    }

    @Override
    public boolean hasViewMenu() {
        return false;
    }

    @Override
    public void load() {
        E3DFileDialog dialog = new E3DFileDialog(this.shell, "Load Source File", 4096, new File[]{this.bezierMeshFile}, new String[]{"XML Files", "Dump Files", "All Files"}, new String[]{"*.xml;*.XML", "*.dmp;*.DMP", "*.*"});
        File[] selection = dialog.open();
        if (selection != null) {
            this.bezierMeshFile = selection[0];
            try {
                if (this.bezierMeshFile.getName().endsWith(".dmp")) {
                    throw new UnsupportedOperationException("Sorry \"dmp-files\" are not supported anymore.");
                }
                XMLMeshParser parser = new XMLMeshParser();
                parser.setBaseDirectory(this.bezierMeshFile.getParentFile());
                XMLMeshObjects parsedObjects = (XMLMeshObjects)parser.readXML(this.bezierMeshFile);
                Tagger<Object> tagger = parsedObjects.getTagger();
                this.surfaces = new Surfaces();
                this.surfaces.add(parsedObjects.getNeedleMeshes(), tagger);
                this.surfaces.addAsPointHoods(parsedObjects.getPointMeshes(), tagger);
                this.unfilteredImage = null;
                this.filteredImage = null;
                this.scan = null;
                this.scrollableImage.setE3DImage(this.filteredImage);
                this.menu.setSavable(false);
                this.coolBar.setSavable(false);
                this.coolBar.setStartable(true);
                if (this.auto) {
                    this.restart(SpaceGUI.Step.SCANNING);
                }
            }
            catch (Exception exception) {
                MessageBox msgBox = new MessageBox(this.shell, 33);
                msgBox.setText("Load Error");
                if (exception.getMessage() != null) {
                    msgBox.setMessage(exception.getMessage());
                }
                msgBox.open();
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void save() {
        this.bezierImageFile = this.saveImage("Save Bezier Image", this.filteredImage, this.bezierImageFile);
    }

    @Override
    public void start() {
        if (this.future != null) {
            this.showBusyMessage();
        } else if (this.surfaces == null) {
            MessageBox msgBox = new MessageBox(this.shell, 34);
            msgBox.setText("No Bezier-Parameters");
            msgBox.setMessage("Load an bezier definition file first...");
            msgBox.open();
        } else {
            this.restart(SpaceGUI.Step.COMPLETE);
        }
    }

    protected SurfaceScan scanning() throws Exception {
        E3DRotation spin;
        this.statistics.clear();
        if (this.surfaces == null) {
            return null;
        }
        int bezRes = this.bezierScales.getBezierResolution();
        int minSplits = this.bezierScales.getMinSplits();
        int maxSplits = this.bezierScales.getMaxSplits();
        Surfaces splitted = this.surfaces.split(bezRes, minSplits, maxSplits);
        E3DMultiTransformation pointTransformations = new E3DMultiTransformation();
        E3DVector translation = this.translationScales.getXYZ();
        if (translation.x != 0.0 || translation.y != 0.0 || translation.z != 0.0) {
            E3DTranslation shift = new E3DTranslation(translation);
            pointTransformations.add(shift);
        } else {
            Object shift = null;
        }
        E3DVector rotation = this.rotationScales.getXYZ();
        if (rotation.x != 0.0 || rotation.y != 0.0 || rotation.z > 0.0) {
            spin = new E3DRotation(rotation, false, false, true);
            pointTransformations.add(spin);
        } else {
            spin = null;
        }
        double scaleFactor = this.bezierScales.getScaleFactor();
        if (scaleFactor != 1.0) {
            E3DScale scale = new E3DScale(scaleFactor);
            pointTransformations.add(scale);
        } else {
            Object scale = null;
        }
        Surfaces transformed = splitted.transformed(pointTransformations);
        E3DBoundingBox bounds = transformed.getBounds();
        double margin = MathUtils.max(bounds.width(), bounds.height(), bounds.depth()) / 10.0;
        bounds.x0 -= margin;
        bounds.x1 += margin;
        bounds.y0 -= margin;
        bounds.y1 += margin;
        bounds.z0 -= margin;
        bounds.z1 += margin;
        int width = (int)bounds.width();
        int height = (int)bounds.height();
        int depth = (int)bounds.depth();
        if (width < 1 || height < 1 || depth < 1) {
            this.showWarning("Empty scan (maybe the object is too small, try to scale it up)");
            return null;
        }
        SurfaceScan scan = new SurfaceScan(bounds, width, height, depth);
        scan.setDensity(this.bezierScales.getDensity());
        scan.setRandomizeColors(false);
        if (this.texImageGroup.getImages(0) != null) {
            scan.setTextures(this.texImageGroup.getImages(0));
        }
        E3DProjectionBox projectionBox = this.getProjectionBox(scaleFactor, spin, translation);
        scan.setProjectionBox(projectionBox);
        switch (this.texPolicyRadioButtons.getSelected()) {
            case 0: {
                scan.setTextureChoosingPolicy(SurfaceScan.TextureChoosingPolicy.FORWARD);
                break;
            }
            case 1: {
                scan.setTextureChoosingPolicy(SurfaceScan.TextureChoosingPolicy.BACKWARD);
                break;
            }
            case 2: {
                scan.setTextureChoosingPolicy(SurfaceScan.TextureChoosingPolicy.RANDOM);
            }
        }
        scan.addProgressListener(this.subProgressListener);
        scan.setSurfaces(transformed);
        scan.removeProgressListener(this.subProgressListener);
        return scan;
    }

    @Override
    protected void showStatistics(String text) {
    }

    @Override
    public void help() {
        new E3DHelp(this.display, NAME, HELP_URI, this);
    }

    @Override
    public void about() {
        this.about(NAME, "V3.5");
    }

    protected E3DProjectionBox getProjectionBox(double scaleFactor, E3DTransformation spin, E3DVector shift) {
        E3DProjectionBox box = new E3DProjectionBox(-scaleFactor - shift.x * scaleFactor, -scaleFactor - shift.y * scaleFactor, -scaleFactor - shift.z * scaleFactor, scaleFactor - shift.x * scaleFactor, scaleFactor - shift.y * scaleFactor, scaleFactor - shift.z * scaleFactor);
        if (spin != null) {
            spin.transform(box.getSide((int)4).n);
            spin.transform(box.getSide((int)2).n);
            spin.transform(box.getSide((int)0).n);
            spin.transform(box.getSide((int)5).n);
            spin.transform(box.getSide((int)3).n);
            spin.transform(box.getSide((int)1).n);
        }
        box.setImage(4, ArrayUtils.get(this.prjImageGroup.getImages(0), 0, null));
        box.setImage(2, ArrayUtils.get(this.prjImageGroup.getImages(1), 0, null));
        box.setImage(0, ArrayUtils.get(this.prjImageGroup.getImages(2), 0, null));
        box.setImage(5, ArrayUtils.get(this.prjImageGroup.getImages(3), 0, null));
        box.setImage(3, ArrayUtils.get(this.prjImageGroup.getImages(4), 0, null));
        box.setImage(1, ArrayUtils.get(this.prjImageGroup.getImages(5), 0, null));
        return box;
    }

    protected void prepare4AutomaticRestart() {
        WidgetGroupEditedListener scanningListener = this.getAutoListener(SpaceGUI.Step.SCANNING);
        this.bezierScales.addListener(scanningListener);
        this.rotationScales.addListener(scanningListener);
        this.translationScales.addListener(scanningListener);
        this.prjImageGroup.addListener(scanningListener);
        this.texImageGroup.addListener(scanningListener);
        this.texPolicyRadioButtons.addListener(scanningListener);
        WidgetGroupEditedListener renderingListener = this.getAutoListener(SpaceGUI.Step.RENDERING);
        this.focusScales.addListener(renderingListener);
        this.viewScales.addListener(renderingListener);
        this.distanceScales.addListener(renderingListener);
        this.lightScales.addListener(renderingListener);
        this.lightColorScales.addListener(renderingListener);
        this.materialScales.addListener(renderingListener);
        this.ambientScales.addListener(renderingListener);
        this.envImageGroup.addListener(renderingListener);
        WidgetGroupEditedListener filteringListener = this.getAutoListener(SpaceGUI.Step.FILTERING);
        this.hsbScales.addListener(filteringListener);
        this.bgScales.addListener(filteringListener);
        this.shiftColorScales.addListener(filteringListener);
        this.colorShiftScales.addListener(filteringListener);
        this.focusFilterScales.addListener(filteringListener);
        this.bgImageGroup.addListener(filteringListener);
    }

    public static void main(String[] args) {
        new BezierGUI();
    }
}

