/*
 * Decompiled with CFR 0.152.
 */
package e3d.fractal;

import e3d.fractal.FractalColorizer;
import e3d.fractal.FractalEstimator;
import e3d.numbers.E3DNumber;

public class Mandelbrot {
    protected final double sqBailOut;
    protected final int maxIter;
    protected final double maxDistance;
    protected final double minDistance;
    protected final FractalEstimator estimator;
    protected final FractalColorizer colorizer;

    public Mandelbrot(double bailOut, int maxIter, double maxDistance, double minDistance, FractalEstimator estimator, FractalColorizer colorizer) {
        this.sqBailOut = bailOut * bailOut;
        this.maxIter = maxIter;
        this.maxDistance = maxDistance;
        this.minDistance = minDistance;
        this.estimator = estimator;
        this.colorizer = colorizer;
    }

    public boolean estimate(E3DNumber c) {
        E3DNumber z = c.origin();
        return this.estimate(c, z);
    }

    protected boolean estimate(E3DNumber c, E3DNumber z) {
        E3DNumber zi = z.clone();
        int iter = 0;
        this.colorizer.init(c, zi, this.sqBailOut);
        this.estimator.init(c, zi, this.sqBailOut);
        while (iter < this.maxIter) {
            if (!this.estimator.next(c, zi, ++iter)) break;
            this.colorizer.next(c, zi, iter);
        }
        this.estimator.finish(c, zi, iter);
        double dist = this.estimator.getDistance();
        this.colorizer.finish(c, zi, iter, this.estimator);
        return dist < this.maxDistance || zi.squaredLength() < this.sqBailOut;
    }
}

