/*
 * Decompiled with CFR 0.152.
 */
package e3d.fractal;

import e3d.euclidean.E3DVector;
import e3d.fractal.FractalColorizer;
import e3d.fractal.FractalEstimator;
import e3d.fractal.Julia;
import e3d.numbers.Quaternion;
import e3d.visualization.object.E3DSubject;

public class Julia3D
extends Julia
implements E3DSubject {
    protected double t;
    protected final Quaternion c0;
    protected Integer color;
    protected double distance;
    protected final E3DVector normal = new E3DVector();

    public Julia3D(double bailOut, int maxIter, double maxDistance, double minDistance, FractalEstimator estimator, FractalColorizer colorizer, Quaternion c0, double t0) {
        super(bailOut, maxIter, maxDistance, minDistance, estimator, colorizer);
        this.t = t0;
        this.c0 = c0.clone();
    }

    @Override
    public void setPoint(double x, double y, double z) {
        if (this.estimate(this.c0, this.c0.quaternion(x, y, z, this.t))) {
            this.color = this.colorizer.getColor();
            this.distance = Math.max(-100.0, Math.min(100.0, this.estimator.getDistance() - this.minDistance));
            this.estimator.getNormal(this.normal);
        } else {
            this.color = null;
            this.distance = Math.max(-100.0, Math.min(100.0, this.estimator.getDistance() - this.minDistance));
        }
    }

    @Override
    public Integer getColor() {
        return this.color;
    }

    @Override
    public double getDistance() {
        return this.distance;
    }

    @Override
    public E3DVector getNormal() {
        return this.normal;
    }
}

