/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DPlane;
import e3d.utils.MathUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class E3DVector
implements Cloneable {
    public double x;
    public double y;
    public double z;
    private static final DecimalFormat mr_decFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

    public E3DVector() {
    }

    public E3DVector(double xyz) {
        this.set(xyz);
    }

    public E3DVector(E3DVector vector) {
        this.set(vector);
    }

    public E3DVector(E3DVector vector, double length) {
        this.set(vector, length);
    }

    public E3DVector(double x, double y, double z) {
        this.set(x, y, z);
    }

    public E3DVector(E3DVector ... summands) {
        this.set(summands);
    }

    public E3DVector clone() {
        return new E3DVector(this);
    }

    public E3DVector clone(double x, double y, double z) {
        return new E3DVector(x, y, z);
    }

    public E3DVector clone(double length) {
        return new E3DVector(this, length);
    }

    public void set(double xyz) {
        this.y = this.z = xyz;
        this.x = this.z;
    }

    public void set(E3DVector vector) {
        this.set(vector.x, vector.y, vector.z);
    }

    public void set(E3DVector vector, double length) {
        this.set(vector);
        this.norm(length);
    }

    public void set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void set(E3DVector ... summands) {
        this.z = 0.0;
        this.y = 0.0;
        this.x = 0.0;
        this.add(summands);
    }

    public void reverse() {
        this.set(-this.x, -this.y, -this.z);
    }

    public void reverse(E3DVector vector) {
        this.set(-vector.x, -vector.y, -vector.z);
    }

    public boolean isAlong(E3DVector vector) {
        E3DVector s = this.sum(vector);
        return s.squareLength() > this.squareLength() + vector.squareLength();
    }

    public boolean isOppose(E3DVector vector) {
        E3DVector s = this.sum(vector);
        return s.squareLength() < this.squareLength() + vector.squareLength();
    }

    public void along(E3DVector vector) {
        E3DVector s = this.sum(vector);
        if (s.squareLength() < this.squareLength() + vector.squareLength()) {
            this.reverse();
        }
    }

    public void oppose(E3DVector vector) {
        E3DVector s = this.sum(vector);
        if (s.squareLength() > this.squareLength() + vector.squareLength()) {
            this.reverse();
        }
    }

    public void setDist(E3DVector ref, double d) {
        if (!this.equals(ref)) {
            this.substract(ref);
            this.multiplicate(d / this.length());
            this.add(ref);
        }
    }

    public boolean isValid() {
        return !Double.isNaN(this.x) && !Double.isNaN(this.y) && !Double.isNaN(this.z) && !Double.isInfinite(this.x) && !Double.isInfinite(this.y) && !Double.isInfinite(this.z);
    }

    public boolean isOrigin() {
        return this.x == 0.0 && this.y == 0.0 && this.z == 0.0;
    }

    public double squareLength() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public double length() {
        return Math.sqrt(this.squareLength());
    }

    public double squareDist(E3DVector vector) {
        double dx = this.x - vector.x;
        double dy = this.y - vector.y;
        double dz = this.z - vector.z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double squareDist(double x, double y, double z) {
        double dx = this.x - x;
        double dy = this.y - y;
        double dz = this.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    public double dist(E3DVector vector) {
        return Math.sqrt(this.squareDist(vector));
    }

    public double dist(double x, double y, double z) {
        return Math.sqrt(this.squareDist(x, y, z));
    }

    public double norm() {
        double oldLength = this.length();
        this.divide(oldLength);
        return oldLength;
    }

    public double norm(double length) {
        double oldLength = this.length();
        this.multiplicate(length / oldLength);
        return oldLength;
    }

    public E3DVector normalized() {
        return this.clone(1.0);
    }

    public E3DVector normalized(double length) {
        return this.clone(length);
    }

    public void spinZ(double alpha) {
        double x0 = this.x;
        this.x = x0 * Math.cos(alpha) - this.y * Math.sin(alpha);
        this.y = x0 * Math.sin(alpha) + this.y * Math.cos(alpha);
    }

    public void spinY(double alpha) {
        double z0 = this.z;
        this.z = z0 * Math.cos(alpha) - this.x * Math.sin(alpha);
        this.x = z0 * Math.sin(alpha) + this.x * Math.cos(alpha);
    }

    public void spinX(double alpha) {
        double y0 = this.y;
        this.y = y0 * Math.cos(alpha) - this.z * Math.sin(alpha);
        this.z = y0 * Math.sin(alpha) + this.z * Math.cos(alpha);
    }

    public double angle(E3DVector vector) {
        return Math.acos(this.cosinus(vector));
    }

    public double cosinus(E3DVector vector) {
        return this.scalarProduct(vector) / (this.length() * vector.length());
    }

    public void intersection(E3DLine line, E3DPlane plane) {
        double t0a = plane.d - plane.n.scalarProduct(line.a);
        double t0b = plane.n.scalarProduct(line.b);
        this.set(line.a);
        this.add(line.b.product(t0a / t0b));
    }

    public void projection(E3DVector point, E3DLine line) {
        E3DVector nb = new E3DVector(line.b, 1.0);
        double d = nb.scalarProduct(point);
        this.intersection(line, new E3DPlane(nb, d));
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof E3DVector)) {
            return false;
        }
        E3DVector v = (E3DVector)object;
        return this.x == v.x && this.y == v.y && this.z == v.z;
    }

    public int hashCode() {
        return Double.valueOf(this.x).hashCode() + Double.valueOf(this.y).hashCode() + Double.valueOf(this.z).hashCode();
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    public void add(E3DVector summand) {
        this.x += summand.x;
        this.y += summand.y;
        this.z += summand.z;
    }

    public void add(E3DVector ... summands) {
        E3DVector[] e3DVectorArray = summands;
        int n = summands.length;
        int n2 = 0;
        while (n2 < n) {
            E3DVector summand = e3DVectorArray[n2];
            this.x += summand.x;
            this.y += summand.y;
            this.z += summand.z;
            ++n2;
        }
    }

    public void add(double summand) {
        this.x += summand;
        this.y += summand;
        this.z += summand;
    }

    public double add(double factor, E3DVector summand) {
        if (summand != null) {
            this.x += factor * summand.x;
            this.y += factor * summand.y;
            this.z += factor * summand.z;
            return factor;
        }
        return 0.0;
    }

    public void add(double x, double y, double z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public E3DVector sum(E3DVector summand) {
        return this.clone(this.x + summand.x, this.y + summand.y, this.z + summand.z);
    }

    public E3DVector sum(E3DVector ... summands) {
        E3DVector sum = this.clone();
        sum.add(summands);
        return sum;
    }

    public E3DVector sum(double summand) {
        return this.clone(this.x + summand, this.y + summand, this.z + summand);
    }

    public E3DVector sum(double x, double y, double z) {
        return this.clone(this.x + x, this.y + y, this.z + z);
    }

    public E3DVector sum(double factor, E3DVector summand) {
        return this.clone(this.x + factor * summand.x, this.y + factor * summand.y, this.z + factor * summand.z);
    }

    public void substract(E3DVector v) {
        this.x -= v.x;
        this.y -= v.y;
        this.z -= v.z;
    }

    public void substract(double d) {
        this.x -= d;
        this.y -= d;
        this.z -= d;
    }

    public void substract(double x, double y, double z) {
        this.x -= x;
        this.y -= y;
        this.z -= z;
    }

    public double substract(double factor, E3DVector summand) {
        if (summand != null) {
            this.x -= factor * summand.x;
            this.y -= factor * summand.y;
            this.z -= factor * summand.z;
            return factor;
        }
        return 0.0;
    }

    public E3DVector diff(E3DVector v) {
        return this.clone(this.x - v.x, this.y - v.y, this.z - v.z);
    }

    public E3DVector diff(double d) {
        return this.clone(this.x - d, this.y - d, this.z - d);
    }

    public E3DVector diff(double x, double y, double z) {
        return this.clone(this.x - x, this.y - y, this.z - z);
    }

    public E3DVector diff(double factor, E3DVector summand) {
        return this.clone(this.x - factor * summand.x, this.y - factor * summand.y, this.z - factor * summand.z);
    }

    public void multiplicate(E3DVector multiplicator) {
        this.x *= multiplicator.x;
        this.y *= multiplicator.y;
        this.z *= multiplicator.z;
    }

    public void multiplicate(double multiplicator) {
        this.x *= multiplicator;
        this.y *= multiplicator;
        this.z *= multiplicator;
    }

    public void multiplicate(double x, double y, double z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public E3DVector product(E3DVector multiplicator) {
        return this.clone(this.x * multiplicator.x, this.y * multiplicator.y, this.z * multiplicator.z);
    }

    public E3DVector product(double x, double y, double z) {
        return this.clone(this.x * x, this.y * y, this.z * z);
    }

    public E3DVector product(double multiplicator) {
        return this.clone(this.x * multiplicator, this.y * multiplicator, this.z * multiplicator);
    }

    public void divide(E3DVector divsior) {
        this.x /= divsior.x;
        this.y /= divsior.y;
        this.z /= divsior.z;
    }

    public void divide(double divisor) {
        this.x /= divisor;
        this.y /= divisor;
        this.z /= divisor;
    }

    public void divide(double x, double y, double z) {
        this.x /= x;
        this.y /= y;
        this.z /= z;
    }

    public E3DVector quotient(E3DVector divisor) {
        return this.clone(this.x / divisor.x, this.y / divisor.y, this.z / divisor.z);
    }

    public E3DVector quotient(double divisor) {
        return this.clone(this.x / divisor, this.y / divisor, this.z / divisor);
    }

    public E3DVector quotient(double x, double y, double z) {
        return this.clone(this.x / x, this.y / y, this.z / z);
    }

    public void cross(E3DVector v) {
        this.set(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public void cross(E3DVector u, E3DVector v) {
        this.set(u.y * v.z - u.z * v.y, u.z * v.x - u.x * v.z, u.x * v.y - u.y * v.x);
    }

    public void cross(double x, double y, double z) {
        this.set(this.y * z - this.z * y, this.z * x - this.x * z, this.x * y - this.y * x);
    }

    public E3DVector crossProduct(E3DVector v) {
        return this.clone(this.y * v.z - this.z * v.y, this.z * v.x - this.x * v.z, this.x * v.y - this.y * v.x);
    }

    public double scalarProduct(E3DVector v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public double scalarProduct(double x, double y, double z) {
        return this.x * x + this.y * y + this.z * z;
    }

    public E3DVector mean(E3DVector v) {
        E3DVector mean = this.clone();
        mean.add(v);
        mean.divide(2.0);
        return mean;
    }

    public E3DVector max(E3DVector v) {
        E3DVector max = this.clone();
        max.x = Math.max(this.x, v.x);
        max.y = Math.max(this.y, v.y);
        max.z = Math.max(this.z, v.z);
        return max;
    }

    public E3DVector min(E3DVector v) {
        E3DVector min = this.clone();
        min.x = Math.min(this.x, v.x);
        min.y = Math.min(this.y, v.y);
        min.z = Math.min(this.z, v.z);
        return min;
    }

    public double mean() {
        return (this.x + this.y + this.z) / 3.0;
    }

    public double max() {
        return MathUtils.max(this.x, this.y, this.z);
    }

    public double min() {
        return MathUtils.min(this.x, this.y, this.z);
    }

    public void mirror(E3DVector v) {
        double dot = v.x * this.x + v.y * this.y + v.z * this.z;
        if (dot != 0.0) {
            double u = -2.0 * dot / v.squareLength();
            this.x += u * v.x;
            this.y += u * v.y;
            this.z += u * v.z;
        }
    }

    public E3DVector mirrored(E3DVector v) {
        double dot = v.x * this.x + v.y * this.y + v.z * this.z;
        if (dot == 0.0) {
            return this.clone(this.x, this.y, this.z);
        }
        double u = -2.0 * dot / v.squareLength();
        return this.clone(this.x + u * v.x, this.y + u * v.y, this.z + u * v.z);
    }

    public void mirrorPoint(E3DVector v) {
        this.x = v.x - (this.x - v.x);
        this.y = v.y - (this.y - v.y);
        this.z = v.z - (this.z - v.z);
    }

    public E3DVector mirroredPoint(E3DVector v) {
        return this.clone(v.x - (this.x - v.x), v.y - (this.y - v.y), v.z - (this.z - v.z));
    }

    public void mirrorPoint(E3DVector v, double stretch) {
        this.x = v.x - stretch * (this.x - v.x);
        this.y = v.y - stretch * (this.y - v.y);
        this.z = v.z - stretch * (this.z - v.z);
    }

    public E3DVector mirroredPoint(E3DVector v, double stretch) {
        return this.clone(v.x - stretch * (this.x - v.x), v.y - stretch * (this.y - v.y), v.z - stretch * (this.z - v.z));
    }

    public E3DVector orthogonalXY() {
        if (this.z == 0.0 && this.x == 0.0 && this.y == 0.0) {
            return this.clone(0.0, 0.0, 0.0);
        }
        if (this.x == 0.0 && this.y == 0.0) {
            return this.clone(1.0, 1.0, 0.0);
        }
        if (this.z == 0.0) {
            return this.clone(0.0, 0.0, 1.0);
        }
        return this.clone(this.x, this.y, (this.x * this.x + this.y * this.y) / -this.z);
    }

    public E3DVector orthogonalXZ() {
        if (this.z == 0.0 && this.x == 0.0 && this.y == 0.0) {
            return this.clone(0.0, 0.0, 0.0);
        }
        if (this.x == 0.0 && this.z == 0.0) {
            return this.clone(1.0, 0.0, 1.0);
        }
        if (this.y == 0.0) {
            return this.clone(0.0, 1.0, 0.0);
        }
        return this.clone(this.x, (this.x * this.x + this.z * this.z) / -this.y, this.z);
    }

    public E3DVector orthogonalYZ() {
        if (this.z == 0.0 && this.x == 0.0 && this.y == 0.0) {
            return this.clone(0.0, 0.0, 0.0);
        }
        if (this.y == 0.0 && this.z == 0.0) {
            return this.clone(0.0, 1.0, 1.0);
        }
        if (this.x == 0.0) {
            return this.clone(1.0, 0.0, 0.0);
        }
        return this.clone((this.y * this.y + this.z * this.z) / -this.x, this.y, this.z);
    }

    public void orthogonalXY(E3DVector v) {
        if (v.z == 0.0 && v.x == 0.0 && v.y == 0.0) {
            this.set(0.0, 0.0, 0.0);
        } else if (v.x == 0.0 && v.y == 0.0) {
            this.set(1.0, 1.0, 0.0);
        } else if (v.z == 0.0) {
            this.set(0.0, 0.0, 1.0);
        } else {
            this.set(v.x, v.y, (v.x * v.x + v.y * v.y) / -v.z);
        }
    }

    public void orthogonalXZ(E3DVector v) {
        if (v.z == 0.0 && v.x == 0.0 && v.y == 0.0) {
            this.set(0.0, 0.0, 0.0);
        } else if (v.x == 0.0 && v.z == 0.0) {
            this.set(1.0, 0.0, 1.0);
        } else if (v.y == 0.0) {
            this.set(0.0, 1.0, 0.0);
        } else {
            this.set(v.x, (v.x * v.x + v.z * v.z) / -v.y, v.z);
        }
    }

    public void orthogonalYZ(E3DVector v) {
        if (v.z == 0.0 && v.x == 0.0 && v.y == 0.0) {
            this.set(0.0, 0.0, 0.0);
        } else if (v.y == 0.0 && v.z == 0.0) {
            this.set(0.0, 1.0, 1.0);
        } else if (v.x == 0.0) {
            this.set(1.0, 0.0, 0.0);
        } else {
            this.set((v.y * v.y + v.z * v.z) / -v.x, v.y, v.z);
        }
    }

    public String toString() {
        return "(" + mr_decFormat.format(this.x) + ", " + mr_decFormat.format(this.y) + ", " + mr_decFormat.format(this.z) + ")";
    }
}

