/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean;

import e3d.euclidean.E3DVector;

public class E3DTangent
implements Cloneable {
    public final E3DVector point;
    public final E3DVector normal;

    public E3DTangent() {
        this.point = new E3DVector();
        this.normal = new E3DVector();
    }

    public E3DTangent(E3DVector point, E3DVector normal) {
        this.point = point.clone();
        this.normal = normal.clone();
    }

    public E3DTangent(E3DTangent tangent) {
        this.point = tangent.point.clone();
        this.normal = tangent.normal.clone();
    }

    public E3DTangent clone() {
        return new E3DTangent(this);
    }

    public void set(E3DVector point, E3DVector normal) {
        point.set(point);
        normal.set(normal);
    }

    public void set(E3DTangent tangent) {
        this.point.set(tangent.point);
        this.normal.set(tangent.normal);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof E3DTangent)) {
            return false;
        }
        return this.point.equals(((E3DTangent)object).point) && this.normal.equals(((E3DTangent)object).normal);
    }

    public int hashCode() {
        return this.point.hashCode() + this.normal.hashCode();
    }

    public int objectHashCode() {
        return super.hashCode();
    }

    public boolean isValid() {
        return this.point.isValid() && this.normal.isValid();
    }

    public int direction(E3DVector p) {
        double d = this.point.scalarProduct(p) - this.normal.scalarProduct(p);
        if (d > 0.0) {
            return 1;
        }
        if (d < 0.0) {
            return -1;
        }
        return 0;
    }

    public E3DTangent mean(E3DTangent tangent) {
        E3DTangent mean = this.clone();
        mean.point.add(tangent.point);
        mean.point.divide(2.0);
        mean.normal.along(tangent.normal);
        mean.normal.norm(tangent.normal.length());
        mean.normal.add(tangent.normal);
        return mean;
    }
}

