/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DVector;

public class E3DSphere
implements Cloneable {
    public final E3DVector center = new E3DVector();
    public double radius;

    public E3DSphere() {
    }

    public E3DSphere(E3DVector center, double radius) {
        this.set(center, radius);
    }

    public E3DSphere(E3DSphere sphere) {
        this.center.set(sphere.center);
        this.radius = sphere.radius;
    }

    public E3DSphere clone() {
        return new E3DSphere(this);
    }

    public void set(E3DVector center, double radius) {
        this.center.set(center);
        this.radius = radius;
    }

    public void set(E3DSphere sphere) {
        this.center.set(sphere.center);
        this.radius = sphere.radius;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof E3DSphere)) {
            return false;
        }
        E3DSphere s = (E3DSphere)o;
        return this.radius == s.radius && this.center.equals(s.center);
    }

    public int hashCode() {
        return Double.valueOf(this.radius).hashCode() + this.center.hashCode();
    }

    public boolean isValid() {
        return this.center.isValid() && !Double.isNaN(this.radius) && !Double.isInfinite(this.radius);
    }

    public E3DVector[] intersections(E3DLine line) {
        return line.intersections(this);
    }

    public double dist(E3DVector point) {
        return this.center.dist(point) - this.radius;
    }

    public double azimuth(E3DVector point) {
        E3DVector p = point.diff(this.center);
        return Math.atan2(p.y, p.x);
    }

    public double polar(E3DVector point) {
        E3DVector p = point.diff(this.center);
        return 1.5707963267948966 - Math.atan(p.z / Math.sqrt(p.x * p.x + p.y * p.y));
    }

    public E3DVector point(double azimut, double polar) {
        return new E3DVector(this.radius * Math.sin(polar) * Math.cos(azimut), this.radius * Math.sin(polar) * Math.sin(azimut), this.radius * Math.cos(polar));
    }

    public void point(double azimut, double polar, E3DVector point) {
        point.set(this.radius * Math.sin(polar) * Math.cos(azimut), this.radius * Math.sin(polar) * Math.sin(azimut), this.radius * Math.cos(polar));
    }
}

