/*
 * Decompiled with CFR 0.152.
 */
package e3d.euclidean;

import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DVector;

public class E3DEllipsoid
implements Cloneable {
    public final E3DVector center = new E3DVector();
    public final E3DVector radii = new E3DVector();

    public E3DEllipsoid() {
    }

    public E3DEllipsoid(E3DVector center, E3DVector radii) {
        this.set(center, radii);
    }

    public E3DEllipsoid(E3DEllipsoid sphere) {
        this.center.set(sphere.center);
        this.radii.set(sphere.radii);
    }

    public E3DEllipsoid clone() {
        return new E3DEllipsoid(this);
    }

    public void set(E3DVector center, E3DVector radii) {
        this.center.set(center);
        this.radii.set(radii);
    }

    public void set(E3DEllipsoid sphere) {
        this.center.set(sphere.center);
        this.radii.set(sphere.radii);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof E3DEllipsoid)) {
            return false;
        }
        E3DEllipsoid e = (E3DEllipsoid)o;
        return this.radii.equals(e.radii) && this.center.equals(e.center);
    }

    public int hashCode() {
        return this.radii.hashCode() + this.center.hashCode();
    }

    public boolean isValid() {
        return this.center.isValid() && this.radii.isValid();
    }

    public double intersection(E3DLine ray) {
        return ray.intersection(this);
    }

    public double azimuth(E3DVector point) {
        E3DVector p = point.diff(this.center);
        return Math.atan2(p.y, p.x);
    }

    public double polar(E3DVector point) {
        E3DVector p = point.diff(this.center);
        return 1.5707963267948966 - Math.atan(p.z / Math.sqrt(p.x * p.x + p.y * p.y));
    }

    public E3DVector point(double azimut, double polar) {
        return new E3DVector(this.radii.x * Math.sin(polar) * Math.cos(azimut), this.radii.y * Math.sin(polar) * Math.sin(azimut), this.radii.z * Math.cos(polar));
    }
}

