/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Bezier;
import e3d.bezier.Needle;
import e3d.bezier.NeedleMesh;
import e3d.bezier.NeedleMeshes;
import e3d.bezier.PointHood;
import e3d.bezier.PointMesh;
import e3d.bezier.PointMeshes;
import e3d.bezier.Position;
import e3d.bezier.Surface;
import e3d.euclidean.transformations.E3DTransformation;
import e3d.texture.E3DTextureFile;
import e3d.utils.Tagger;
import e3d.visualization.util.E3DBoundingBox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class Surfaces
extends Vector<Surface> {
    private static final long serialVersionUID = 1L;
    public Tagger<Object> tagger = new Tagger();
    private static final int V_SPLIT = 1;
    private static final int H_SPLIT = 2;

    public Surfaces() {
    }

    public Surfaces(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Surfaces transformed(E3DTransformation transformation) {
        Surfaces transformed = new Surfaces(this.size());
        for (Surface surface : this) {
            Surface trans = surface.transformed(transformation);
            transformed.add(trans);
            if (this.tagger == null) continue;
            transformed.tagger.addTags((Object)trans, this.tagger.getTags(surface));
        }
        return transformed;
    }

    public E3DBoundingBox getBounds() {
        E3DBoundingBox bounds = new E3DBoundingBox();
        bounds.x0 = Double.POSITIVE_INFINITY;
        bounds.y0 = Double.POSITIVE_INFINITY;
        bounds.z0 = Double.POSITIVE_INFINITY;
        bounds.x1 = Double.NEGATIVE_INFINITY;
        bounds.y1 = Double.NEGATIVE_INFINITY;
        bounds.z1 = Double.NEGATIVE_INFINITY;
        for (Surface surface : this) {
            surface.getBounds(bounds);
        }
        return bounds;
    }

    public void add(NeedleMeshes meshes, Tagger<Object> tagger) {
        if (meshes != null) {
            for (NeedleMesh mesh : meshes) {
                this.add(mesh, tagger);
            }
        }
    }

    public void add(NeedleMesh mesh, Tagger<Object> tagger) {
        double roundness = mesh.getRoundness();
        int width = mesh.width();
        int height = mesh.height();
        if (roundness == 0.0) {
            roundness = 1.0;
        }
        Set<String> tags = tagger.getTags(mesh);
        double cols = width - 1;
        double rows = height - 1;
        int y = 1;
        while (y < height) {
            int x = 1;
            while (x < width) {
                E3DTextureFile file = mesh.getTexture() == null ? null : new E3DTextureFile(mesh.getTexture().getPath(), (double)(x - 1) / cols, (double)(y - 1) / rows, 1.0 / cols, 1.0 / rows);
                Needle needle1 = (Needle)mesh.get(x - 1, y - 1);
                Needle needle2 = (Needle)mesh.get(x, y - 1);
                Needle needle3 = (Needle)mesh.get(x, y);
                Needle needle4 = (Needle)mesh.get(x - 1, y);
                if (needle1 != null && needle2 != null && needle3 != null && needle4 != null) {
                    Bezier bezier = new Bezier(needle1, needle2, needle3, needle4, roundness, roundness, roundness, roundness, mesh.getColor(), mesh.getMaterial(), file);
                    this.add(bezier);
                    this.tagger.addTags((Object)bezier, tags);
                }
                ++x;
            }
            ++y;
        }
    }

    public void add(PointMeshes meshes) {
        if (meshes != null) {
            for (PointMesh mesh : meshes) {
                this.add(mesh);
            }
        }
    }

    public void addAsPointHoods(PointMeshes meshes, Tagger<Object> tagger) {
        if (meshes != null) {
            Tiling tiling = this.createTiling(meshes);
            this.addAsPointHoods(tiling, tagger);
        }
    }

    private void addAsPointHoods(Tiling tiling, Tagger<Object> tagger) {
        for (Tile m : tiling.tiles) {
            PointHood hood = this.createHood(m, tiling);
            this.tagger.addTags((Object)hood, tagger.getTags(m.surface));
            if (m.surface.getTexture() != null) {
                hood.setTexture(new E3DTextureFile(m.surface.getTexture().getAbsolutePath(), m.x, m.y, m.width, m.height));
            }
            hood.setColor(m.surface.getColor());
            hood.setMaterial(m.surface.getMaterial());
            hood.setRoundness(m.surface.getRoundness());
            this.add(hood);
        }
    }

    public void addAsOverlappingMeshes(PointMeshes meshes, Tagger<Object> tagger) {
        if (meshes != null) {
            Tiling tiling = this.createTiling(meshes);
            this.addAsOverlappingMeshes(tiling, tagger);
        }
    }

    private void addAsOverlappingMeshes(Tiling tiling, Tagger<Object> tagger) {
        for (Tile m : tiling.tiles) {
            PointMesh mesh = this.createMesh(m, tiling);
            this.tagger.addTags((Object)mesh, tagger.getTags(m.surface));
            if (m.surface.getTexture() != null) {
                mesh.setTexture(new E3DTextureFile(m.surface.getTexture().getAbsolutePath(), m.x, m.y, m.width, m.height));
            }
            mesh.setColor(m.surface.getColor());
            mesh.setMaterial(m.surface.getMaterial());
            mesh.setRoundness(m.surface.getRoundness());
            this.add(mesh);
        }
    }

    private Tiling createTiling(PointMeshes meshes) {
        Tiling tiling = new Tiling();
        for (PointMesh mesh : meshes) {
            int w = mesh.width() - 1;
            int h = mesh.height() - 1;
            int r = 0;
            while (r < h) {
                int c = 0;
                while (c < w) {
                    Position nw = (Position)mesh.get(c, r);
                    Position ne = (Position)mesh.get(c + 1, r);
                    Position sw = (Position)mesh.get(c, r + 1);
                    Position se = (Position)mesh.get(c + 1, r + 1);
                    tiling.add(nw, ne, sw, se, mesh, (double)c / (double)w, (double)r / (double)h, 1.0 / (double)w, 1.0 / (double)h);
                    ++c;
                }
                ++r;
            }
        }
        return tiling;
    }

    private Tiling getTiling() {
        Tiling tiling = new Tiling();
        for (Surface surface : this) {
            if (surface instanceof PointHood) {
                PointHood hood = (PointHood)surface;
                if (hood.getTexture() != null) {
                    tiling.add(hood.corners[0][0].point, hood.corners[0][1].point, hood.corners[1][0].point, hood.corners[1][1].point, hood, hood.getTexture().getX(), hood.getTexture().getY(), hood.getTexture().getWidth(), hood.getTexture().getHeight());
                    continue;
                }
                tiling.add(hood.corners[0][0].point, hood.corners[0][1].point, hood.corners[1][0].point, hood.corners[1][1].point, hood, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            if (!(surface instanceof PointMesh)) continue;
            PointMesh mesh = (PointMesh)surface;
            if (mesh.getTexture() != null) {
                tiling.add((Position)mesh.get(1, 1), (Position)mesh.get(2, 1), (Position)mesh.get(1, 2), (Position)mesh.get(2, 2), mesh, mesh.getTexture().getX(), mesh.getTexture().getY(), mesh.getTexture().getWidth(), mesh.getTexture().getHeight());
                continue;
            }
            tiling.add((Position)mesh.get(1, 1), (Position)mesh.get(2, 1), (Position)mesh.get(1, 2), (Position)mesh.get(2, 2), mesh, 0.0, 0.0, 0.0, 0.0);
        }
        return tiling;
    }

    private PointHood createHood(Tile tile, Tiling tiling) {
        PointHood hood = new PointHood(tile.n.p1, tile.n.p2, tile.s.p2, tile.s.p1);
        Tile top = tiling.getOtherTile(tile.n, tile);
        Tile rgt = tiling.getOtherTile(tile.e, tile);
        Tile bot = tiling.getOtherTile(tile.s, tile);
        Tile lft = tiling.getOtherTile(tile.w, tile);
        Position nnw = Tile.getOppositePoint(top, tile.n.p2);
        Position nne = Tile.getOppositePoint(top, tile.n.p1);
        Position wnw = Tile.getOppositePoint(lft, tile.w.p1);
        Position ene = Tile.getOppositePoint(rgt, tile.e.p2);
        Position wsw = Tile.getOppositePoint(lft, tile.w.p2);
        Position ese = Tile.getOppositePoint(rgt, tile.e.p1);
        Position ssw = Tile.getOppositePoint(bot, tile.s.p1);
        Position sse = Tile.getOppositePoint(bot, tile.s.p2);
        hood.corners[0][0].addNeighbor(Surfaces.substNull(nnw, tile.n.p1), 0.0, 1.0);
        hood.corners[0][1].addNeighbor(Surfaces.substNull(nne, tile.n.p2), 0.0, 1.0);
        hood.corners[0][0].addNeighbor(Surfaces.substNull(wnw, tile.n.p1), 1.0, 0.0);
        hood.corners[0][1].addNeighbor(Surfaces.substNull(ene, tile.n.p2), 1.0, 0.0);
        hood.corners[1][0].addNeighbor(Surfaces.substNull(wsw, tile.s.p2), 1.0, 0.0);
        hood.corners[1][1].addNeighbor(Surfaces.substNull(ese, tile.s.p1), 1.0, 0.0);
        hood.corners[1][0].addNeighbor(Surfaces.substNull(ssw, tile.s.p2), 0.0, 1.0);
        hood.corners[1][1].addNeighbor(Surfaces.substNull(sse, tile.s.p1), 0.0, 1.0);
        Tile topLft = Surfaces.substNull(tiling.getOtherTile(new Edge(nnw, tile.n.p1), top), tiling.getOtherTile(new Edge(wnw, tile.n.p1), lft));
        Tile topRgt = Surfaces.substNull(tiling.getOtherTile(new Edge(nne, tile.n.p2), top), tiling.getOtherTile(new Edge(ene, tile.n.p2), rgt));
        Tile botLft = Surfaces.substNull(tiling.getOtherTile(new Edge(ssw, tile.s.p2), bot), tiling.getOtherTile(new Edge(wsw, tile.s.p2), lft));
        Tile botRgt = Surfaces.substNull(tiling.getOtherTile(new Edge(sse, tile.s.p1), bot), tiling.getOtherTile(new Edge(ese, tile.s.p1), rgt));
        Position nw = Tile.getOppositePoint(topLft, tile.n.p1);
        Position ne = Tile.getOppositePoint(topRgt, tile.n.p2);
        Position sw = Tile.getOppositePoint(botLft, tile.s.p2);
        Position se = Tile.getOppositePoint(botRgt, tile.s.p1);
        hood.corners[0][0].addNeighbor(Surfaces.substNull(nw, tile.n.p1), 1.0, 1.0);
        hood.corners[0][1].addNeighbor(Surfaces.substNull(ne, tile.n.p2), 1.0, 1.0);
        hood.corners[1][0].addNeighbor(Surfaces.substNull(sw, tile.s.p2), 1.0, 1.0);
        hood.corners[1][1].addNeighbor(Surfaces.substNull(se, tile.s.p1), 1.0, 1.0);
        return hood;
    }

    private PointMesh createMesh(Tile tile, Tiling tiling) {
        PointMesh mesh = new PointMesh(4, 4, 1);
        mesh.set(1, 1, tile.n.p1);
        mesh.set(2, 1, tile.n.p2);
        mesh.set(1, 2, tile.s.p2);
        mesh.set(2, 2, tile.s.p1);
        Tile top = tiling.getOtherTile(tile.n, tile);
        Tile rgt = tiling.getOtherTile(tile.e, tile);
        Tile bot = tiling.getOtherTile(tile.s, tile);
        Tile lft = tiling.getOtherTile(tile.w, tile);
        Position nnw = Tile.getOppositePoint(top, tile.n.p2);
        Position nne = Tile.getOppositePoint(top, tile.n.p1);
        Position wnw = Tile.getOppositePoint(lft, tile.w.p1);
        Position ene = Tile.getOppositePoint(rgt, tile.e.p2);
        Position wsw = Tile.getOppositePoint(lft, tile.w.p2);
        Position ese = Tile.getOppositePoint(rgt, tile.e.p1);
        Position ssw = Tile.getOppositePoint(bot, tile.s.p1);
        Position sse = Tile.getOppositePoint(bot, tile.s.p2);
        mesh.set(1, 0, nnw);
        mesh.set(2, 0, nne);
        mesh.set(0, 1, wnw);
        mesh.set(3, 1, ene);
        mesh.set(0, 2, wsw);
        mesh.set(3, 2, ese);
        mesh.set(1, 3, ssw);
        mesh.set(2, 3, sse);
        Tile topLft = Surfaces.substNull(tiling.getOtherTile(new Edge(nnw, tile.n.p1), top), tiling.getOtherTile(new Edge(wnw, tile.n.p1), lft));
        Tile topRgt = Surfaces.substNull(tiling.getOtherTile(new Edge(nne, tile.n.p2), top), tiling.getOtherTile(new Edge(ene, tile.n.p2), rgt));
        Tile botLft = Surfaces.substNull(tiling.getOtherTile(new Edge(ssw, tile.s.p2), bot), tiling.getOtherTile(new Edge(wsw, tile.s.p2), lft));
        Tile botRgt = Surfaces.substNull(tiling.getOtherTile(new Edge(sse, tile.s.p1), bot), tiling.getOtherTile(new Edge(ese, tile.s.p1), rgt));
        Position nw = Tile.getOppositePoint(topLft, tile.n.p1);
        Position ne = Tile.getOppositePoint(topRgt, tile.n.p2);
        Position sw = Tile.getOppositePoint(botLft, tile.s.p2);
        Position se = Tile.getOppositePoint(botRgt, tile.s.p1);
        mesh.set(0, 0, nw);
        mesh.set(3, 0, ne);
        mesh.set(0, 3, sw);
        mesh.set(3, 3, se);
        return mesh;
    }

    public Surfaces split(int bezRes, int minSplits, int maxSplits) {
        Surfaces converted = bezRes >= 2 ? this.convert(bezRes, this.tagger) : this;
        if (minSplits == 0 && maxSplits == 0) {
            return converted;
        }
        Tiling tiling = converted.getTiling();
        List<Position> irregularPoints = maxSplits > minSplits ? tiling.getIrregularPoints() : null;
        int split = 0;
        while (split < minSplits) {
            tiling = this.split(tiling, irregularPoints, SplitMode.ALL);
            tiling = this.correct(tiling, irregularPoints);
            ++split;
        }
        if (minSplits <= 0 && maxSplits > 0) {
            tiling = this.split(tiling, irregularPoints, SplitMode.NONE);
            tiling = this.correct(tiling, irregularPoints);
        }
        while (split < maxSplits) {
            tiling = this.split(tiling, irregularPoints, SplitMode.IRREGULAR);
            tiling = this.correct(tiling, irregularPoints);
            ++split;
        }
        Surfaces splitted = new Surfaces();
        splitted.addAsPointHoods(tiling, this.tagger);
        for (Surface surface : converted) {
            if (surface instanceof PointHood || surface instanceof PointMesh) continue;
            splitted.add(surface);
            splitted.tagger.addTags((Object)surface, this.tagger.getTags(surface));
        }
        return splitted;
    }

    private Surfaces convert(int resolution, Tagger<Object> tagger) {
        Surfaces converted = new Surfaces();
        Tiling tiling = new Tiling();
        for (Surface surface : this) {
            if (surface instanceof Bezier) {
                Bezier bezier = (Bezier)surface;
                tiling.add((Position)bezier.corners[0].id, (Position)bezier.corners[1].id, (Position)bezier.corners[3].id, (Position)bezier.corners[2].id, bezier, 0.0, 0.0, 1.0, 1.0);
                continue;
            }
            converted.add(surface);
            converted.tagger.addTags((Object)surface, tagger.getTags(surface));
        }
        int res = resolution - 1;
        Tagger<Object> tagger2 = new Tagger<Object>();
        PointMeshes meshes = new PointMeshes();
        HashMap<Edge, Position[]> edge2points = new HashMap<Edge, Position[]>();
        for (Tile tile : tiling.tiles) {
            int r;
            Bezier bezier = (Bezier)tile.surface;
            PointMesh mesh = bezier.getPointMesh(resolution, resolution);
            Position[] n = (Position[])edge2points.get(tile.n);
            if (n == null) {
                n = new Position[resolution];
                n[0] = tile.n.p1;
                n[res] = tile.n.p2;
                int c = 1;
                while (c < res) {
                    n[c] = (Position)mesh.get(c, 0);
                    ++c;
                }
                mesh.set(0, 0, n[0]);
                mesh.set(res, 0, n[res]);
                edge2points.put(tile.n, n);
            } else if (tile.n.p1 == n[0]) {
                int c = 0;
                while (c <= res) {
                    mesh.set(c, 0, n[c]);
                    ++c;
                }
            } else if (tile.n.p2 == n[0]) {
                int c = 0;
                while (c <= res) {
                    mesh.set(c, 0, n[res - c]);
                    ++c;
                }
            }
            Position[] e = (Position[])edge2points.get(tile.e);
            if (e == null) {
                e = new Position[resolution];
                e[0] = tile.e.p1;
                e[res] = tile.e.p2;
                int r2 = 1;
                while (r2 < res) {
                    e[r2] = (Position)mesh.get(res, r2);
                    ++r2;
                }
                mesh.set(res, 0, e[0]);
                mesh.set(res, res, e[res]);
                edge2points.put(tile.e, e);
            } else if (tile.e.p1 == e[0]) {
                int r3 = 0;
                while (r3 <= res) {
                    mesh.set(res, r3, e[r3]);
                    ++r3;
                }
            } else if (tile.e.p2 == e[0]) {
                int r4 = 0;
                while (r4 <= res) {
                    mesh.set(res, r4, e[res - r4]);
                    ++r4;
                }
            }
            Position[] s = (Position[])edge2points.get(tile.s);
            if (s == null) {
                s = new Position[resolution];
                s[0] = tile.s.p2;
                s[res] = tile.s.p1;
                int c = 1;
                while (c < res) {
                    s[c] = (Position)mesh.get(c, res);
                    ++c;
                }
                mesh.set(0, res, s[0]);
                mesh.set(res, res, s[res]);
                edge2points.put(tile.s, s);
            } else if (tile.s.p2 == s[0]) {
                int c = 0;
                while (c <= res) {
                    mesh.set(c, res, s[c]);
                    ++c;
                }
            } else if (tile.s.p1 == s[0]) {
                int c = 0;
                while (c <= res) {
                    mesh.set(c, res, s[res - c]);
                    ++c;
                }
            }
            Position[] w = (Position[])edge2points.get(tile.w);
            if (w == null) {
                w = new Position[resolution];
                w[0] = tile.w.p2;
                w[res] = tile.w.p1;
                r = 1;
                while (r < res) {
                    w[r] = (Position)mesh.get(0, r);
                    ++r;
                }
                mesh.set(0, 0, w[0]);
                mesh.set(0, res, w[res]);
                edge2points.put(tile.w, w);
            } else if (tile.w.p2 == w[0]) {
                r = 0;
                while (r <= res) {
                    mesh.set(0, r, w[r]);
                    ++r;
                }
            } else if (tile.w.p1 == w[0]) {
                r = 0;
                while (r <= res) {
                    mesh.set(0, r, w[res - r]);
                    ++r;
                }
            }
            mesh.setColor(bezier.getColor());
            mesh.setMaterial(bezier.getMaterial());
            mesh.setRoundness(bezier.getRoundness());
            mesh.setTexture(bezier.getTexture());
            tagger2.addTags((Object)mesh, tagger.getTags(bezier));
            meshes.add(mesh);
        }
        converted.addAsPointHoods(meshes, tagger2);
        return converted;
    }

    private Tiling split(Tiling tiling, List<Position> irregularPoints, SplitMode splitMode) {
        if (splitMode == SplitMode.IRREGULAR) {
            this.setSplitMarks(tiling, irregularPoints);
        }
        int k = tiling.tiles.size();
        HashMap<Position, Position> pos2pos = new HashMap<Position, Position>(k * 4);
        HashMap<Edge, Position> edge2mid = new HashMap<Edge, Position>(k * 4);
        HashMap<Tile, Position> tile2mid = new HashMap<Tile, Position>(k);
        Position[][] points3x3 = new Position[3][3];
        for (Tile m : tiling.tiles) {
            PointHood hood = this.createHood(m, tiling);
            int j = 0;
            while (j < 3) {
                int i = 0;
                while (i < 3) {
                    points3x3[j][i] = new Position();
                    hood.getPosition((double)i * 0.5, (double)j * 0.5, points3x3[j][i]);
                    ++i;
                }
                ++j;
            }
            pos2pos.put(m.n.p1, points3x3[0][0]);
            pos2pos.put(m.n.p2, points3x3[0][2]);
            pos2pos.put(m.s.p2, points3x3[2][0]);
            pos2pos.put(m.s.p1, points3x3[2][2]);
            edge2mid.put(m.n, points3x3[0][1]);
            edge2mid.put(m.e, points3x3[1][2]);
            edge2mid.put(m.s, points3x3[2][1]);
            edge2mid.put(m.w, points3x3[1][0]);
            tile2mid.put(m, points3x3[1][1]);
        }
        Tiling splitted = new Tiling();
        for (Tile t : tiling.tiles) {
            Position se;
            boolean horizontal;
            boolean vertical = splitMode != SplitMode.NONE && (splitMode == SplitMode.ALL || (t.markers & 1) != 0);
            boolean bl = horizontal = splitMode != SplitMode.NONE && (splitMode == SplitMode.ALL || (t.markers & 2) != 0);
            if (vertical && horizontal) {
                double wid = t.width / 2.0;
                double hei = t.height / 2.0;
                Position nw = (Position)pos2pos.get(t.n.p1);
                Position n = (Position)edge2mid.get(t.n);
                Position ne = (Position)pos2pos.get(t.n.p2);
                Position w = (Position)edge2mid.get(t.w);
                Position m = (Position)tile2mid.get(t);
                Position e = (Position)edge2mid.get(t.e);
                Position sw = (Position)pos2pos.get(t.s.p2);
                Position s = (Position)edge2mid.get(t.s);
                Position se2 = (Position)pos2pos.get(t.s.p1);
                splitted.add(nw, n, w, m, t.surface, t.x, t.y, wid, hei);
                splitted.add(n, ne, m, e, t.surface, t.x + wid, t.y, wid, hei);
                splitted.add(w, m, sw, s, t.surface, t.x, t.y + hei, wid, hei);
                splitted.add(m, e, s, se2, t.surface, t.x + wid, t.y + hei, wid, hei);
                continue;
            }
            if (vertical) {
                double hei = t.height / 2.0;
                Position nw = (Position)pos2pos.get(t.n.p1);
                Position ne = (Position)pos2pos.get(t.n.p2);
                Position w = (Position)edge2mid.get(t.w);
                Position e = (Position)edge2mid.get(t.e);
                Position sw = (Position)pos2pos.get(t.s.p2);
                se = (Position)pos2pos.get(t.s.p1);
                splitted.add(nw, ne, w, e, t.surface, t.x, t.y, t.width, hei);
                splitted.add(w, e, sw, se, t.surface, t.x, t.y + hei, t.width, hei);
                continue;
            }
            if (horizontal) {
                double wid = t.width / 2.0;
                Position nw = (Position)pos2pos.get(t.n.p1);
                Position n = (Position)edge2mid.get(t.n);
                Position ne = (Position)pos2pos.get(t.n.p2);
                Position sw = (Position)pos2pos.get(t.s.p2);
                Position s = (Position)edge2mid.get(t.s);
                se = (Position)pos2pos.get(t.s.p1);
                splitted.add(nw, n, sw, s, t.surface, t.x, t.y, wid, t.height);
                splitted.add(n, ne, s, se, t.surface, t.x + wid, t.y, wid, t.height);
                continue;
            }
            Position nw = Surfaces.substNull((Position)pos2pos.get(t.n.p1), t.n.p1);
            Position ne = Surfaces.substNull((Position)pos2pos.get(t.n.p2), t.n.p2);
            Position sw = Surfaces.substNull((Position)pos2pos.get(t.s.p2), t.s.p2);
            Position se3 = Surfaces.substNull((Position)pos2pos.get(t.s.p1), t.s.p1);
            splitted.add(nw, ne, sw, se3, t.surface, t.x, t.y, t.width, t.height);
        }
        this.changePoints(irregularPoints, pos2pos);
        return splitted;
    }

    private Tiling correct(Tiling tiling, List<Position> points) {
        int s = tiling.tiles.size();
        HashMap<Position, Position> pos2pos = new HashMap<Position, Position>(s);
        Position[][] points2x2 = new Position[2][2];
        for (Tile m : tiling.tiles) {
            PointHood hood = this.createHood(m, tiling);
            int j = 0;
            while (j < 2) {
                int i = 0;
                while (i < 2) {
                    points2x2[j][i] = new Position();
                    hood.getPosition(i, j, points2x2[j][i]);
                    points2x2[j][i].mirrorPoint(hood.corners[j][i].point, 1.5);
                    ++i;
                }
                ++j;
            }
            pos2pos.put(m.n.p1, points2x2[0][0]);
            pos2pos.put(m.n.p2, points2x2[0][1]);
            pos2pos.put(m.s.p2, points2x2[1][0]);
            pos2pos.put(m.s.p1, points2x2[1][1]);
        }
        Tiling corrected = new Tiling();
        for (Tile t : tiling.tiles) {
            Position nw = Surfaces.substNull((Position)pos2pos.get(t.n.p1), t.n.p1);
            Position ne = Surfaces.substNull((Position)pos2pos.get(t.n.p2), t.n.p2);
            Position sw = Surfaces.substNull((Position)pos2pos.get(t.s.p2), t.s.p2);
            Position se = Surfaces.substNull((Position)pos2pos.get(t.s.p1), t.s.p1);
            corrected.add(nw, ne, sw, se, t.surface, t.x, t.y, t.width, t.height);
        }
        this.changePoints(points, pos2pos);
        return corrected;
    }

    private void changePoints(List<Position> points, Map<Position, Position> pos2pos) {
        if (points != null) {
            int i = 0;
            while (i < points.size()) {
                Position p = points.get(i);
                Position q = pos2pos.get(p);
                if (q != null) {
                    points.set(i, q);
                }
                ++i;
            }
        }
    }

    private void setSplitMarks(Tiling tiling, List<Position> irregularPoints) {
        for (Position point : irregularPoints) {
            for (Tile tile : (List)tiling.point2tiles.get(point)) {
                tiling.markStraight(tile, tile.n, 2, 1);
                tiling.markStraight(tile, tile.e, 1, 2);
                tiling.markStraight(tile, tile.s, 2, 1);
                tiling.markStraight(tile, tile.w, 1, 2);
            }
        }
    }

    private static <X> X substNull(X value, X subst) {
        return value == null ? subst : value;
    }

    protected static class Edge {
        private final Position p1;
        private final Position p2;

        protected Edge(Position p1, Position p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        public boolean equals(Object obj) {
            return obj instanceof Edge && (obj == this || ((Edge)obj).p1.equals(this.p1) && ((Edge)obj).p2.equals(this.p2) || ((Edge)obj).p1.equals(this.p2) && ((Edge)obj).p2.equals(this.p1));
        }

        public int hashCode() {
            return (this.p1 == null ? 0 : this.p1.hashCode()) + (this.p2 == null ? 0 : this.p2.hashCode());
        }

        protected Position getOtherPoint(Position p) {
            if (this.p1 == p) {
                return this.p2;
            }
            if (this.p2 == p) {
                return this.p1;
            }
            return null;
        }

        protected static Position getOtherPoint(Edge e, Position p) {
            if (e == null) {
                return null;
            }
            return e.getOtherPoint(p);
        }
    }

    private static enum SplitMode {
        NONE,
        ALL,
        IRREGULAR;

    }

    protected static class Tile {
        private int markers;
        private final Edge n;
        private final Edge e;
        private final Edge s;
        private final Edge w;
        private final Surface surface;
        private final double x;
        private final double y;
        private final double width;
        private final double height;

        protected Tile(Position nw, Position ne, Position sw, Position se, Surface surface, double x, double y, double width, double height) {
            this.n = new Edge(nw, ne);
            this.e = new Edge(ne, se);
            this.s = new Edge(se, sw);
            this.w = new Edge(sw, nw);
            this.surface = surface;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        protected Edge getOppositeEdge(Edge edge) {
            if (edge.equals(this.n)) {
                return this.s;
            }
            if (edge.equals(this.s)) {
                return this.n;
            }
            if (edge.equals(this.w)) {
                return this.e;
            }
            if (edge.equals(this.e)) {
                return this.w;
            }
            return null;
        }

        protected Position getOppositePoint(Position point) {
            if (point == this.n.p1) {
                return this.s.p1;
            }
            if (point == this.n.p2) {
                return this.s.p2;
            }
            if (point == this.s.p1) {
                return this.n.p1;
            }
            if (point == this.s.p2) {
                return this.n.p2;
            }
            return null;
        }

        protected static Position getOppositePoint(Tile tile, Position p) {
            if (tile == null) {
                return null;
            }
            return tile.getOppositePoint(p);
        }
    }

    protected static class Tiling {
        private final List<Tile> tiles = new ArrayList<Tile>();
        private final Map<Edge, List<Tile>> edge2tiles = new HashMap<Edge, List<Tile>>();
        private final Map<Position, List<Tile>> point2tiles = new HashMap<Position, List<Tile>>();

        protected Tiling() {
        }

        protected void add(Position nw, Position ne, Position sw, Position se, Surface surface, double x, double y, double width, double height) {
            Tile tile = new Tile(nw, ne, sw, se, surface, x, y, width, height);
            this.tiles.add(tile);
            this.add(tile.n, tile);
            this.add(tile.e, tile);
            this.add(tile.s, tile);
            this.add(tile.w, tile);
            this.add(nw, tile);
            this.add(ne, tile);
            this.add(sw, tile);
            this.add(se, tile);
        }

        private void add(Edge edge, Tile tile) {
            List<Tile> tiles = this.edge2tiles.get(edge);
            if (tiles == null) {
                tiles = new ArrayList<Tile>();
                this.edge2tiles.put(edge, tiles);
            }
            tiles.add(tile);
        }

        private void add(Position point, Tile tile) {
            List<Tile> tiles = this.point2tiles.get(point);
            if (tiles == null) {
                tiles = new ArrayList<Tile>();
                this.point2tiles.put(point, tiles);
            }
            tiles.add(tile);
        }

        protected Tile getOtherTile(Edge edge, Tile tile) {
            List<Tile> tiles = this.edge2tiles.get(edge);
            if (tiles != null) {
                for (Tile t : tiles) {
                    if (t == tile) continue;
                    return t;
                }
            }
            return null;
        }

        protected List<Position> getIrregularPoints() {
            ArrayList<Position> irregularPoints = new ArrayList<Position>();
            for (Map.Entry<Position, List<Tile>> pointTiles : this.point2tiles.entrySet()) {
                if (pointTiles.getValue().size() <= 4) continue;
                irregularPoints.add(pointTiles.getKey());
            }
            return irregularPoints;
        }

        protected void markStraight(Tile tile, Edge edge, int mark0, int mark90) {
            Tile tile2 = tile;
            tile2.markers = tile2.markers & ~mark0;
            boolean d0 = edge.equals(tile.n) || edge.equals(tile.s);
            while (tile != null) {
                boolean d1;
                boolean bl = d1 = edge.equals(tile.n) || edge.equals(tile.s);
                if (d1 != d0) {
                    int m = mark0;
                    mark0 = mark90;
                    mark90 = m;
                    d0 = d1;
                }
                if ((tile.markers & mark0) != 0) break;
                Tile tile3 = tile;
                tile3.markers = tile3.markers | mark0;
                edge = tile.getOppositeEdge(edge);
                tile = this.getOtherTile(edge, tile);
            }
        }
    }
}

