/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.PointMesh;
import e3d.bezier.Position;
import e3d.euclidean.E3DTransform;
import e3d.euclidean.E3DVector;
import e3d.texture.E3DTextureFile;
import e3d.visualization.image.E3DImage;
import e3d.visualization.image.E3DImageSWT;
import e3d.visualization.util.E3DColor;
import e3d.visualization.util.E3DMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class LayerMesh
implements Cloneable {
    public List<File> layerFiles;
    public E3DVector size;
    public int bitMask;
    public int delta;
    public E3DTransform transform;
    public E3DColor color;
    public E3DMaterial material;
    public E3DTextureFile texture;

    public LayerMesh(List<File> layerFiles, E3DVector size, int bitMask, int delta, E3DTransform transform, E3DColor color, E3DMaterial material, E3DTextureFile texture) {
        this.layerFiles = layerFiles;
        this.size = size;
        this.bitMask = bitMask;
        this.delta = delta;
        this.transform = transform;
        this.color = color;
        this.material = material;
        this.texture = texture;
    }

    public LayerMesh(LayerMesh mesh) {
        this.layerFiles = new ArrayList<File>(mesh.layerFiles);
        this.size = mesh.size;
        this.bitMask = mesh.bitMask;
        this.delta = mesh.delta;
        this.transform = new E3DTransform(mesh.transform);
        this.color = new E3DColor(mesh.color.getRGB());
        this.material = mesh.material.clone();
        this.texture = mesh.texture;
    }

    public LayerMesh clone() {
        return new LayerMesh(this);
    }

    /*
     * WARNING - void declaration
     */
    public PointMesh getMesh() throws Exception {
        void var19_15;
        int h;
        ArrayList<E3DImageSWT> layers = new ArrayList<E3DImageSWT>(this.layerFiles.size());
        for (File file : this.layerFiles) {
            layers.add(new E3DImageSWT(file));
        }
        E3DImage layer0 = (E3DImage)layers.get(0);
        int w = layer0.getWidth();
        if (w * (h = layer0.getHeight()) <= 0) {
            return null;
        }
        double fx = this.size.x / (double)w;
        double dx = (double)(-w) / 2.0;
        double fy = this.size.y / (double)h;
        double dy = (double)(-h) / 2.0;
        double fz = this.size.z / (double)this.bitMask;
        double dz = (double)(-this.bitMask) / 2.0;
        PointMesh mesh1 = new PointMesh(w, h);
        PointMesh mesh2 = new PointMesh(w, h);
        boolean bl = false;
        while (var19_15 < h) {
            int i = 0;
            while (i < w) {
                mesh1.set(i, (int)var19_15, new Position(((double)i + dx) * fx, ((double)var19_15 + dy) * fy, 0.0));
                mesh2.set(i, (int)var19_15, new Position());
                ++i;
            }
            ++var19_15;
        }
        for (E3DImage e3DImage : layers) {
            int j2 = 0;
            while (j2 < h) {
                int j0 = Math.max(0, j2 - this.delta);
                int j1 = Math.min(h - 1, j2 + this.delta);
                int i = 0;
                while (i < w) {
                    int i0 = Math.max(0, i - this.delta);
                    int i1 = Math.min(w - 1, i + this.delta);
                    Position point2 = (Position)mesh2.get(i, j2);
                    Position point1 = (Position)mesh1.get(i, j2);
                    Position upper = (Position)mesh1.get(i, j0);
                    Position right = (Position)mesh1.get(i1, j2);
                    Position lower = (Position)mesh1.get(i, j1);
                    Position left = (Position)mesh1.get(i0, j2);
                    E3DVector horizonal = left.diff(right);
                    E3DVector vertical = upper.diff(lower);
                    E3DVector normal = vertical.crossProduct(horizonal);
                    normal.norm();
                    double offset = ((double)(e3DImage.getRGB(i, j2) & this.bitMask) + dz) * fz;
                    point2.x = point1.x - normal.x * offset;
                    point2.y = point1.y - normal.y * offset;
                    point2.z = point1.z - normal.z * offset;
                    ++i;
                }
                ++j2;
            }
            PointMesh toggle = mesh1;
            mesh1 = mesh2;
            mesh2 = toggle;
        }
        return mesh1;
    }
}

