/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.euclidean.E3DVector;

public class Bezier4x4P {
    protected final E3DVector point = new E3DVector();
    protected final E3DVector delta1 = new E3DVector();
    protected final E3DVector delta2 = new E3DVector();
    protected final E3DVector delta3 = new E3DVector();
    protected final E3DVector[][] delta = Bezier4x4P.vectors4x4();

    public Bezier4x4P() {
    }

    public Bezier4x4P(Bezier4x4P surface) {
        this.set(surface);
    }

    public Bezier4x4P(E3DVector[][] points, int cols, int rows) {
        this.set(points, cols, rows);
    }

    public void set(Bezier4x4P surface) {
        this.point.set(surface.point);
        this.delta1.set(surface.delta1);
        this.delta2.set(surface.delta2);
        this.delta3.set(surface.delta3);
        int y = 0;
        while (y < 4) {
            int x = 0;
            while (x < 4) {
                this.delta[x][y].set(surface.delta[x][y]);
                ++x;
            }
            ++y;
        }
    }

    public void set(E3DVector[][] points, int cols, int rows) {
        this.forwDiff(cols, rows, points);
    }

    public E3DVector currentPoint() {
        return this.point;
    }

    public E3DVector nextRow() {
        this.point.add(this.delta1);
        this.delta1.add(this.delta2);
        this.delta2.add(this.delta3);
        return this.point;
    }

    public E3DVector nextCol() {
        int y = 0;
        while (y < 4) {
            int x = 0;
            while (x < 3) {
                this.delta[x][y].add(this.delta[x + 1][y]);
                ++x;
            }
            ++y;
        }
        this.point.set(this.delta[0][0]);
        this.delta1.set(this.delta[0][1]);
        this.delta2.set(this.delta[0][2]);
        this.delta3.set(this.delta[0][3]);
        return this.point;
    }

    public static E3DVector getPoint(double x, double y, E3DVector[][] points) {
        double x2 = x * x;
        double x3 = x2 * x;
        double y2 = y * y;
        double y3 = y2 * y;
        double[][] s = new double[][]{{1.0, 0.0, 0.0, 0.0}, {-1.0 * x3 + 3.0 * x2 - 3.0 * x, 3.0 * x3 - 6.0 * x2 + 3.0 * x, -3.0 * x3 + 3.0 * x2, 1.0 * x3}, {-6.0 * x3 + 6.0 * x2, 18.0 * x3 - 12.0 * x2, -18.0 * x3 + 6.0 * x2, 6.0 * x3}, {-6.0 * x3, 18.0 * x3, -18.0 * x3, 6.0 * x3}};
        double[][] t = new double[][]{{1.0, -1.0 * y3 + 3.0 * y2 - 3.0 * y, -6.0 * y3 + 6.0 * y2, -6.0 * y3}, {0.0, 3.0 * y3 - 6.0 * y2 + 3.0 * y, 18.0 * y3 - 12.0 * y2, 18.0 * y3}, {0.0, -3.0 * y3 + 3.0 * y2, -18.0 * y3 + 6.0 * y2, -18.0 * y3}, {0.0, 1.0 * y3, 6.0 * y3, 6.0 * y3}};
        E3DVector[][] tDelta = Bezier4x4P.vectors4x4();
        E3DVector[][] sDelta = Bezier4x4P.vectors4x4();
        Bezier4x4P.matMult(points, t, tDelta);
        Bezier4x4P.matMult(s, tDelta, sDelta);
        sDelta[0][0].add(sDelta[1][0]);
        sDelta[0][1].add(sDelta[1][1]);
        sDelta[0][0].add(sDelta[0][1]);
        return sDelta[0][0];
    }

    protected void forwDiff(int xsteps, int ysteps, E3DVector[][] p) {
        double x = 1.0 / (double)(xsteps - 1);
        double x2 = x * x;
        double x3 = x2 * x;
        double y = 1.0 / (double)(ysteps - 1);
        double y2 = y * y;
        double y3 = y2 * y;
        double[][] s = new double[][]{{1.0, 0.0, 0.0, 0.0}, {-1.0 * x3 + 3.0 * x2 - 3.0 * x, 3.0 * x3 - 6.0 * x2 + 3.0 * x, -3.0 * x3 + 3.0 * x2, 1.0 * x3}, {-6.0 * x3 + 6.0 * x2, 18.0 * x3 - 12.0 * x2, -18.0 * x3 + 6.0 * x2, 6.0 * x3}, {-6.0 * x3, 18.0 * x3, -18.0 * x3, 6.0 * x3}};
        double[][] t = new double[][]{{1.0, -1.0 * y3 + 3.0 * y2 - 3.0 * y, -6.0 * y3 + 6.0 * y2, -6.0 * y3}, {0.0, 3.0 * y3 - 6.0 * y2 + 3.0 * y, 18.0 * y3 - 12.0 * y2, 18.0 * y3}, {0.0, -3.0 * y3 + 3.0 * y2, -18.0 * y3 + 6.0 * y2, -18.0 * y3}, {0.0, 1.0 * y3, 6.0 * y3, 6.0 * y3}};
        E3DVector[][] tdelta = Bezier4x4P.vectors4x4();
        Bezier4x4P.matMult(p, t, tdelta);
        Bezier4x4P.matMult(s, tdelta, this.delta);
        this.point.set(this.delta[0][0]);
        this.delta1.set(this.delta[0][1]);
        this.delta2.set(this.delta[0][2]);
        this.delta3.set(this.delta[0][3]);
    }

    private static void matMult(double[][] a, E3DVector[][] b, E3DVector[][] c) {
        int y = 0;
        while (y < 4) {
            int x = 0;
            while (x < 4) {
                c[x][y].set(0.0, 0.0, 0.0);
                int i = 0;
                while (i < 4) {
                    c[x][y].add(b[i][y].product(a[x][i]));
                    ++i;
                }
                ++x;
            }
            ++y;
        }
    }

    private static void matMult(E3DVector[][] a, double[][] b, E3DVector[][] c) {
        int y = 0;
        while (y < 4) {
            int x = 0;
            while (x < 4) {
                c[x][y].set(0.0);
                int i = 0;
                while (i < 4) {
                    c[x][y].add(a[x][i].product(b[i][y]));
                    ++i;
                }
                ++x;
            }
            ++y;
        }
    }

    protected static E3DVector[][] vectors4x4() {
        return new E3DVector[][]{{new E3DVector(), new E3DVector(), new E3DVector(), new E3DVector()}, {new E3DVector(), new E3DVector(), new E3DVector(), new E3DVector()}, {new E3DVector(), new E3DVector(), new E3DVector(), new E3DVector()}, {new E3DVector(), new E3DVector(), new E3DVector(), new E3DVector()}};
    }
}

