/*
 * Decompiled with CFR 0.152.
 */
package e3d.bezier;

import e3d.bezier.Bezier4x4P;
import e3d.bezier.BezierCurve2P2N;
import e3d.euclidean.E3DLine;
import e3d.euclidean.E3DPlane;
import e3d.euclidean.E3DTangent;
import e3d.euclidean.E3DVector;

public class Bezier4P4N
extends Bezier4x4P {
    private static double EPS = 1.0E-9;
    private static E3DVector RANDOMVECTOR = new E3DVector(Math.random(), Math.random(), Math.random());

    public Bezier4P4N() {
    }

    public Bezier4P4N(Bezier4x4P surface) {
        super.set(surface);
    }

    public Bezier4P4N(E3DTangent[] corners, double[] roundness, int cols, int rows) {
        this.set(corners, roundness, cols, rows);
    }

    public void set(E3DTangent[] corners, double[] roundness, int cols, int rows) {
        E3DVector[][] points4x4 = Bezier4P4N.get4x4Points(corners, roundness);
        this.forwDiff(cols, rows, points4x4);
    }

    public static E3DVector getPoint(double x, double y, E3DTangent[] corners, double[] roundness) {
        E3DVector[][] points4x4 = Bezier4P4N.get4x4Points(corners, roundness);
        return Bezier4x4P.getPoint(x, y, points4x4);
    }

    public static E3DVector[][] get4x4Points(E3DTangent[] corners, double[] roundness) {
        E3DVector[][] points4x4 = new E3DVector[4][4];
        points4x4[0][0] = new E3DVector(corners[0].point);
        points4x4[3][0] = new E3DVector(corners[1].point);
        points4x4[0][3] = new E3DVector(corners[3].point);
        points4x4[3][3] = new E3DVector(corners[2].point);
        Bezier4P4N.outer(corners, roundness, points4x4);
        Bezier4P4N.inner(points4x4, corners);
        return points4x4;
    }

    protected static void outer(E3DTangent[] corners, double[] roundness, E3DVector[][] points4x4) {
        BezierCurve2P2N curve = new BezierCurve2P2N();
        E3DVector[] normals = new E3DVector[]{Bezier4P4N.normal(corners[0].normal, corners[0].point, corners[1].point, corners[3].point, roundness[0]), Bezier4P4N.normal(corners[1].normal, corners[1].point, corners[0].point, corners[2].point, roundness[1]), Bezier4P4N.normal(corners[2].normal, corners[2].point, corners[1].point, corners[3].point, roundness[2]), Bezier4P4N.normal(corners[3].normal, corners[3].point, corners[0].point, corners[2].point, roundness[3])};
        E3DVector[] a = curve.intermediates(points4x4[0][0], normals[0], Bezier4P4N.subst0(roundness[0], 1.0), points4x4[3][0], normals[1], Bezier4P4N.subst0(roundness[1], 1.0));
        points4x4[1][0] = a[0];
        points4x4[2][0] = a[1];
        E3DVector[] b = curve.intermediates(points4x4[0][3], normals[3], Bezier4P4N.subst0(roundness[3], 1.0), points4x4[3][3], normals[2], Bezier4P4N.subst0(roundness[2], 1.0));
        points4x4[1][3] = b[0];
        points4x4[2][3] = b[1];
        E3DVector[] c = curve.intermediates(points4x4[0][0], normals[0], Bezier4P4N.subst0(roundness[0], 1.0), points4x4[0][3], normals[3], Bezier4P4N.subst0(roundness[3], 1.0));
        points4x4[0][1] = c[0];
        points4x4[0][2] = c[1];
        E3DVector[] d = curve.intermediates(points4x4[3][0], normals[1], Bezier4P4N.subst0(roundness[1], 1.0), points4x4[3][3], normals[2], Bezier4P4N.subst0(roundness[2], 1.0));
        points4x4[3][1] = d[0];
        points4x4[3][2] = d[1];
    }

    private static double subst0(double x, double s) {
        return x == 0.0 ? s : x;
    }

    protected static void inner(E3DVector[][] points4x4, E3DTangent[] corners) {
        points4x4[1][1] = Bezier4P4N.inner(points4x4[0][3], points4x4[0][1], points4x4[0][0], points4x4[1][0], points4x4[3][0], points4x4[3][1], points4x4[3][3], points4x4[1][3]);
        points4x4[2][1] = Bezier4P4N.inner(points4x4[0][0], points4x4[2][0], points4x4[3][0], points4x4[3][1], points4x4[3][3], points4x4[2][3], points4x4[0][3], points4x4[0][1]);
        points4x4[2][2] = Bezier4P4N.inner(points4x4[3][0], points4x4[3][2], points4x4[3][3], points4x4[2][3], points4x4[0][3], points4x4[0][2], points4x4[0][0], points4x4[2][0]);
        points4x4[1][2] = Bezier4P4N.inner(points4x4[3][3], points4x4[1][3], points4x4[0][3], points4x4[0][2], points4x4[0][0], points4x4[1][0], points4x4[3][0], points4x4[3][2]);
    }

    protected static E3DVector inner(E3DVector point1, E3DVector point12, E3DVector point2, E3DVector point23, E3DVector point3, E3DVector point34, E3DVector point4, E3DVector point14) {
        E3DVector p12 = point1.equals(point2) ? point14 : point12;
        E3DVector p23 = point2.equals(point3) ? point34 : point23;
        E3DVector v12 = p12.diff(point2);
        E3DVector v23 = p23.diff(point2);
        E3DLine cut = new E3DLine(point2, v12.sum(v23));
        double scale = 2.0 - v12.cosinus(v23);
        E3DVector x12 = point2.sum(v12.product(scale));
        E3DVector x23 = point2.sum(v23.product(scale));
        E3DVector a = cut.projection(x12);
        E3DVector b = cut.projection(x23);
        E3DVector innerPoint = a.sum(b);
        innerPoint.divide(2.0);
        return innerPoint;
    }

    @Deprecated
    protected static E3DVector inner(E3DVector point1, E3DVector point12, E3DVector point2, E3DVector point23, E3DVector point3, E3DVector point34, E3DVector point4, E3DVector point14, E3DVector normal1) {
        E3DVector p1 = point1;
        E3DVector p12 = point12;
        E3DVector p3 = point3;
        E3DVector p23 = point23;
        if (point1.equals(point2)) {
            p1 = point4;
            p12 = point14;
        }
        if (point2.equals(point3)) {
            p3 = point4;
            p23 = point34;
        }
        E3DLine line12 = new E3DLine(point2, point2.diff(p1));
        E3DLine line23 = new E3DLine(point2, point2.diff(p3));
        E3DVector i12 = line12.projection(p12);
        E3DVector i23 = line23.projection(p23);
        E3DVector perpendicular12 = i12.diff(p12);
        E3DVector perpendicular23 = i23.diff(p23);
        if (perpendicular12.squareLength() < EPS) {
            perpendicular12.set(normal1);
        }
        if (perpendicular23.squareLength() < EPS) {
            perpendicular23.set(normal1);
        }
        E3DPlane plane12 = new E3DPlane(perpendicular12, p12);
        E3DPlane plane23 = new E3DPlane(perpendicular23, p23);
        E3DVector innerPoint = null;
        E3DLine intersection = plane12.intersection(plane23);
        if (intersection.isValid()) {
            E3DVector v12 = p12.diff(point2);
            E3DVector v23 = p23.diff(point2);
            double factor = 2.0 - v12.cosinus(v23);
            E3DVector x12 = point2.sum(v12.product(factor));
            E3DVector x23 = point2.sum(v23.product(factor));
            innerPoint = intersection.projection(x12).sum(intersection.projection(x23)).quotient(2.0);
        }
        if (innerPoint == null || !innerPoint.isValid()) {
            innerPoint = p12.sum(p23).diff(point2);
        }
        return innerPoint;
    }

    protected static E3DVector normal(E3DVector normal, E3DVector point, E3DVector neighbor1, E3DVector neighbor2, double roundness) {
        if (!normal.isOrigin() && roundness != 0.0) {
            return normal;
        }
        if (point.equals(neighbor1)) {
            return RANDOMVECTOR.crossProduct(point.diff(neighbor2));
        }
        if (point.equals(neighbor2)) {
            return point.diff(neighbor1).crossProduct(RANDOMVECTOR);
        }
        return point.diff(neighbor1).crossProduct(point.diff(neighbor2));
    }
}

